Name:           powerpc-utils
Version:        1.2.21
%define base_release .3
Release:        2%{?dist}%{?base_release}
Summary:        Utilities for PowerPC platforms

Group:          System Environment/Base
License:        CPL
URL:            http://sourceforge.net/projects/%{name}/
Source0:        http://prdownloads.sourceforge.net/%{name}/%{name}-%{version}.tar.gz
Source1:        nvsetenv
Source999:      fivextra.tar.bz2
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
#BuildRequires:  zlib-devel doxygen automake librtas-devel libservicelog-devel >= 1.0.1-2
BuildRequires:  zlib-devel doxygen automake libservicelog-devel >= 1.0.1-2
BuildRequires:  librtas-devel >= 1.3.9

# should be fixed - libservicelog is not right name
Requires:       libservicelog bc which
ExclusiveArch:  ppc ppc64

%if "%{?dist}" == ".skiboot1_0"
Patch104988: bug-104988-bb-shutdown-use-reboot.patch
%endif

# This is done before release of F12
Obsoletes:      powerpc-utils-papr < 1.1.6-3
Provides:       powerpc-utils-papr = 1.1.6-3

Requires:       powerpc-utils-python

%description
Utilities for PowerPC platforms.

%package fivextra 
Summary: Test for %{name} package
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains testcases for %{name}.

%prep
%setup -q -n %{name}-%{version} -a 999

%if "%{?dist}" == ".skiboot1_0"
%patch104988 -p1
%endif

#Bug 100679 - regenerate configure to pick new changes in Makefile.am
aclocal
automake
autoconf

%build
export CFLAGS="$RPM_OPT_FLAGS -fno-strict-aliasing"
%configure
make %{?_smp_mflags}

pushd fivextra
make all
popd

%install
rm -rf $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT FILES= RCSCRIPTS=
install -m 755 %{SOURCE1} $RPM_BUILD_ROOT%{_sbindir}/nvsetenv

%define pkgdocdir %{_datadir}/doc/%{name}-%{version}
# move doc files
mkdir -p $RPM_BUILD_ROOT%{pkgdocdir}
install $RPM_BUILD_ROOT/usr/share/doc/packages/powerpc-utils/* -t $RPM_BUILD_ROOT%{pkgdocdir}
rm -rf $RPM_BUILD_ROOT/usr/share/doc/packages/powerpc-utils

# remove init script and perl script. They are deprecated
rm -rf $RPM_BUILD_ROOT/etc/init.d/ibmvscsis.sh $RPM_BUILD_ROOT/usr/sbin/vscsisadmin

# nvsetenv is just a wrapper to nvram
ln -s nvram.8.gz $RPM_BUILD_ROOT/%{_mandir}/man8/nvsetenv.8.gz

# Steps to package the powerpc-utils tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%{_sbindir}/nvsetenv
%{_sbindir}/nvram
%{_sbindir}/snap
%{_sbindir}/bootlist
%{_sbindir}/ofpathname
%{_sbindir}/ppc64_cpu
%{_sbindir}/lsdevinfo
%{_sbindir}/lsprop
%{_mandir}/man8/nvram.8*
%{_mandir}/man8/nvsetenv.8*
%{_mandir}/man8/snap.8*
%{_mandir}/man8/bootlist.8*
%{_mandir}/man8/ofpathname.8*

%{_sbindir}/update_flash
#bug 100679 - include the new script update_flash_nv in the rpm
%{_sbindir}/update_flash_nv
%{_sbindir}/activate_firmware
%{_sbindir}/set_poweron_time
%{_sbindir}/rtas_ibm_get_vpd
%{_sbindir}/serv_config
%{_sbindir}/uesensor
%{_sbindir}/hvcsadmin
%{_sbindir}/rtas_dump
%{_sbindir}/rtas_event_decode
%{_sbindir}/sys_ident
%{_sbindir}/drmgr
%{_sbindir}/lsslot
%{_sbindir}/ls-vdev
%{_sbindir}/ls-veth
%{_sbindir}/ls-vscsi
%{_sbindir}/lparstat
%{_sbindir}/pseries_platform

%{_bindir}/amsstat
%{_mandir}/man8/update_flash.8*
%{_mandir}/man8/activate_firmware.8*
%{_mandir}/man8/set_poweron_time.8*
%{_mandir}/man8/rtas_ibm_get_vpd.8*
%{_mandir}/man8/serv_config.8*
%{_mandir}/man8/uesensor.8*
%{_mandir}/man8/hvcsadmin.8*
%{_mandir}/man8/rtas_dump.8*
%{_mandir}/man8/sys_ident.8*
%{_mandir}/man8/lparstat.8*
%{_mandir}/man5/lparcfg.5*
%{_mandir}/man1/amsstat.1*
%{_mandir}/man8/lsslot.8*
%doc README COPYRIGHT Changelog

%files fivextra
%{prefix}

%post

%preun

%changelog
* Thu Aug 15 2013 baseuser@ibm.com
- Base-8.x spec file
