%define dbus_version 1.1
%define dbus_glib_version 0.94

%define glib2_version	2.24.0
%define wireless_tools_version 1:28-0pre9
%define libnl3_version 3.2.7
%define ppp_version 2.4.5

%define snapshot %{nil}
%define git_sha %{nil}
%define realversion 0.9.8.8

%if 0%{?fedora} && 0%{?fedora} < 17
%define systemd_dir /lib/systemd/system
%define udev_dir /lib/udev
%else
%define systemd_dir %{_prefix}/lib/systemd/system
%define udev_dir %{_prefix}/lib/udev
%endif

Name: NetworkManager
Summary: Network connection manager and user applications
Epoch: 1
Version: 0.9.8.8
%define base_release .1
Release: 2%{snapshot}%{?dist}%{?base_release}
# Base: exclude cross arches for this package
ExcludeArch: mips64 ppca2 ppc476 ppcnf
Group: System Environment/Base
License: GPLv2+
URL: http://www.gnome.org/projects/NetworkManager/

Source: %{name}-%{realversion}%{snapshot}%{git_sha}.tar.xz
Source1: NetworkManager.conf
Patch1: explain-dns1-dns2.patch
Patch2: rh978435-dns-none.patch
Patch3: rh1017884-dispatcher-crash-on-exit.patch
Patch4: rh1031196-agent-manager-crash.patch
Patch5: warn-no-DHCP-client.patch

BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

Requires(post): chkconfig
Requires(preun): chkconfig
Requires(post): systemd-sysv
Requires(post): systemd
Requires(preun): systemd
Requires(postun): systemd

Requires: dbus >= %{dbus_version}
Requires: dbus-glib >= %{dbus_glib_version}
Requires: glib2 >= %{glib2_version}
Requires: iproute
Requires: dhclient >= 12:4.1.0
Requires: wpa_supplicant >= 1:0.7.3-1
Requires: libnl3 >= %{libnl3_version}
Requires: %{name}-glib%{?_isa} = %{epoch}:%{version}-%{release}
Requires: ppp = %{ppp_version}
Requires: avahi-autoipd
Requires: dnsmasq
Requires: udev
Requires: iptables
Obsoletes: dhcdbd

Conflicts: NetworkManager-vpnc < 1:0.7.0.99-1
Conflicts: NetworkManager-openvpn < 1:0.7.0.99-1
Conflicts: NetworkManager-pptp < 1:0.7.0.99-1
Conflicts: NetworkManager-openconnect < 0:0.7.0.99-1
Conflicts: kde-plasma-networkmanagement < 1:0.9-0.49.20110527git.nm09

BuildRequires: dbus-devel >= %{dbus_version}
BuildRequires: dbus-glib-devel >= %{dbus_glib_version}
BuildRequires: wireless-tools-devel >= %{wireless_tools_version}
BuildRequires: glib2-devel >= %{glib2_version}
BuildRequires: gobject-introspection-devel >= 0.10.3
BuildRequires: gettext-devel
BuildRequires: /usr/bin/autopoint
BuildRequires: pkgconfig
BuildRequires: wpa_supplicant
BuildRequires: libnl3-devel >= %{libnl3_version}
BuildRequires: perl(XML::Parser)
BuildRequires: automake autoconf intltool libtool
BuildRequires: ppp = %{ppp_version}
BuildRequires: ppp-devel = %{ppp_version}
BuildRequires: nss-devel >= 3.11.7
BuildRequires: polkit-devel
BuildRequires: dhclient
BuildRequires: gtk-doc
BuildRequires: libudev-devel
BuildRequires: libuuid-devel
BuildRequires: libgudev1-devel >= 143
BuildRequires: vala-tools
BuildRequires: iptables
# No wimax or bluetooth on s390
%if ! 0%{?rhel}
%ifnarch s390 s390x
BuildRequires: wimax-devel
%endif
%endif
BuildRequires: systemd >= 200-3 systemd-devel
%if 0%{?fedora} && 0%{?fedora} < 17
# systemd.pc is in systemd-units for F16 and below
BuildRequires: systemd-units
%endif
BuildRequires: libsoup-devel

%description
NetworkManager is a system network service that manages your network devices
and connections, attempting to keep active network connectivity when available.
It manages ethernet, WiFi, mobile broadband (WWAN), and PPPoE devices, and
provides VPN integration with a variety of different VPN services.


%if ! 0%{?rhel}
%ifnarch s390 s390x
%package wimax
Summary: Intel WiMAX device support for NetworkManager
Group: System Environment/Base
Requires: wimax
Requires: %{name}%{?_isa} = %{epoch}:%{version}-%{release}

%description wimax
This package contains NetworkManager support for Intel WiMAX mobile broadband
devices.
%endif
%endif


%package devel
Summary: Libraries and headers for adding NetworkManager support to applications
Group: Development/Libraries
Requires: %{name}%{?_isa} = %{epoch}:%{version}-%{release}
Requires: dbus-devel >= %{dbus_version}
Requires: dbus-glib >= %{dbus_glib_version}
Requires: pkgconfig

%description devel
This package contains various headers accessing some NetworkManager functionality
from applications.


%package glib
Summary: Libraries for adding NetworkManager support to applications that use glib.
Group: Development/Libraries
Requires: dbus >= %{dbus_version}
Requires: dbus-glib >= %{dbus_glib_version}

%description glib
This package contains the libraries that make it easier to use some NetworkManager
functionality from applications that use glib.


%package glib-devel
Summary: Header files for adding NetworkManager support to applications that use glib.
Group: Development/Libraries
Requires: %{name}-devel%{?_isa} = %{epoch}:%{version}-%{release}
Requires: %{name}-glib%{?_isa} = %{epoch}:%{version}-%{release}
Requires: glib2-devel
Requires: pkgconfig
Requires: dbus-glib-devel >= %{dbus_glib_version}

%description glib-devel
This package contains the header and pkg-config files for development applications using
NetworkManager functionality from applications that use glib.


%prep
%setup -q -n NetworkManager-%{realversion}

%patch1 -p1 -b .explain-dns1-dns2
%patch2 -p1 -b .dns-none
%patch3 -p1 -b .dispatcher-exit-crash
%patch4 -p1 -b .agent-manager
%patch5 -p1 -b .warn-no-DHCP

%build

# back up pristine docs and use them instead of generated ones, which make
# multilib unhappy due to different timestamps in the generated content
%{__cp} -R docs ORIG-docs

#autopoint --force
#intltoolize --force
%configure \
	--disable-static \
	--with-dhclient=yes \
	--with-dhcpcd=no \
	--with-crypto=nss \
	--enable-more-warnings=yes \
	--enable-ppp=yes \
	--enable-vala=yes \
%if ! 0%{?rhel}
%ifnarch s390 s390x
	--enable-wimax=yes \
%endif
%endif
	--enable-gtk-doc \
	--enable-polkit=yes \
	--enable-modify-system=yes \
	--enable-concheck \
	--enable-bluez4 \
	--with-session-tracking=systemd \
	--with-suspend-resume=systemd \
	--with-systemdsystemunitdir=%{systemd_dir} \
	--with-udev-dir=%{udev_dir} \
	--with-system-ca-path=/etc/pki/tls/certs \
	--with-tests=yes \
	--with-pppd-plugin-dir=%{_libdir}/pppd/%{ppp_version} \
	--with-dist-version=%{version}-%{release}

make %{?_smp_mflags}

%install
%{__rm} -rf $RPM_BUILD_ROOT

# install NM
make install DESTDIR=$RPM_BUILD_ROOT

%{__cp} %{SOURCE1} $RPM_BUILD_ROOT%{_sysconfdir}/%{name}/

# create a VPN directory
%{__mkdir_p} $RPM_BUILD_ROOT%{_sysconfdir}/NetworkManager/VPN

# create a keyfile plugin system settings directory
%{__mkdir_p} $RPM_BUILD_ROOT%{_sysconfdir}/NetworkManager/system-connections

# create a dnsmasq.d directory
%{__mkdir_p} $RPM_BUILD_ROOT%{_sysconfdir}/NetworkManager/dnsmasq.d

%{__mkdir_p} $RPM_BUILD_ROOT%{_datadir}/gnome-vpn-properties

%{__mkdir_p} $RPM_BUILD_ROOT%{_localstatedir}/lib/NetworkManager

%find_lang %{name}

%{__rm} -f $RPM_BUILD_ROOT%{_libdir}/*.la
%{__rm} -f $RPM_BUILD_ROOT%{_libdir}/pppd/%{ppp_version}/*.la
%{__rm} -f $RPM_BUILD_ROOT%{_libdir}/NetworkManager/*.la

install -m 0755 test/.libs/nm-online %{buildroot}/%{_bindir}

# install the pristine docs
%{__cp} ORIG-docs/libnm-glib/html/* $RPM_BUILD_ROOT%{_datadir}/gtk-doc/html/libnm-glib/
%{__cp} ORIG-docs/libnm-util/html/* $RPM_BUILD_ROOT%{_datadir}/gtk-doc/html/libnm-util/

mkdir -p $RPM_BUILD_ROOT%{systemd_dir}/network-online.target.wants
ln -s ../NetworkManager-wait-online.service $RPM_BUILD_ROOT%{systemd_dir}/network-online.target.wants

%clean
%{__rm} -rf $RPM_BUILD_ROOT


%post
%systemd_post NetworkManager.service NetworkManager-wait-online.service NetworkManager-dispatcher.service
# workaround for bug 974811
%triggerun -- NetworkManager < 1:0.9.8.2-9
/bin/systemctl enable NetworkManager-dispatcher.service >/dev/null 2>&1 || :

%preun
if [ $1 -eq 0 ]; then
    # Package removal, not upgrade
    /bin/systemctl --no-reload disable NetworkManager.service >/dev/null 2>&1 || :

    # Don't kill networking entirely just on package remove
    #/bin/systemctl stop NetworkManager.service >/dev/null 2>&1 || :
fi
%systemd_preun NetworkManager-wait-online.service NetworkManager-dispatcher.service

%postun
%systemd_postun

%triggerun -- NetworkManager < 1:0.8.990
# Save the current service runlevel info
# User must manually run systemd-sysv-convert --apply NetworkManager
# to migrate them to systemd targets
/usr/bin/systemd-sysv-convert --save NetworkManager >/dev/null 2>&1 ||:
/bin/systemctl --no-reload enable NetworkManager.service >/dev/null 2>&1 ||:
# Run these because the SysV package being removed won't do them
/sbin/chkconfig --del NetworkManager >/dev/null 2>&1 || :
/bin/systemctl try-restart NetworkManager.service >/dev/null 2>&1 || :


%triggerun -- NetworkManager < 1:0.7.0-0.9.2.svn3614
/sbin/service NetworkManagerDispatcher stop >/dev/null 2>&1
/sbin/chkconfig --del NetworkManagerDispatcher
exit 0

%post	glib -p /sbin/ldconfig
%postun	glib -p /sbin/ldconfig


%files -f %{name}.lang
%defattr(-,root,root,0755)
%doc COPYING NEWS AUTHORS README CONTRIBUTING TODO
%{_sysconfdir}/dbus-1/system.d/org.freedesktop.NetworkManager.conf
%{_sysconfdir}/dbus-1/system.d/nm-dhcp-client.conf
%{_sysconfdir}/dbus-1/system.d/nm-avahi-autoipd.conf
%{_sysconfdir}/dbus-1/system.d/nm-dispatcher.conf
#%{_sysconfdir}/dbus-1/system.d/nm-ifcfg-rh.conf
%{_sbindir}/%{name}
%{_bindir}/nmcli
%{_datadir}/bash-completion/completions/nmcli
%dir %{_sysconfdir}/%{name}/
%dir %{_sysconfdir}/%{name}/dispatcher.d
%dir %{_sysconfdir}/%{name}/dnsmasq.d
%dir %{_sysconfdir}/%{name}/VPN
%config(noreplace) %{_sysconfdir}/%{name}/NetworkManager.conf
%{_bindir}/nm-tool
%{_bindir}/nm-online
%{_libexecdir}/nm-dhcp-client.action
%{_libexecdir}/nm-avahi-autoipd.action
%{_libexecdir}/nm-dispatcher.action
%dir %{_libdir}/NetworkManager
#%{_libdir}/NetworkManager/libnm-settings-plugin*.so
%{_mandir}/man1/*
%{_mandir}/man5/*
%{_mandir}/man8/*
%dir %{_localstatedir}/lib/NetworkManager
%dir %{_sysconfdir}/NetworkManager/system-connections
%{_datadir}/dbus-1/system-services/org.freedesktop.NetworkManager.service
%{_datadir}/dbus-1/system-services/org.freedesktop.nm_dispatcher.service
%{_libdir}/pppd/%{ppp_version}/nm-pppd-plugin.so
%{_datadir}/polkit-1/actions/*.policy
%{udev_dir}/rules.d/*.rules
# systemd stuff
%{systemd_dir}/NetworkManager.service
%{systemd_dir}/NetworkManager-wait-online.service
%{systemd_dir}/NetworkManager-dispatcher.service
%{systemd_dir}/network-online.target.wants/NetworkManager-wait-online.service

%if ! 0%{?rhel}
%ifnarch s390 s390x
%files wimax
%defattr(-,root,root,0755)
%{_libdir}/%{name}/libnm-device-plugin-wimax.so
%endif
%endif

%files devel
%defattr(-,root,root,0755)
%doc ChangeLog docs/api/html/*
%dir %{_includedir}/%{name}
%{_includedir}/%{name}/%{name}.h
%{_includedir}/%{name}/NetworkManagerVPN.h
%{_includedir}/%{name}/nm-version.h
%{_libdir}/pkgconfig/%{name}.pc
%dir %{_datadir}/gtk-doc/html/NetworkManager
%{_datadir}/gtk-doc/html/NetworkManager/*
%{_datadir}/vala/vapi/*.deps
%{_datadir}/vala/vapi/*.vapi

%files glib
%defattr(-,root,root,0755)
%{_libdir}/libnm-glib.so.*
%{_libdir}/libnm-glib-vpn.so.*
%{_libdir}/libnm-util.so.*
%{_libdir}/girepository-1.0/NetworkManager-1.0.typelib
%{_libdir}/girepository-1.0/NMClient-1.0.typelib

%files glib-devel
%defattr(-,root,root,0755)
%dir %{_includedir}/libnm-glib
%{_includedir}/libnm-glib/*.h
%{_includedir}/%{name}/nm-setting*.h
%{_includedir}/%{name}/nm-connection.h
%{_includedir}/%{name}/nm-utils-enum-types.h
%{_includedir}/%{name}/nm-utils.h
%{_libdir}/pkgconfig/libnm-glib.pc
%{_libdir}/pkgconfig/libnm-glib-vpn.pc
%{_libdir}/pkgconfig/libnm-util.pc
%{_libdir}/libnm-glib.so
%{_libdir}/libnm-glib-vpn.so
%{_libdir}/libnm-util.so
%{_datadir}/gir-1.0/NetworkManager-1.0.gir
%{_datadir}/gir-1.0/NMClient-1.0.gir
%dir %{_datadir}/gtk-doc/html/libnm-glib
%{_datadir}/gtk-doc/html/libnm-glib/*
%dir %{_datadir}/gtk-doc/html/libnm-util
%{_datadir}/gtk-doc/html/libnm-util/*

%changelog
* Sat Jan 25 2014 baseuser@ibm.com
- Base-f19.x spec file
