%if ! 0%{?base}
%global with_python3 1
%endif

%global modname oauthlib

Name:               python-oauthlib
Version:            0.6.0
%define base_release .1
Release:            2%{?dist}%{?base_release}
Summary:            An implementation of the OAuth request-signing logic

Group:              Development/Libraries
License:            BSD
URL:                http://pypi.python.org/pypi/oauthlib
Source0:            http://pypi.python.org/packages/source/o/%{modname}/%{modname}-%{version}.tar.gz

BuildArch:          noarch

BuildRequires:      python2-devel
BuildRequires:      python-setuptools

BuildRequires:      python-nose
BuildRequires:      python-crypto
BuildRequires:      python-unittest2
BuildRequires:      python-mock

Requires:           python-crypto


%if 0%{?with_python3}
BuildRequires:      python3-devel
BuildRequires:      python3-setuptools

BuildRequires:      python3-nose
BuildRequires:      python3-crypto
BuildRequires:      python3-mock
%endif

%description
OAuthLib is a generic utility which implements the logic of OAuth without
assuming a specific HTTP request object or web framework. Use it to graft
OAuth client support onto your favorite HTTP library, or provider support
onto your favourite web framework. If you're a maintainer of such a
library, write a thin veneer on top of OAuthLib and get OAuth support for
very little effort.

%if 0%{?with_python3}
%package -n python3-oauthlib
Summary:            An implementation of the OAuth request-signing logic
Group:              Development/Libraries

Requires:           python3-crypto

%description -n python3-oauthlib
OAuthLib is a generic utility which implements the logic of OAuth without
assuming a specific HTTP request object or web framework. Use it to graft
OAuth client support onto your favorite HTTP library, or provider support
onto your favourite web framework. If you're a maintainer of such a
library, write a thin veneer on top of OAuthLib and get OAuth support for
very little effort.
%endif

%prep
%setup -q -n %{modname}-%{version}

# Remove bundled egg-info in case it exists
rm -rf %{modname}.egg-info
%if 0%{?with_python3}
rm -rf %{py3dir}
cp -a . %{py3dir}
%endif

%build
%{__python2} setup.py build
%if 0%{?with_python3}
pushd %{py3dir}
%{__python3} setup.py build
popd
%endif

%install
%if 0%{?with_python3}
pushd %{py3dir}
%{__python3} setup.py install -O1 --skip-build --root=%{buildroot}
popd
%endif
%{__python2} setup.py install -O1 --skip-build --root=%{buildroot}

%check
%{__python2} setup.py test
%if 0%{?with_python3}
pushd %{py3dir}
%{__python3} setup.py test
popd
%endif

%files
%doc README.rst LICENSE
%{python2_sitelib}/%{modname}/
%{python2_sitelib}/%{modname}-%{version}*

%if 0%{?with_python3}
%files -n python3-oauthlib
%doc README.rst LICENSE
%{python3_sitelib}/%{modname}/
%{python3_sitelib}/%{modname}-%{version}-*
%endif

%changelog
* Tue Feb 11 2014 baseuser@ibm.com
- Base-f19.x spec file
