%define utempter_compat_ver 0.5.2

Summary: A privileged helper for utmp/wtmp updates
Name: libutempter
Version: 1.1.6
%define base_release .2
Release: 2%{?dist}%{?base_release}
License: LGPLv2+
Group: System Environment/Libraries
URL: ftp://ftp.altlinux.org/pub/people/ldv/utempter

Source0: ftp://ftp.altlinux.org/pub/people/ldv/utempter/%{name}-%{version}.tar.bz2
Source999: fivextra.tar.bz2

# Compile with PIE and RELRO flags.
Patch0: libutempter-pierelro.patch

Requires(pre): shadow-utils
Requires(post): /sbin/ldconfig
Requires(postun): /sbin/ldconfig

Provides: utempter = %{utempter_compat_ver}

%description
This library provides interface for terminal emulators such as
screen and xterm to record user sessions to utmp and wtmp files.

%package devel
Summary: Development environment for utempter
Group: Development/Libraries
Requires: %{name} = %{version}-%{release}

%description devel
This package contains development files required to build
utempter-based software.

%package fivextra
Summary: Test for %{name} package
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains testcases for %{name}

%prep
%setup -q -n %{name}-%{version} -a 999
%patch0 -p1 -b .pierelro

%build
make CC=%{__cc} CFLAGS="$RPM_OPT_FLAGS" libdir="%{_libdir}" libexecdir="%{_libexecdir}"

pushd fivextra
make CC=%{__cc} all
popd

%install
make install DESTDIR="$RPM_BUILD_ROOT" libdir="%{_libdir}" libexecdir="%{_libexecdir}"

# Steps to package the libutempter tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

find $RPM_BUILD_ROOT/%{fivdir}/%{name} \
-name '*.c' | xargs rm -rf

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

# FIXME: We might need to enable this part for backward compat with the
# Red Hat / Fedora 'utempter' package:
#
# mkdir -p %{_sbindir}
# ln -sf %{helperdir}/utempter %{_sbindir}/utempter


# NOTE: Static lib intentionally disabled.
rm -f $RPM_BUILD_ROOT%{_libdir}/*.a

%pre
{
    %{_sbindir}/groupadd -g 22 -r -f utmp || :
    %{_sbindir}/groupadd -g 35 -r -f utempter || :
}

%post -p /sbin/ldconfig
%postun -p /sbin/ldconfig

%files
%doc COPYING README
%{_libdir}/libutempter.so.0
%{_libdir}/libutempter.so.1.*
%dir %attr(755,root,utempter) %{_libexecdir}/utempter
%attr(2711,root,utmp) %{_libexecdir}/utempter/utempter
# FIXME: If a symlink is needed for compat here, uncomment the code in the
# install section and this as well:
#%{_sbindir}/utempter

%files devel
%{_includedir}/utempter.h
%{_libdir}/libutempter.so
%{_mandir}/man3/*

%files fivextra
%{prefix}
%changelog
* Thu May 16 2013 baseuser@ibm.com
- Base-8.x spec file
