Summary: Allows restricted root access for specified users
Name: sudo
Version: 1.8.6p7
%define base_release .2
Release: 2%{?dist}%{?base_release}
# Base: exclude cross arches for this package
ExcludeArch: mips64 ppca2 ppc476 ppcnf
License: ISC
Group: Applications/System
URL: http://www.courtesan.com/sudo/
Source0: http://www.courtesan.com/sudo/dist/sudo-%{version}.tar.gz
Source1: sudo-1.7.4p5-sudoers
Source2: sudo-1.7.4p5-sudo-ldap.conf
Source3: sudo-1.8.6p3-sudo.conf
Source999: fivextra.tar.bz2
Buildroot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
Requires: /etc/pam.d/system-auth, vim-minimal

BuildRequires: pam-devel
BuildRequires: groff
BuildRequires: openldap-devel
BuildRequires: flex
BuildRequires: bison
BuildRequires: automake autoconf libtool
BuildRequires: audit-libs-devel libcap-devel
BuildRequires: libselinux-devel
%{!?base:BuildRequires: sendmail}
BuildRequires: gettext
BuildRequires: zlib-devel

# don't strip
Patch1: sudo-1.6.7p5-strip.patch
# configure.in fix
Patch2: sudo-1.7.2p1-envdebug.patch
# show the editor being executed by `sudo -e' in audit messages
Patch3: sudo-1.8.6p3-auditeditor.patch
# fix manpage typo (#726634)
Patch4: sudo-1.8.6p3-mantypo.patch
# correct SELinux handling in sudoedit mode (#697775)
Patch5: sudo-1.8.6p3-sudoedit-selinux.patch
# [RFE] Fix visudo -s to be backwards compatible (#604297)
Patch6: sudo-1.8.6p3-aliaswarnonly.patch
# log failed user role changes (#665131)
Patch7: sudo-1.8.6p3-auditrolechange.patch
# 840980 - sudo creates a new parent process
# Adds cmnd_no_wait Defaults option
Patch8: sudo-1.8.6p3-nowaitopt.patch
# 876578 - erealloc3 error on sssd sudoHost netgroup mismatch
Patch9: sudo-1.8.6p3-emallocfail.patch
# 876208 - sudoRunAsUser #uid specification doesn't work
Patch10: sudo-1.8.6p3-ldap-sssd-usermatch.patch
# 879675 - sudo parse ldap.conf incorrectly
Patch11: sudo-1.8.6p3-ldapconfparse.patch
# 879633 - sudo + sssd + local user sends e-mail to administrator
Patch12: sudo-1.8.6p3-sssd-noise.patch
# 856901 - Defauts:!<user> syntax in sudoers doesn't seem to work as expected
Patch13: sudo-1.8.6p3-ALL-with-negation-manupdate.patch
# 947276 - Cannot set RLIMIT_NPROC to unlimited via pam_limits when running sudo
Patch14: sudo-1.8.6p3-nprocfix.patch
# 881258 - rpmdiff: added missing sudo.conf manpage
Patch15: sudo-1.8.6p7-sudoconfman.patch
# 881258 - rpmdiff: added missing sudo-ldap.conf manpage
Patch16: sudo-1.8.6p7-sudoldapconfman.patch
# 1026904 - Access granted with invalid sudoRunAsUser/sudoRunAsGroup
Patch17: sudo-1.8.6p3-strictuidgid.patch
# 1026890 - Improve error message
Patch18: sudo-1.8.6p3-netgrmatchtrace.patch
# 1007014 - sssd +netgroup sudoUser is always matched
Patch19: sudo-1.8.6p3-sssdfixes.patch
# 1026894 - sudo -u <user> sudo -l show error: glibc detected sudo: realloc(): invalid next size
Patch20: sudo-1.8.6p3-lbufexpandcode.patch
# 994566 - Warning in visudo: cycle in Host_Alias even without cycle
Patch21: sudo-1.8.6p3-cycledetect.patch

%description
Sudo (superuser do) allows a system administrator to give certain
users (or groups of users) the ability to run some (or all) commands
as root while logging all commands and arguments. Sudo operates on a
per-command basis.  It is not a replacement for the shell.  Features
include: the ability to restrict what commands a user may run on a
per-host basis, copious logging of each command (providing a clear
audit trail of who did what), a configurable timeout of the sudo
command, and the ability to use the same configuration file (sudoers)
on many different machines.

%package        devel
Summary:        Development files for %{name}
Group:          Development/Libraries
Requires:       %{name} = %{version}-%{release}

%description    devel
The %{name}-devel package contains header files developing sudo
plugins that use %{name}.

%package fivextra
Summary: FIV Tests for %{name}
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains the testcases built from the package for %{name} 

%prep
%setup -q -a 999

%patch1 -p1 -b .strip
%patch2 -p1 -b .envdebug
%patch3 -p1 -b .auditeditor
%patch4 -p1 -b .mantypo
%patch5 -p1 -b .sudoedit-selinux
%patch6 -p1 -b .aliaswarnonly
%patch7 -p1 -b .auditrolechange
%patch8 -p1 -b .nowaitopt
%patch9 -p1 -b .emallocfail
%patch10 -p1 -b .ldap-sssd-usermatch
%patch11 -p1 -b .ldapconfparse
%patch12 -p1 -b .sssd-noise
%patch13 -p1 -b .ALL-with-negation-manupdate
%patch14 -p1 -b .nprocfix
%patch15 -p1 -b .sudoconfman
%patch16 -p1 -b .sudoldapconfman
%patch17 -p1 -b .strictuidgid
%patch18 -p1 -b .netgrmatchtrace
%patch19 -p1 -b .sssdfixes
%patch20 -p1 -b .lbufexpandcode
%patch21 -p1 -b .cycledetect

%build
autoreconf -I m4 -fv --install

%ifarch s390 s390x sparc64
F_PIE=-fPIE
%else
F_PIE=-fpie
%endif

export CFLAGS="$RPM_OPT_FLAGS $F_PIE" LDFLAGS="-pie -Wl,-z,relro -Wl,-z,now" SHLIB_MODE=755

%configure \
        --prefix=%{_prefix} \
        --sbindir=%{_sbindir} \
        --libdir=%{_libdir} \
        --docdir=%{_datadir}/doc/%{name}-%{version} \
        --with-logging=syslog \
        --with-logfac=authpriv \
        --with-pam \
        --with-pam-login \
        --with-editor=/bin/vi \
        --with-env-editor \
        --with-ignore-dot \
        --with-tty-tickets \
        --with-ldap \
        --with-ldap-conf-file="%{_sysconfdir}/sudo-ldap.conf" \
        --with-selinux \
        --with-passprompt="[sudo] password for %p: " \
        --with-linux-audit \
        --with-sssd
#       --without-kerb5 \
#       --without-kerb4
make

pushd fivextra
make all
popd

%install
rm -rf $RPM_BUILD_ROOT
make install DESTDIR="$RPM_BUILD_ROOT" install_uid=`id -u` install_gid=`id -g` sudoers_uid=`id -u` sudoers_gid=`id -g`

chmod 755 $RPM_BUILD_ROOT%{_bindir}/* $RPM_BUILD_ROOT%{_sbindir}/*
# Update README.LDAP (#736653)
sed -i 's|/etc/ldap\.conf|%{_sysconfdir}/sudo-ldap.conf|g' README.LDAP

make install DESTDIR="$RPM_BUILD_ROOT" install_uid=`id -u` install_gid=`id -g` sudoers_uid=`id -u` sudoers_gid=`id -g`
chmod 755 $RPM_BUILD_ROOT%{_bindir}/* $RPM_BUILD_ROOT%{_sbindir}/* 
install -p -d -m 700 $RPM_BUILD_ROOT/var/db/sudo
install -p -d -m 750 $RPM_BUILD_ROOT/etc/sudoers.d
install -p -c -m 0440 %{SOURCE1} $RPM_BUILD_ROOT/etc/sudoers

install -p -c -m 0640 %{SOURCE3} $RPM_BUILD_ROOT/etc/sudo.conf
install -p -c -m 0640 %{SOURCE2} $RPM_BUILD_ROOT/%{_sysconfdir}/sudo-ldap.conf

# Remove execute permission on this script so we don't pull in perl deps
chmod -x $RPM_BUILD_ROOT%{_docdir}/sudo-*/sudoers2ldif

%find_lang sudo
%find_lang sudoers

cat sudo.lang sudoers.lang > sudo_all.lang
rm sudo.lang sudoers.lang

mkdir -p $RPM_BUILD_ROOT/etc/pam.d
cat > $RPM_BUILD_ROOT/etc/pam.d/sudo << EOF
#%%PAM-1.0
auth       include      system-auth
account    include      system-auth
password   include      system-auth
session    optional     pam_keyinit.so revoke
session    required     pam_limits.so
EOF

cat > $RPM_BUILD_ROOT/etc/pam.d/sudo-i << EOF
#%%PAM-1.0
auth       include      sudo
account    include      sudo
password   include      sudo
session    optional     pam_keyinit.so force revoke
session    required     pam_limits.so
EOF

# Steps to package the sudo tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

find $RPM_BUILD_ROOT/%{fivdir}/%{name} -name '*.c' | xargs rm -rf

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%clean
rm -rf $RPM_BUILD_ROOT

%files -f sudo_all.lang
%defattr(-,root,root)
%attr(0440,root,root) %config(noreplace) /etc/sudoers
%attr(0640,root,root) %config(noreplace) /etc/sudo.conf
%attr(0640,root,root) %config(noreplace) %{_sysconfdir}/sudo-ldap.conf
%attr(0750,root,root) %dir /etc/sudoers.d/
%config(noreplace) /etc/pam.d/sudo
%config(noreplace) /etc/pam.d/sudo-i
%dir /var/db/sudo
%attr(4111,root,root) %{_bindir}/sudo
%attr(4111,root,root) %{_bindir}/sudoedit
%attr(0111,root,root) %{_bindir}/sudoreplay
%attr(0755,root,root) %{_sbindir}/visudo
%attr(0755,root,root) %{_libexecdir}/sesh
%attr(0644,root,root) %{_libexecdir}/sudo_noexec.so
%attr(0644,root,root) %{_libexecdir}/sudoers.so
%{_mandir}/man5/sudoers.5*
%{_mandir}/man5/sudoers.ldap.5*
%{_mandir}/man5/sudo-ldap.conf.5*
%{_mandir}/man5/sudo.conf.5*
%{_mandir}/man8/sudo.8*
%{_mandir}/man8/sudoedit.8*
%{_mandir}/man8/sudoreplay.8*
%{_mandir}/man8/visudo.8*
%dir %{_docdir}/sudo-%{version}
%{_docdir}/sudo-%{version}/*

%files fivextra
%{prefix}

# Make sure permissions are ok even if we're updating
%post
/bin/chmod 0440 /etc/sudoers || :

%files devel
%defattr(-,root,root,-)
%doc plugins/sample/sample_plugin.c
%{_includedir}/sudo_plugin.h
%{_mandir}/man8/sudo_plugin.8*

%changelog
* Wed Jan 22 2014 baseuser@ibm.com
- Base-f19.x spec file
