
# NOTE: packages that can use jasper:
# ImageMagick
# netpbm

Summary: Implementation of the JPEG-2000 standard, Part 1
Name:    jasper
Group:   System Environment/Libraries
Version: 1.900.1
%define base_release .2
Release: 24%{?dist}%{?base_release}
# Base: exclude cross arches for this package
ExcludeArch: mips64 ppca2 ppc476 ppcnf

License: JasPer
URL:     http://www.ece.uvic.ca/~frodo/jasper/
Source0: http://www.ece.uvic.ca/~frodo/jasper/software/jasper-%{version}.zip

Patch1: jasper-1.701.0-GL.patch
# autoconf/automake bits of patch1
Patch2: jasper-1.701.0-GL-ac.patch
# CVE-2007-2721 (bug #240397)
# borrowed from http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=413041;msg=88
Patch3: patch-libjasper-stepsizes-overflow.diff
# borrowed from http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=469786 
Patch4: jpc_dec.c.patch
# OpenBSD hardening patches addressing couple of possible integer overflows
# during the memory allocations
# https://bugzilla.redhat.com/show_bug.cgi?id=CVE-2008-3520
Patch5: jasper-1.900.1-CVE-2008-3520.patch
# https://bugzilla.redhat.com/show_bug.cgi?id=CVE-2008-3522
Patch6: jasper-1.900.1-CVE-2008-3522.patch
# add pkg-config support
Patch7: jasper-pkgconfig.patch

Patch8: jasper-1.900.1-CVE-2011-4516-CVE-2011-4517-CERT-VU-887409.patch

# Issues found by static analysis of code
Patch10: jasper-1.900.1-Coverity-BAD_SIZEOF.patch
Patch11: jasper-1.900.1-Coverity-CHECKED_RETURN.patch
Patch12: jasper-1.900.1-Coverity-FORWARD_NULL.patch
Patch13: jasper-1.900.1-Coverity-NULL_RETURNS.patch
Patch14: jasper-1.900.1-Coverity-RESOURCE_LEAK.patch
Patch15: jasper-1.900.1-Coverity-UNREACHABLE.patch
Patch16: jasper-1.900.1-Coverity-UNUSED_VALUE.patch

# autoreconf
BuildRequires: autoconf automake libtool
BuildRequires: freeglut-devel 
BuildRequires: libGLU-devel
BuildRequires: libjpeg-devel
BuildRequires: pkgconfig

Requires: %{name}-libs%{?_isa} = %{version}-%{release}

%description
This package contains an implementation of the image compression
standard JPEG-2000, Part 1. It consists of tools for conversion to and
from the JP2 and JPC formats.

%package devel
Summary: Header files, libraries and developer documentation
Group:   Development/Libraries
Provides: libjasper-devel = %{version}-%{release}
Requires: %{name}-libs%{?_isa} = %{version}-%{release}
Requires: libjpeg-devel
Requires: pkgconfig
%description devel
%{summary}.

%package libs 
Summary: Runtime libraries for %{name}
Group:   System Environment/Libraries
Conflicts: jasper < 1.900.1-4
%description libs 
%{summary}.

%package utils 
Summary: Nonessential utilities for %{name}
Group:   Development/Libraries
Requires: %{name} = %{version}-%{release}
Requires: %{name}-libs%{?_isa} = %{version}-%{release}
%description utils 
%{summary}, including jiv and tmrdemo.



%prep
%setup -q -n %{name}-%{version}

%patch1 -p1 -b .GL
%patch2 -p1 -b .GL-ac
%patch3 -p1 -b .CVE-2007-2721
%patch4 -p1 -b .jpc_dec_assertion
%patch5 -p1 -b .CVE-2008-3520
%patch6 -p1 -b .CVE-2008-3522
%patch7 -p1 -b .pkgconfig
%patch8 -p1 -b .CVE-2011-4516-4517

%patch10 -p1 -b .BAD_SIZEOF
%patch11 -p1 -b .CHECKED_RETURN
%patch12 -p1 -b .FORWARD_NULL
%patch13 -p1 -b .NULL_RETURNS
%patch14 -p1 -b .RESOURCE_LEAK
%patch15 -p1 -b .UNREACHABLE
%patch16 -p1 -b .UNUSED_VALUE

autoreconf --verbose --force --install


%build

# jas_icc.c:744:2: warning: assuming signed overflow does not occur
# when assuming that (X + c) < X is always false [-Wstrict-overflow]
#
# comment from Red Hat Security Response Team:
# gcc inlines jas_iccattrtab_resize into jas_iccattrtab_add. Additionally, it
# essentially removes the "assert(maxents >= tab->numattrs);" assertion in
# jas_iccattrtab_resize, because it assumes that "maxents >= tab->numattrs" will
# always be true due to jas_iccattrtab_resize(attrtab, attrtab->numattrs + 32),
# especially the + 32. This assumption can only be true if it completely ignores
# the problem of signed integer overflows. I don't think it's a smart idea to
# accept that.
# -fno-strict-overflow forces gcc into keeping the assertion there.
CFLAGS="%{optflags} -fno-strict-overflow" \
%configure \
  --enable-shared \
  --disable-static 

make %{?_smp_mflags}


%install

make install DESTDIR=$RPM_BUILD_ROOT

# Unpackaged files
rm -f doc/README
rm -f $RPM_BUILD_ROOT%{_libdir}/lib*.la


%check
make check



%post libs -p /sbin/ldconfig

%postun libs -p /sbin/ldconfig


%files
%{_bindir}/imgcmp
%{_bindir}/imginfo
%{_bindir}/jasper
%{_mandir}/man1/img*
%{_mandir}/man1/jasper.1*

%files devel
%doc doc/*
%{_includedir}/jasper/
%{_libdir}/libjasper.so
%{_libdir}/pkgconfig/jasper.pc

%files libs
%doc COPYRIGHT LICENSE NEWS README
%{_libdir}/libjasper.so.1*

%files utils
%{_bindir}/jiv
%{_bindir}/tmrdemo
%{_mandir}/man1/jiv.1*


%changelog
* Fri May 17 2013 baseuser@ibm.com
- Base-8.x spec file
