%global library_version 1.0.6

Summary: A file compression utility
Name: bzip2
Version: 1.0.6
%define base_release .2
Release: 8%{?dist}%{?base_release}
License: BSD
Group: Applications/File
URL: http://www.bzip.org/
Source: http://www.bzip.org/%{version}/%{name}-%{version}.tar.gz
Source999: fivextra.tar.bz2

Patch0: bzip2-1.0.4-saneso.patch
Patch1: bzip2-1.0.4-cflags.patch
# resolves: #226979
Patch2: bzip2-1.0.4-bzip2recover.patch

%description
Bzip2 is a freely available, patent-free, high quality data compressor.
Bzip2 compresses files to within 10 to 15 percent of the capabilities
of the best techniques available.  However, bzip2 has the added benefit
of being approximately two times faster at compression and six times
faster at decompression than those techniques.  Bzip2 is not the
fastest compression utility, but it does strike a balance between speed
and compression capability.

Install bzip2 if you need a compression utility.

%package devel
Summary: Libraries and header files for apps which will use bzip2
Group: Development/Libraries
Requires: bzip2-libs = %{version}-%{release}

%description devel

Header files and a library of bzip2 functions, for developing apps
which will use the library.

%package libs
Summary: Libraries for applications using bzip2
Group: System Environment/Libraries

%description libs

Libraries for applications using the bzip2 compression format.

%package fivextra
Summary: Test for %{name} package
Group:  fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains testcases for %{name}.

%prep
%setup -q -n %{name}-%{version} -a 999
%patch0 -p1 -b .saneso
%patch1 -p1 -b .cflags
%patch2 -p1 -b .bz2recover

%build
make -f Makefile-libbz2_so CC="%{__cc}" AR="%{__ar}" RANLIB="%{__ranlib}" \
    CFLAGS="$RPM_OPT_FLAGS -D_FILE_OFFSET_BITS=64 -fpic -fPIC" \
    %{?_smp_mflags} all

rm -f *.o
make CC="%{__cc}" AR="%{__ar}" RANLIB="%{__ranlib}" \
    CFLAGS="$RPM_OPT_FLAGS -D_FILE_OFFSET_BITS=64" \
       %{?_smp_mflags} \
       %if 0%{?cross_build}
       libbz2.a bzip2 bzip2recover
       %else
       all
       %endif

pushd fivextra
make all
popd

%install
chmod 644 bzlib.h
mkdir -p $RPM_BUILD_ROOT{%{_bindir},%{_mandir}/man1,%{_libdir},%{_includedir}}
cp -p bzlib.h $RPM_BUILD_ROOT%{_includedir}
install -m 755 libbz2.so.%{library_version} $RPM_BUILD_ROOT%{_libdir}
install -m 755 bzip2-shared  $RPM_BUILD_ROOT%{_bindir}/bzip2
install -m 755 bzip2recover bzgrep bzdiff bzmore  $RPM_BUILD_ROOT%{_bindir}/
cp -p bzip2.1 bzdiff.1 bzgrep.1 bzmore.1  $RPM_BUILD_ROOT%{_mandir}/man1/
ln -s bzip2 $RPM_BUILD_ROOT%{_bindir}/bunzip2
ln -s bzip2 $RPM_BUILD_ROOT%{_bindir}/bzcat
ln -s bzdiff $RPM_BUILD_ROOT%{_bindir}/bzcmp
ln -s bzmore $RPM_BUILD_ROOT%{_bindir}/bzless
ln -s libbz2.so.%{library_version} $RPM_BUILD_ROOT%{_libdir}/libbz2.so.1
ln -s libbz2.so.1 $RPM_BUILD_ROOT%{_libdir}/libbz2.so
ln -s bzip2.1 $RPM_BUILD_ROOT%{_mandir}/man1/bzip2recover.1
ln -s bzip2.1 $RPM_BUILD_ROOT%{_mandir}/man1/bunzip2.1
ln -s bzip2.1 $RPM_BUILD_ROOT%{_mandir}/man1/bzcat.1
ln -s bzdiff.1 $RPM_BUILD_ROOT%{_mandir}/man1/bzcmp.1
ln -s bzmore.1 $RPM_BUILD_ROOT%{_mandir}/man1/bzless.1

# Steps to package the acpid tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%post libs -p /sbin/ldconfig

%postun libs  -p /sbin/ldconfig

%files
%doc LICENSE CHANGES README
%{_bindir}/*
%{_mandir}/*/*

%files libs
%doc LICENSE
%{_libdir}/libbz2.so.1*

%files devel
%doc manual.html manual.pdf
%{_includedir}/*
%{_libdir}/*.so

%files fivextra
%{prefix}

%changelog
* Mon May 13 2013 baseuser@ibm.com
- Base-8.x spec file
