%{!?python_sitelib: %global python_sitelib %(%{__python} -c "from distutils.sysconfig import get_python_lib; print(get_python_lib())")}

# LTC: disable docs
%if ! 0%{?base:1}
%global with_docs 1
%endif

Name:           python-kitchen
Version:        1.1.1
%define base_release .3
Release:        4%{?dist}%{?base_release}
Summary:        Small, useful pieces of code to make python coding easier

Group:          Development/Languages
License:        LGPLv2+
URL:            https://pypi.python.org/pypi/kitchen/
Source0:        https://fedorahosted.org/releases/k/i/kitchen/kitchen-%{version}.tar.gz
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

BuildArch:      noarch
BuildRequires:  python2-devel
BuildRequires:  python-nose
# For the subprocess test
BuildRequires:  python-test
# LTC: dont need this; we wont build the html docs
%if 0%{?with_docs}
# sphinx needs to be more recent to build the html docs
BuildRequires: python-sphinx
%endif
%if 0%{?fedora} || 0%{?rhel} >  6 || 0%{?base} > 18
# At present, chardet isn't present in epel but it's a soft dep
BuildRequires: python-chardet
Requires: python-chardet
%endif

%description
kitchen includes functions to make gettext easier to use, handling unicode
text easier (conversion with bytes, outputting xml, and calculating how many
columns a string takes), and compatibility modules for writing code that uses
python-2.7 modules but needs to run on python-2.3 

%package doc
Summary:        API documentation for the Kitchen python module
# Currently discussing guidelines about doc subpackages Requiring the main package:
# https://lists.fedoraproject.org/pipermail/packaging/2013-June/009191.html
#Requires: %{name} = %{version}-%{release}
%description doc
kitchen includes functions to make gettext easier to use, handling unicode
text easier (conversion with bytes, outputting xml, and calculating how many
columns a string takes), and compatibility modules for writing code that uses
python-2.7 modules but needs to run on python-2.3 

This package contains the API documenation for programming with the
kitchen library.

%prep
%setup -q -n kitchen-%{version}


%build
%{__python} setup.py build
# Build docs
# LTC: dont need this; we wont build the html docs
%if 0%{?with_docs}
%{__python} setup.py build_sphinx
cp -pr build/sphinx/html .
rm -rf html/.buildinfo

%endif

%install
rm -rf $RPM_BUILD_ROOT
%{__python} setup.py install --skip-build --root $RPM_BUILD_ROOT

%check
# In current mock, the PATH isn't being reset.  This causes failures in some
# subprocess tests as a check tests /root/bin/PROGRAM and fails with Permission
# Denied instead of File Not Found.  reseting the PATH works around this.
PATH=/bin:/usr/bin
nosetests
 
%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root,-)
%doc COPYING README NEWS COPYING.LESSER
# LTC: dont need this; we wont build the html docs
%if 0%{?with_docs}
%doc html
%endif
%{python_sitelib}/*

%files doc
%doc COPYING COPYING.LESSER docs/*

%changelog
* Wed Jul 31 2013 baseuser@ibm.com
- Base-8.x spec file
