%define gitdate 20070827
%define gitrev 8ff7213f39edc1b2b8b60d6b0cc5d5f14ca1928d

Name:           pixman
Version:        0.30.0
%define base_release .1
Release:        5%{?dist}%{?base_release}
# Base: exclude cross arches for this package
ExcludeArch:    mips64 ppca2 ppc476 ppcnf
Summary:        Pixel manipulation library

Group:          System Environment/Libraries
License:        MIT
URL:            http://cgit.freedesktop.org/pixman/
#VCS:		git:git://git.freedesktop.org/git/pixman
# To make git snapshots:
# ./make-pixman-snapshot.sh %{?gitrev}
# if no revision specified, makes a new one from HEAD.
Source0:	http://xorg.freedesktop.org/archive/individual/lib/%{name}-%{version}.tar.bz2
Source1:	make-pixman-snapshot.sh
# Patch which fixes underflow when bottom is close to MIN_INT
# See http://cgit.freedesktop.org/pixman/commit/?id=5e14da97f16e421d084a9e735be21b1025150f0c
Patch0:		pixman_fix-trapezoid-underflow.patch
# Patch which adds a test for the underflow fixed by the previous patch
# See http://cgit.freedesktop.org/pixman/commit/?id=2f876cf86718d3dd9b3b04ae9552530edafe58a1
Patch1:		pixman_test-trapezoid-underflow.patch
# test: fix matrix-test on big endian systems
# See http://cgit.freedesktop.org/pixman/commit/test/matrix-test.c?id=d87601ffc3d1583528ce52448fbb3659d0b1d1b0
Patch2:		pixman-matrix-test-BE-Fix.patch
Source999:     fivextra.tar.bz2
# BASE: this patch is no longer needed
#Patch96252:    bug-96252-test_matrix.patch 

BuildRequires:  automake autoconf libtool pkgconfig

%description
Pixman is a pixel manipulation library for X and cairo.

%package devel
Summary: Pixel manipulation library development package
Group: Development/Libraries
Requires: %{name} = %{version}-%{release}
Requires: pkgconfig

%description devel
Development library for pixman.

%Package fivextra
Summary: FIV Tests for %{name}
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains the testcases built from the package for %{name}

%prep
%setup -q -a 999
%patch0 -p1
%patch1 -p1
%patch2 -p1
#%patch96252 -p1

%build
%configure \
%ifarch %{arm}
  --disable-arm-iwmmxt --disable-arm-iwmmxt2 \
%endif
  --disable-static

make %{?_smp_mflags} V=1

%check
make check

%install
make install DESTDIR=$RPM_BUILD_ROOT
rm -f $RPM_BUILD_ROOT%{_libdir}/*.la

# Steps to package the pixman for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

pushd test/.libs
install -d $RPM_BUILD_ROOT%{fivdir}/%{name}/test
for file in $(find . -type f )
do
  install  $file  $RPM_BUILD_ROOT/%{fivdir}/%{name}/test/ 
done
popd

find $RPM_BUILD_ROOT/%{fivdir}/%{name} -type f -name '*.o' | xargs rm -f

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%post -p /sbin/ldconfig
%postun -p /sbin/ldconfig


%files
%defattr(-,root,root,-)
%{_libdir}/libpixman-1*.so.*

%files devel
%defattr(-,root,root,-)
%dir %{_includedir}/pixman-1
%{_includedir}/pixman-1/pixman.h
%{_includedir}/pixman-1/pixman-version.h
%{_libdir}/libpixman-1*.so
%{_libdir}/pkgconfig/pixman-1.pc

%files fivextra
%{prefix}

%changelog
* Thu Sep 04 2014 baseuser@ibm.com
- Base-8.x spec file
