Summary: The GNU data compression program
Name: gzip
Version: 1.5
%define base_release .3
Release: 4%{?dist}%{?base_release}
# info pages are under GFDL license
License: GPLv3+ and GFDL
Group: Applications/File
Source: http://ftp.gnu.org/gnu/gzip/gzip-%{version}.tar.xz
Patch0: gzip-1.3.12-openbsd-owl-tmp.patch
Patch1: gzip-1.3.5-zforce.patch
Patch4: gzip-1.3.13-rsync.patch
Patch5: gzip-1.3.9-addsuffix.patch
Patch6: gzip-1.3.5-cve-2006-4338.patch
Patch7: gzip-1.3.13-cve-2006-4337.patch
Patch8: gzip-1.3.5-cve-2006-4337_len.patch
# Fixed in upstream code.
# http://thread.gmane.org/gmane.comp.gnu.gzip.bugs/378
URL: http://www.gzip.org/
# Requires should not be added for gzip wrappers (eg. zdiff, zgrep,
# zless) of another tools, because gzip "extends" the tools by its
# wrappers much more than it "requires" them.
Requires: /sbin/install-info
Requires: coreutils
BuildRequires: texinfo
Conflicts: filesystem < 3
Provides: /bin/gunzip
Provides: /bin/gzip
Provides: /bin/zcat
# Gzip contains bundled Gnulib
# exception https://fedorahosted.org/fpc/ticket/174 
Provides: bundled(gnulib)

%description
The gzip package contains the popular GNU gzip data compression
program. Gzipped files have a .gz extension.

Gzip should be installed on your system, because it is a
very commonly used data compression program.

%prep
%setup -q
%patch0 -p1 -b .owl-tmp
%patch1 -p1 -b .zforce
%patch4 -p1 -b .rsync
%patch5 -p1 -b .addsuffix
%patch6 -p1 -b .4338
%patch7 -p1 -b .4337
%patch8 -p1 -b .4337l

%build
export DEFS="NO_ASM"
export CPPFLAGS="-DHAVE_LSTAT"
%configure 

make
#make gzip.info

%install
rm -rf ${RPM_BUILD_ROOT}
%makeinstall 

gzip -9nf ${RPM_BUILD_ROOT}%{_infodir}/gzip.info*

# we don't ship it, so let's remove it from ${RPM_BUILD_ROOT}
rm -f ${RPM_BUILD_ROOT}%{_infodir}/dir
# uncompress is a part of ncompress package
rm -f ${RPM_BUILD_ROOT}/%{_bindir}/uncompress

%post
if [ -f %{_infodir}/gzip.info* ]; then
    /sbin/install-info %{_infodir}/gzip.info.gz %{_infodir}/dir || :
fi

%preun
if [ $1 = 0 ]; then
    if [ -f %{_infodir}/gzip.info* ]; then
        /sbin/install-info --delete %{_infodir}/gzip.info.gz %{_infodir}/dir || :
    fi
fi

%files
%defattr(-,root,root)
%doc NEWS README AUTHORS ChangeLog THANKS TODO
%{_bindir}/*
%{_mandir}/*/*
%{_infodir}/gzip.info*

%changelog
* Fri May 03 2013 baseuser@ibm.com
- Base-8.x spec file
