# https://fedoraproject.org/wiki/Packaging:Guidelines#Compiler_flags
%define _hardened_build 1

Name:               lldpad
Version:            0.9.46
%define base_release .2
Release:            2%{?dist}%{?base_release}
# Base: exclude cross arches for this package
ExcludeArch: mips64 ppca2 ppc476 ppcnf
Summary:            Intel LLDP Agent
Group:              System Environment/Daemons
License:            GPLv2
URL:                http://open-lldp.org/
Source0:            %{name}-%{version}.tar.gz
Source999:	    fivextra.tar.bz2
Requires:           kernel >= 2.6.32
BuildRequires:      automake autoconf libtool
BuildRequires:      flex >= 2.5.33
BuildRequires:      kernel-headers >= 2.6.32
BuildRequires:      libconfig-devel >= 1.3.2
BuildRequires:      libnl-devel
BuildRequires:      readline-devel
BuildRequires:      systemd-units
Requires:           readline
Requires(post):     systemd-units
Requires(preun):    systemd-units
Requires(postun):   systemd-units
Provides:           dcbd = %{version}-%{release}
Obsoletes:          dcbd < 0.9.26

%description
This package contains the Linux user space daemon and configuration tool for
Intel LLDP Agent with Enhanced Ethernet support for the Data Center.

%package            devel
Summary:            Development files for %{name}
Group:              Development/Libraries
Requires:           %{name}%{?_isa} = %{version}-%{release}
Provides:           dcbd-devel = %{version}-%{release}
Obsoletes:          dcbd-devel < 0.9.26

%description devel
The %{name}-devel package contains header files for developing applications
that use %{name}.

%package fivextra
Summary: FIV Tests for %{name}
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains the testcases built from the package for %{name}

%prep
%setup -q -a 999

%build
./bootstrap.sh
%configure --disable-static
# fix the hardened build flags
sed -i -e 's! \\\$compiler_flags !&\\\$CFLAGS \\\$LDFLAGS !' libtool
make %{?_smp_mflags}

%install
make install DESTDIR=%{buildroot}
rm -f %{buildroot}%{_mandir}/man8/dcbd.8
mkdir -p %{buildroot}%{_unitdir}
install -m644 %{name}.service %{buildroot}%{_unitdir}
rm -rf %{buildroot}/etc/init.d
mkdir -p %{buildroot}%{_sharedstatedir}/%{name}
rm -f %{buildroot}%{_libdir}/liblldp_clif.la

# Steps to package the lldpad tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
	install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
	install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done
install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%post
/sbin/ldconfig
%systemd_post %{name}.service
	
%preun
%systemd_preun %{name}.service

%postun
/sbin/ldconfig
%systemd_postun_with_restart %{name}.service

%post devel
## provide legacy support for apps that use the old dcbd interface.
if [ ! -e %{_includedir}/dcbd ]; then
    ln -T -s %{_includedir}/lldpad %{_includedir}/dcbd
fi
if [ ! -e %{_includedir}/dcbd/clif_cmds.h ]; then
    ln -T -s %{_includedir}/lldpad/lldp_dcbx_cmds.h %{_includedir}/dcbd/clif_cmds.h
fi

%preun devel
if [ -e %{_includedir}/dcbd/clif_cmds.h ]; then
    rm -f %{_includedir}/dcbd/clif_cmds.h
fi
if [ -e %{_includedir}/dcbd ]; then
    rm -f %{_includedir}/dcbd
fi

%files
%doc COPYING README ChangeLog
%{_sbindir}/*
%{_libdir}/liblldp_clif.so.*
%dir %{_sharedstatedir}/%{name}
%{_unitdir}/%{name}.service
%dir %{_sysconfdir}/bash_completion.d/
%{_sysconfdir}/bash_completion.d/*
%{_mandir}/man8/*

%files devel
%{_includedir}/*
%{_libdir}/pkgconfig/*.pc
%{_libdir}/liblldp_clif.so

%files fivextra
%{prefix}

%changelog
* Mon Jan 27 2014 baseuser@ibm.com
- Base-f19.x spec file
