Summary: Internationalized Domain Name support library
Name: libidn
Version: 1.26
%define base_release .2
Release: 2%{?dist}%{?base_release}
URL: http://www.gnu.org/software/libidn/
License: LGPLv2+ and GPLv3+ and GFDL
Source0: http://ftp.gnu.org/gnu/libidn/libidn-%{version}.tar.gz
Source999: fivextra.tar.bz2
Patch68991: bug-68991-cross-build-tests.patch
Group: System Environment/Libraries
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildRequires: pkgconfig, gettext
Requires(post): /sbin/install-info /sbin/ldconfig
Requires(preun): /sbin/install-info
Requires(postun): /sbin/ldconfig
# gnulib is a copylib, bundling is allowed
Provides: bundled(gnulib)

%description
GNU Libidn is an implementation of the Stringprep, Punycode and
IDNA specifications defined by the IETF Internationalized Domain
Names (IDN) working group, used for internationalized domain
names.

%package devel
Summary: Development files for the libidn library
Group: Development/Libraries
Requires: %{name} = %{version}-%{release}
Requires: pkgconfig

%description devel
This package includes header files and libraries necessary for
developing programs which use the GNU libidn library.

%package -n emacs-%{name}
Summary: GNU Emacs libidn support files
License: GPLv3+
BuildRequires: emacs
Requires: %{name} = %{version}-%{release}
Requires: emacs(bin) >= %{_emacs_version}
BuildArch: noarch

%description -n emacs-%{name}
This package includes libidn support files for GNU Emacs.

%package fivextra
Summary: FIV Tests for %{name}
Group: fivextra
Prefix: /opt/fiv/ltp
#Requires: %{name} >= %{version}-%{release}

%description fivextra
This package contains the testcases built from the package for %{name}.

%prep
%setup -q -n %{name}-%{version} -a 999
%patch68991 -p1

# Name directory sections consistently in the info file, #209491
sed -i '/^INFO-DIR-SECTION/{s/GNU Libraries/Libraries/;s/GNU utilities/Utilities/;}' doc/libidn.info

iconv -f ISO-8859-1 -t UTF-8 doc/libidn.info > iconv.tmp
mv iconv.tmp doc/libidn.info

%build
%configure --disable-csharp --disable-static --libdir=/%{_lib} --with-lispdir=%{_emacs_sitelispdir}/%{name}
make %{?_smp_mflags} V=1

#%check
#make %{?_smp_mflags} -C tests check VALGRIND=env

pushd fivextra
make all
popd

%install
rm -rf %{buildroot}
make install DESTDIR=$RPM_BUILD_ROOT pkgconfigdir=%{_libdir}/pkgconfig

# provide more examples
make %{?_smp_mflags} -C examples distclean

# clean up docs
find doc -name "Makefile*" | xargs rm
rm -rf $RPM_BUILD_ROOT%{_datadir}/info/dir

# Make multilib safe:
sed -i '/gnu compiler/d' $RPM_BUILD_ROOT%{_includedir}/idn-int.h

rm -f $RPM_BUILD_ROOT/%{_lib}/*.la \
      $RPM_BUILD_ROOT%{_datadir}/info/*.png

mkdir -p $RPM_BUILD_ROOT%{_libdir}
mv $RPM_BUILD_ROOT/%{_lib}/libidn.so $RPM_BUILD_ROOT%{_libdir}

lib=`echo $RPM_BUILD_ROOT/%{_lib}/libidn.so.*.*`
ln -sf ../../%{_lib}/`basename ${lib}` $RPM_BUILD_ROOT%{_libdir}/libidn.so

# Fix the .pc file to reference the directory which contains the .so
sed -i 's,^libdir=.*$,libdir=%{_libdir},' \
    $RPM_BUILD_ROOT%{_libdir}/pkgconfig/libidn.pc

%{_emacs_bytecompile} $RPM_BUILD_ROOT%{_emacs_sitelispdir}/%{name}/*.el

%find_lang %{name}

#FIV Changes
# This is strange. The check section gets executed post install section
# So we have to copy the tests after the tests are built. Since cross
# doesn't execute a check section, move these test to the right location
# during install.
mkdir -p $RPM_BUILD_ROOT/%{fivdir}/%{name}
# Cleanup unnecessary files
cp -a tests $RPM_BUILD_ROOT/%{fivdir}/%{name}/%{name}-tests
( cd $RPM_BUILD_ROOT/%{fivdir}/%{name}/%{name}-tests; \
       rm -rf .libs .deps *.o *.am *.in *.a )

# Steps to package the libidn tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

find $RPM_BUILD_ROOT/%{fivdir}/%{name} -mindepth 2 \
  -name '*.c' -o -name '*.h' | xargs rm -rf

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%post
/sbin/install-info %{_infodir}/%{name}.info.gz %{_infodir}/dir
/sbin/ldconfig

%preun
if [ $1 = 0 ]; then
    /sbin/install-info --delete %{_infodir}/%{name}.info.gz %{_infodir}/dir || :
fi

%postun -p /sbin/ldconfig

%clean
rm -rf %{buildroot}

%files -f %{name}.lang
%defattr(-,root,root)
%doc AUTHORS NEWS FAQ README THANKS COPYING*
%{_bindir}/idn
%{_mandir}/man1/idn.1*
/%{_lib}/libidn.so.*
%{_infodir}/%{name}.info.gz

%files devel
%defattr(0644,root,root,755)
%doc doc/libidn.html examples
%{_libdir}/libidn.so
%{_includedir}/*.h
%{_libdir}/pkgconfig/*.pc
%{_mandir}/man3/*

%files -n emacs-%{name}
%defattr(-,root,root)
%{_emacs_sitelispdir}/%{name}

%files fivextra
%defattr(-,root,root)
%{prefix}

%changelog
* Mon May 13 2013 baseuser@ibm.com
- Base-8.x spec file
