Name:           conserver
Version:        8.1.18
%define base_release .1
Release:        9%{?dist}%{?base_release}
Summary:        Serial console server daemon/client

Group:          System Environment/Daemons
License:        BSD with advertising and zlib
URL:            http://www.conserver.com/
Source0:        http://www.conserver.com/%{name}-%{version}.tar.gz
Source1:	%{name}.service
Patch0:         %{name}-no-exampledir.patch
#Patch1:         %{name}-initscript.patch
Patch2:         %{name}-gssapi.patch
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

BuildRequires:  pam-devel, openssl-devel, tcp_wrappers-devel, krb5-devel
BuildRequires:  autoconf, automake, systemd-units
Requires(post): systemd-units
Requires(preun): systemd-units
Requires(postun): systemd-units

%description
Conserver is an application that allows multiple users to watch a serial 
console at the same time.  It can log the data, allows users to take 
write-access of a console (one at a time), and has a variety of bells 
and whistles to accentuate that basic functionality.

%package client
Summary: Serial console client
Group: Applications/Communications

%description client
This is the client package needed to interact with a Conserver daemon.

%prep
%setup -q
%patch0 -p1
#%patch1 -p1
%patch2 -p1

%build
# we don't want to install the solaris conserver.rc file
f="conserver/Makefile.in"
%{__mv} $f $f.orig
%{__sed} -e 's/^.*conserver\.rc.*$//' < $f.orig > $f

autoreconf -f -i

%configure --with-libwrap \
        --with-openssl \
        --with-pam \
        --with-gssapi \
        --with-striprealm \
        --with-port=782

make %{?_smp_mflags}


%install
rm -rf $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT

# put commented copies of the sample configure files in the
# system configuration directory
%{__mkdir_p} $RPM_BUILD_ROOT/%{_sysconfdir}
%{__sed} -e 's/^/#/' \
  < conserver.cf/conserver.cf \
  > $RPM_BUILD_ROOT/%{_sysconfdir}/conserver.cf
%{__sed} -e 's/^/#/' \
  < conserver.cf/conserver.passwd \
  > $RPM_BUILD_ROOT/%{_sysconfdir}/conserver.passwd

# install copy of init script
#%{__mkdir_p} $RPM_BUILD_ROOT/%{_initrddir}
#%{__cp} contrib/redhat-rpm/conserver.init $RPM_BUILD_ROOT/%{_initrddir}/conserver
install -D -m 644 %{SOURCE1} $RPM_BUILD_ROOT%{_unitdir}/conserver.service


%clean
rm -rf $RPM_BUILD_ROOT

%post
if [ $1 -eq 1 ] ; then 
    # Initial installation 
    /bin/systemctl daemon-reload >/dev/null 2>&1 || :
fi

%preun
if [ $1 -eq 0 ] ; then
    # Package removal, not upgrade
    /bin/systemctl --no-reload disable conserver.service > /dev/null 2>&1 || :
    /bin/systemctl stop conserver.service > /dev/null 2>&1 || :
fi

%postun
/bin/systemctl daemon-reload >/dev/null 2>&1 || :
if [ $1 -ge 1 ] ; then
    # Package upgrade, not uninstall
    /bin/systemctl try-restart conserver.service >/dev/null 2>&1 || :
fi

%triggerun -- conserver < 8.1.18-5
# Save the current service runlevel info
# User must manually run systemd-sysv-convert --apply conserver
# to migrate them to systemd targets
/usr/bin/systemd-sysv-convert --save conserver >/dev/null 2>&1 ||:

# Run these because the SysV package being removed won't do them
/sbin/chkconfig --del conserver >/dev/null 2>&1 || :
/bin/systemctl try-restart conserver.service >/dev/null 2>&1 || :

%files
%defattr(-,root,root,-)
%doc CHANGES FAQ LICENSE INSTALL README conserver.cf/samples/ conserver.cf/conserver.cf conserver.cf/conserver.passwd
%config(noreplace) %{_sysconfdir}/conserver.*
%{_unitdir}/conserver.service
%{_libdir}/conserver
%{_mandir}/man5/conserver.cf.5.gz
%{_mandir}/man5/conserver.passwd.5.gz
%{_mandir}/man8/conserver.8.gz
%{_sbindir}/conserver

%files client
%defattr(-,root,root,-)
%doc LICENSE
%{_bindir}/console
%{_mandir}/man1/console.1.gz

%changelog
* Tue Feb 04 2014 baseuser@ibm.com
- Base-f19.x spec file
