Summary: Collection of performance monitoring tools for Linux
Name: sysstat
Version: 10.1.5
%define base_release .3
Release: 1%{?dist}%{?base_release}
# Base: exclude cross arches for this package
ExcludeArch: mips64 ppca2 ppc476 ppcnf
License: GPLv2+
Group: Applications/System
URL: http://sebastien.godard.pagesperso-orange.fr/
Source: http://pagesperso-orange.fr/sebastien.godard/%{name}-%{version}.tar.bz2
Source999: fivextra.tar.bz2

Patch0: sysstat-10.0.0-makefile.patch

Requires: /etc/cron.d, fileutils, grep, sh-utils, textutils
Requires(post): systemd, systemd-sysv
Requires(preun): systemd
Requires(postun): systemd

BuildRequires: %{_includedir}/linux/if.h, gettext, lm_sensors-devel, perl

%description
The sysstat package contains sar, sadf, mpstat, iostat, pidstat, nfsiostat,
cifsiostat and sa tools for Linux.
The sar command collects and reports system activity information. This
information can be saved in a file in a binary format for future inspection. The
statistics reported by sar concern I/O transfer rates, paging activity,
process-related activities, interrupts, network activity, memory and swap space
utilization, CPU utilization, kernel activities and TTY statistics, among
others. Both UP and SMP machines are fully supported.
The sadf command may be used to display data collected by sar in various formats
(CSV, XML, etc.).
The iostat command reports CPU utilization and I/O statistics for disks.
The mpstat command reports global and per-processor statistics.
The pidstat command reports statistics for Linux tasks (processes).
The nfsiostat command reports I/O statistics for network file systems.
The cifsiostat command reports I/O statistics for CIFS file systems.

%package fivextra
Summary: FIV Tests for %{name}
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains the testcases built from the package for %{name}

%prep
%setup -q -n %{name}-%{version} -a 999
%patch0 -p1 -b .ls
iconv -f windows-1252 -t utf8 CREDITS > CREDITS.aux
mv CREDITS.aux CREDITS

%build
%configure sa_lib_dir=%{_libdir}/sa history=28 compressafter=31 \
    --disable-man-group
%{__sed} -i 's/SADC_OPTIONS=""/SADC_OPTIONS="-S DISK"/' sysstat.sysconfig
CFLAGS="$RPM_OPT_FLAGS -DSADC_PATH=\\\"%{_libdir}/sa/sadc\\\""
make CFLAGS="$CFLAGS" LFLAGS="" %{?_smp_mflags}

pushd fivextra
make all
popd

%install
make install DESTDIR=%{buildroot}

# Install cron file
mkdir -p %{buildroot}/%{_sysconfdir}/cron.d
install -m 0644 cron/sysstat.crond %{buildroot}/%{_sysconfdir}/cron.d/sysstat

# Install service file
mkdir -p %{buildroot}%{_unitdir}
install -m 0644 sysstat.service %{buildroot}%{_unitdir}/

%find_lang %{name}

# Steps to package the sysstat tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%post
%systemd_post sysstat.service

%preun
%systemd_preun sysstat.service
if [[ $1 -eq 0 ]]; then
  # Remove sa logs if removing sysstat completely
  rm -f %{_localstatedir}/log/sa/*
fi

%postun
%systemd_postun sysstat.service

%triggerun -- sysstat < 10.0.2-1
# Save the current service runlevel info
# User must manually run systemd-sysv-convert --apply sysstat
# to migrate them to systemd targets
/usr/bin/systemd-sysv-convert --save sysstat >/dev/null 2>&1 ||:

# Run these because the SysV package being removed won't do them
/sbin/chkconfig --del sysstat >/dev/null 2>&1 || :
/bin/systemctl try-restart sysstat.service >/dev/null 2>&1 || :

%files -f %{name}.lang
%doc CHANGES COPYING CREDITS README FAQ
%config(noreplace) %{_sysconfdir}/cron.d/sysstat
%config(noreplace) %{_sysconfdir}/sysconfig/sysstat
%config(noreplace) %{_sysconfdir}/sysconfig/sysstat.ioconf
%{_unitdir}/sysstat.service
%{_bindir}/*
%{_libdir}/sa
%{_mandir}/man1/*
%{_mandir}/man5/*
%{_mandir}/man8/*
%{_localstatedir}/log/sa

%files fivextra
%{prefix}

%changelog
* Wed Oct 16 2013 baseuser@ibm.com
- Base-8.x spec file
