Summary: Bidirectional data relay between two data channels ('netcat++')
Name: socat
Version: 1.7.2.3
%define base_release .1
Release: 1%{?dist}%{?base_release}
# Base: exclude cross arches for this package
ExcludeArch: mips64 ppca2 ppc476 ppcnf
License: GPLv2
Url:  http://www.dest-unreach.org/%{name}
Source: http://www.dest-unreach.org/socat/download/%{name}-%{version}.tar.gz
Source999: fivextra.tar.bz2

# Base bug
Patch97375:bug97375-socat_fails_with_-L_option.patch

Group: Applications/Internet
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildRequires: openssl-devel compat-readline5-devel ncurses-devel
BuildRequires: autoconf kernel-headers > 2.6.18

%description
Socat is a relay for bidirectional data transfer between two independent data
channels. Each of these data channels may be a file, pipe, device (serial line
etc. or a pseudo terminal), a socket (UNIX, IP4, IP6 - raw, UDP, TCP), an
SSL socket, proxy CONNECT connection, a file descriptor (stdin etc.), the GNU
line editor (readline), a program, or a combination of two of these. 
The compat-readline5 library is used to avoid GPLv2 vs GPLv3 issues.

%package fivextra 
Summary: Test for %{name} package
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains testcases for %{name}.

%prep
%setup -q -a 999
# base bug
%patch97375 -p1

iconv -f iso8859-1 -t utf-8 CHANGES > CHANGES.utf8
mv CHANGES.utf8 CHANGES

%build
autoconf
export CPPFLAGS="-I%{_includedir}/readline5" LDFLAGS="-L%{_libdir}/readline5"
%configure  \
        --enable-help --enable-stdio \
        --enable-fdnum --enable-file --enable-creat \
        --enable-gopen --enable-pipe --enable-termios \
        --enable-unix --enable-ip4 --enable-ip6 \
        --enable-rawip --enable-tcp --enable-udp \
        --enable-listen --enable-proxy --enable-exec \
        --enable-system --enable-pty --enable-readline \
        --enable-openssl --enable-sycls --enable-filan \
        --enable-retry --enable-libwrap

chmod 644 *.sh
make %{?_smp_mflags}

pushd fivextra
make all
popd

%install
rm -rf %{buildroot}

make DESTDIR=%{buildroot} install

#Steps to package the socat tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%clean
rm -rf %{buildroot}

%files 
%defattr(-,root,root)
%doc BUGREPORTS CHANGES DEVELOPMENT EXAMPLES FAQ PORTING
%doc COPYING* README SECURITY testcert.conf
%doc daemon.sh ftp.sh gatherinfo.sh mail.sh proxy.sh 
%doc proxyecho.sh readline.sh readline-test.sh
%doc socks4echo.sh socks4a-echo.sh test.sh
%{_bindir}/socat
%{_bindir}/filan
%{_bindir}/procan
%doc %{_mandir}/man1/socat.1*

%files fivextra
%{prefix}

%changelog
* Tue Jul 09 2013 baseuser@ibm.com
- Base-8.x spec file
