# https://fedoraproject.org/wiki/Packaging:Guidelines#Compiler_flags
%define _hardened_build 1

Name:               fcoe-utils
Version:            1.0.27
%define base_release .5
Release:            1%{?dist}%{?base_release}
# Base: exclude cross arches for this package
ExcludeArch: mips64 ppca2 ppc476 ppcnf
Summary:            Fibre Channel over Ethernet utilities
Group:              Applications/System
License:            GPLv2
URL:                http://www.open-fcoe.org
# git://open-fcoe.org/fcoe/fcoe-utils.git
Source0:            %{name}-%{version}.tar.bz2
Source1:            quickstart.txt
Source2:            fcoe.service
Source3:            fcoe.config
Source999:     fivextra.tar.bz2
# Base exclude ppc (lldpad Requires kernel) but not s390x
ExcludeArch:        ppc
# Generic Fedora patches
Patch1:             fcoe-utils-1.0.19-make.patch
Patch2:             fcoe-utils-1.0.18-help.patch
Patch3:             fcoe-utils-1.0.18-config.patch
Patch4:             fcoe-utils-1.0.23-archiver.patch
# Base patches
Patch92949:         bug-92949-pull_in_rhel_initrd.patch
Patch98109:	    bug-98109-fipvlan.patch
BuildRequires:      libtool automake autoconf
BuildRequires:      lldpad-devel >= 0.9.43
BuildRequires:      libhbaapi-devel >= 2.2-12
BuildRequires:      libhbalinux-devel >= 1.0.13
BuildRequires:      systemd-units
Requires:           lldpad >= 0.9.43
Requires:           libhbalinux >= 1.0.13
Requires:           iproute
Requires:           device-mapper-multipath
Requires(post):     systemd-units
Requires(preun):    systemd-units
Requires(postun):   systemd-units

%description
Fibre Channel over Ethernet utilities
fcoeadm - command line tool for configuring FCoE interfaces
fcoemon - service to configure DCB Ethernet QOS filters, works with lldpad

%package fivextra
Summary: FIV Tests for %{name}
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains the testcases built from the package for %{name}

%prep
%setup -q -a 999
cp -v %{SOURCE1} quickstart.txt
%patch1 -p1 -b .make
%patch2 -p1 -b .help
%patch3 -p1 -b .config
%patch4 -p1 -b .archiver
# Base patches
%patch92949 -p1
%patch98109 -p1

%build
./bootstrap.sh
%configure
make %{?_smp_mflags}

%install
make install DESTDIR=%{buildroot}
rm -rf %{buildroot}/etc/init.d
mkdir -p %{buildroot}%{_sysconfdir}/sysconfig %{buildroot}%{_unitdir}
install -m 644 %{SOURCE2} %{buildroot}%{_unitdir}
install -m 644 %{SOURCE3} %{buildroot}%{_sysconfdir}/sysconfig/fcoe
mkdir -p %{buildroot}%{_libexecdir}/fcoe
for file in \
    contrib/*.sh \
    debug/*sh
    do install -m 755 ${file} %{buildroot}%{_libexecdir}/fcoe/
done

# Steps to package the fce-utils tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done
install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%post
%systemd_post fcoe.service

%preun
%systemd_preun fcoe.service

%postun
%systemd_postun_with_restart fcoe.service

%files
%doc README COPYING QUICKSTART quickstart.txt
%{_sbindir}/*
%{_mandir}/man8/*
%{_unitdir}/fcoe.service
%{_sysconfdir}/fcoe/
%config(noreplace) %{_sysconfdir}/fcoe/cfg-ethx
#%config(noreplace) %{_sysconfdir}/fcoe/config
%config(noreplace) %{_sysconfdir}/sysconfig/fcoe
%{_sysconfdir}/bash_completion.d/
%{_libexecdir}/fcoe/

%files fivextra
%{prefix}

%changelog
* Wed Jul 03 2013 baseuser@ibm.com
- Base-8.x spec file
