%if ! 0%{?rhel} > 5
%{!?python_sitearch: %global python_sitearch %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib(1)")}
%endif

%if 0%{?fedora} > 12 && ! 0%{?base:1}
%global with_python3 1
%endif


%global srcname SQLAlchemy

Name:           python-sqlalchemy
Version:        0.8.4
%define base_release .2
Release:        1%{?dist}%{?base_release}
Summary:        Modular and flexible ORM library for python

Group:          Development/Libraries
License:        MIT
URL:            http://www.sqlalchemy.org/
Source0:        http://pypi.python.org/packages/source/S/%{srcname}/%{srcname}-%{version}.tar.gz
Patch0: sqlalchemy-nose-use-build.patch
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

BuildRequires:  python2-devel
BuildRequires:  python-setuptools
BuildRequires:  python-nose
BuildRequires:  python-mock

%if 0%{?with_python3}
BuildRequires:  python3-devel
BuildRequires:  python3-setuptools
BuildRequires:  python3-nose
%endif

%description
SQLAlchemy is an Object Relational Mappper (ORM) that provides a flexible,
high-level interface to SQL databases.  Database and domain concepts are
decoupled, allowing both sides maximum flexibility and power. SQLAlchemy
provides a powerful mapping layer that can work as automatically or as manually
as you choose, determining relationships based on foreign keys or letting you
define the join conditions explicitly, to bridge the gap between database and
domain.

This package includes the python 2 version of the module.

%if 0%{?with_python3}
%package -n python3-sqlalchemy
Summary:        Modular and flexible ORM library for python
Group:          Development/Libraries

%description -n python3-sqlalchemy
SQLAlchemy is an Object Relational Mappper (ORM) that provides a flexible,
high-level interface to SQL databases.  Database and domain concepts are
decoupled, allowing both sides maximum flexibility and power. SQLAlchemy
provides a powerful mapping layer that can work as automatically or as manually
as you choose, determining relationships based on foreign keys or letting you
define the join conditions explicitly, to bridge the gap between database and
domain.

This package includes the python 3 version of the module.
%endif # with_python3

# Filter unnecessary dependencies
%global __provides_exclude_from ^(%{python_sitearch}|%{python3_sitearch})/.*\\.so$

%prep
%setup -q -n %{srcname}-%{version}
%patch0 -p0

%if 0%{?with_python3}
rm -rf %{py3dir}
cp -a . %{py3dir}
%endif # with_python3

%build
CFLAGS="%{optflags}" %{__python} setup.py --with-cextensions build

%if 0%{?with_python3}
pushd %{py3dir}
# Convert tests and examples to python3
%{__python3} sa2to3.py --no-diffs -w test examples
# Currently the cextension doesn't work with python3
CFLAGS="%{optflags}" %{__python3} setup.py build
popd
%endif

%install
rm -rf %{buildroot}

mkdir -p %{buildroot}%{python_sitelib}
%{__python} setup.py --with-cextensions install --skip-build --root %{buildroot}

%if 0%{?with_python3}
pushd %{py3dir}
mkdir -p %{buildroot}%{python3_sitelib}
# Currently the cextension doesn't work with python3
%{__python3} setup.py install --skip-build --root %{buildroot}
popd
%endif

# remove unnecessary scripts for building documentation
rm -rf doc/build

%clean
rm -rf %{buildroot}

%check
%{__python} ./sqla_nose.py

%if 0%{?with_python3}
pushd %{py3dir}
%{__python3} ./sqla_nose.py
popd
%endif


%files
%defattr(-,root,root,-)
%doc README.rst LICENSE PKG-INFO CHANGES doc examples
%{python_sitearch}/*

%if 0%{?with_python3}
%files -n python3-sqlalchemy
%defattr(-,root,root,-)
%doc LICENSE PKG-INFO doc examples
%{python3_sitelib}/*
%endif # with_python3

%changelog
* Wed Jan 22 2014 baseuser@ibm.com
- Base-f19.x spec file
