# if 0%{?fedora}
# global with_python3 1
# else
%{!?python_sitelib: %global python_sitelib %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib()")}
# endif

Name:           python-decorator
Version:        3.4.0
%define base_release .2
Release:        2%{?dist}%{?base_release}
Summary:        Module to simplify usage of decorators

Group:          Development/Languages
License:        BSD
URL:            http://pypi.python.org/pypi/decorator/
Source0:        http://pypi.python.org/packages/source/d/decorator/decorator-%{version}.tar.gz
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

BuildArch:      noarch
BuildRequires:  python2-devel
BuildRequires:  python-setuptools
BuildRequires:  python-nose

%if 0%{?with_python3}
BuildRequires: python3-devel
BuildRequires: python3-setuptools
%endif

%description
The aim of the decorator module is to simplify the usage of decorators for
the average programmer, and to popularize decorators usage giving examples
of useful decorators, such as memoize, tracing, redirecting_stdout, locked,
etc.  The core of this module is a decorator factory called decorator.

%if 0%{?with_python3}
%package -n python3-decorator
Summary:        Module to simplify usage of decorators in python3
Group:          Development/Languages

%description -n python3-decorator
The aim of the decorator module is to simplify the usage of decorators for
the average programmer, and to popularize decorators usage giving examples
of useful decorators, such as memoize, tracing, redirecting_stdout, locked,
etc.  The core of this module is a decorator factory called decorator.
%endif # if with_python3

%prep
%setup -q -n decorator-%{version}

chmod a-x *.txt *.py
%{__sed} -i 's/\r//' README.txt

%if 0%{?with_python3}
rm -rf %{py3dir}
cp -a . %{py3dir}
find %{py3dir} -name '*.py' | xargs sed -i '1s|^#!python|#!%{__python3}|'
%endif # with_python3


%build
%{__python} setup.py build

%if 0%{?with_python3}
pushd %{py3dir}
%{__python3} setup.py build
popd
%endif # with_python3


%install
rm -rf $RPM_BUILD_ROOT
%{__python} setup.py install --skip-build --root $RPM_BUILD_ROOT

%if 0%{?with_python3}
pushd %{py3dir}
%{__python3} setup.py install --skip-build --root $RPM_BUILD_ROOT
popd
%endif # with_python3

%clean
rm -rf $RPM_BUILD_ROOT

%check
# Until we get the python-multiprocessing backport packaged
%if 0%{?fedora} || 0%{?rhel} > 5
nosetests --with-doctest -e documentation3
%endif

# nose is not Python3 ready yet
%if 0%{?with_python3}
pushd %{py3dir}
PYTHONPATH=$(pwd)/build/lib python3 documentation3.py
popd
%endif # with_python3

%files
%defattr(-,root,root,-)
%doc *.txt documentation.py
%{python_sitelib}/*

%if 0%{?with_python3}
%files -n python3-decorator
%defattr(-,root,root,-)
%doc *.txt documentation3.py
%{python3_sitelib}/*
%endif # with_python3


%changelog
* Fri Jul 12 2013 baseuser@ibm.com
- Base-8.x spec file
