# -*- coding: utf-8 -*-
%ifos linux
%define _bindir /bin
%endif

Summary: A GNU stream text editor
Name: sed
Version: 4.2.2
%define base_release .2
Release: 2%{?dist}%{?base_release}
License: GPLv3+
Group: Applications/Text
URL: http://sed.sourceforge.net/
Source0: ftp://ftp.gnu.org/pub/gnu/sed/sed-%{version}.tar.bz2
Source1: http://sed.sourceforge.net/sedfaq.txt
Source999: fivextra.tar.bz2
Patch0: sed-4.2.2-copy.patch
Patch70275: bug-70275-cross-disable-docs-testsuite.patch
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildRequires: glibc-devel, libselinux-devel
Requires(post): /sbin/install-info
Requires(preun): /sbin/install-info

#copylib
Provides: bundled(gnulib)

%description
The sed (Stream EDitor) editor is a stream or batch (non-interactive)
editor.  Sed takes text as input, performs an operation or set of
operations on the text and outputs the modified text.  The operations
that sed performs (substitutions, deletions, insertions, etc.) can be
specified in a script file or from the command line.

%package fivextra
Summary: FIV Tests for %{name}
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains the testcases built from the package for %{name}

%prep
%setup -q -a 999
%patch0 -p1 -b .copy
%{?cross_build:%patch70275 -p1}

%build
%configure --without-included-regex %{?cross_build:--disable-html}
make %{_smp_mflags}
install -m 644 -p %{SOURCE1} sedfaq.txt
gzip -9 sedfaq.txt

pushd fivextra
make all
popd

%check
echo ====================TESTING=========================
make check
echo ====================TESTING END=====================

%install
rm -rf ${RPM_BUILD_ROOT}
make DESTDIR=$RPM_BUILD_ROOT install
rm -f ${RPM_BUILD_ROOT}/%{_infodir}/dir

# Steps to package the sed tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%find_lang %{name}

%post
/sbin/install-info %{_infodir}/sed.info.gz %{_infodir}/dir || &> /dev/null
:

%preun
if [ $1 = 0 ]; then
   /sbin/install-info --delete %{_infodir}/sed.info.gz %{_infodir}/dir || &> /dev/null
fi
:

%clean
rm -rf ${RPM_BUILD_ROOT}

%files -f %{name}.lang
%defattr(-,root,root)
%doc BUGS NEWS THANKS README AUTHORS sedfaq.txt.gz COPYING COPYING.DOC
%{_bindir}/sed
%if ! 0%{?cross_build}
%{_infodir}/*.info*
%{_mandir}/man*/*
%endif

%files fivextra
%{prefix}

%changelog
* Wed May 22 2013 baseuser@ibm.com
- Base-8.x spec file
