
## lyx-fonts
%global fontname lyx
%if 1
%define fontpackages 1
BuildRequires: fontpackages-devel
%else
%define _fontdir %{_datadir}/fonts/%{fontname}
%endif

%define _without_included_boost --without-included-boost

Summary: WYSIWYM (What You See Is What You Mean) document processor
Name:	 lyx
Version: 2.0.6
%define base_release .1
Release: 1%{?dist}%{?base_release}

License: GPLv2+
Group: 	 Applications/Publishing
Url: 	 http://www.lyx.org/
Source0: ftp://ftp.lyx.org/pub/lyx/stable/2.0.x/lyx-%{version}.tar.xz
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

Source1: lyxrc.dist
Source10: lyx.desktop

## upstreamable patches
# submitted, but upstream rejected it.  we currently agree to disagree.
Patch50: lyx-2.0.6-xdg_open.patch
# Do we need to rebuild configuration files?
%global autotools 0

%if 0%{?autotools}
BuildRequires: automake libtool
%endif
BuildRequires: enchant-devel
%if 0%{?_without_included_boost:1}
BuildRequires: boost-devel
%endif
BuildRequires: desktop-file-utils
BuildRequires: gettext
BuildRequires: hunspell-devel
BuildRequires: python
BuildRequires: qt4-devel
BuildRequires: zlib-devel

# optional minimal qt4 dep
%{?_qt_version:Requires: qt4 >= %{_qt4_version}}

Obsoletes: %{name}-qt < 1.5.0
Provides:  %{name}-qt = %{version}-%{release}
Obsoletes: %{name}-xforms < 1.5.0

Requires: %{name}-common = %{version}-%{release}

Requires: %{fontname}-fonts = %{version}-%{release}

%if 0%{?fedora} > 8 || 0%{?rhel} > 5
%if 0%{?fedora} > 17
BuildRequires: texlive-texmf-fonts
%else
BuildRequires: texlive-fonts
%endif
BuildRequires: tex(dvips) tex(latex)
Requires: dvipdfm
Requires: tex(dvips) tex(latex)
Requires: tex-simplecv
%else
BuildRequires: tetex-dvips tetex-latex tetex-fonts
Requires: tetex-dvips tetex-latex
%endif


%if 0%{?fedora} > 8 || 0%{?rhel} > 5
Requires(post): texlive
Requires(postun): texlive
%else
Requires(post): tetex-fonts
Requires(postun): tetex-fonts
%endif

Requires: ghostscript
## Soft dependencies
%if 0%{?fedora} > 3 && 0%{?fedora} < 9
# Document->Change Tracking feature
Requires: tetex-dvipost
Requires: tetex-preview
Requires: tetex-IEEEtran
%endif
# convert doc files to lyx (bug #193858)
Requires: wv
Requires: xdg-utils
# required for instant preview
# we use a file require because depending on the texlive version used
# the package can either be texlive-dviutils for texlive 2007 or
# texlive-dtl-bin for texlive >= 2010
Requires: /usr/bin/dv2dt
Requires: ImageMagick

%description
LyX is a modern approach to writing documents which breaks with the
obsolete "typewriter paradigm" of most other document preparation
systems.

It is designed for people who want professional quality output
with a minimum of time and effort, without becoming specialists in
typesetting.

The major innovation in LyX is WYSIWYM (What You See Is What You Mean).
That is, the author focuses on content, not on the details of formatting.
This allows for greater productivity, and leaves the final typesetting
to the backends (like LaTeX) that are specifically designed for the task.

With LyX, the author can concentrate on the contents of his writing,
and let the computer take care of the rest.

%package common
Summary:  Common files of %{name}
Group:    Applications/Publishing
Requires: %{name} = %{version}-%{release}
BuildArch: noarch
%description common
{summary}.

%package fonts
Summary: Lyx/MathML fonts
Group:   Applications/Publishing
# The actual license says "The author of these fonts, Basil K. Malyshev, has
# kindly granted permission to use and modify these fonts."
# One of the font files (wasy10) is separately licensed GPL+.
License: Copyright only and GPL+
%{?fontpackages:Requires: fontpackages-filesystem}
Obsoletes: mathml-fonts < 1.0-50
Provides:  mathml-fonts = 1.0-50
Obsoletes: lyx-fonts-common < 1.6.5-3
Obsoletes: lyx-fonts-compat < 1.6.5-3
Obsoletes: lyx-cmex10-fonts < 1.6.5-3
Obsoletes: lyx-cmmi10-fonts < 1.6.5-3
Obsoletes: lyx-cmr10-fonts < 1.6.5-3
Obsoletes: lyx-cmsy10-fonts < 1.6.5-3
Obsoletes: lyx-esint10-fonts < 1.6.5-3
Obsoletes: lyx-eufm10-fonts < 1.6.5-3
Obsoletes: lyx-msam10-fonts < 1.6.5-3
Obsoletes: lyx-msbm10-fonts < 1.6.5-3
Obsoletes: lyx-wasy10-fonts < 1.6.5-3
Provides:  lyx-cmex10-fonts = %{version}-%{release}
Provides:  lyx-cmmi10-fonts = %{version}-%{release}
Provides:  lyx-cmr10-fonts = %{version}-%{release}
Provides:  lyx-cmsy10-fonts = %{version}-%{release}
BuildArch: noarch
%description  fonts
A collection of Math symbol fonts for %{name}.


%prep

%setup -q -n %{name}-%{version}

%patch50 -p1 -b .xdg_open

%if 0%{?autotools}
./autogen.sh
%endif


%build

%configure \
  --disable-dependency-tracking \
  --disable-rpath \
  --enable-build-type=release \
  --enable-optimization="%{optflags}" \
  --without-included-boost \
  --with-enchant \
  --with-hunspell

make %{?_smp_mflags}


%install
rm -rf %{buildroot}

make install DESTDIR=%{buildroot}

# misc/extras
install -p -m644 -D %{SOURCE1} %{buildroot}%{_datadir}/lyx/lyxrc.dist

# Set up the lyx-specific class files where TeX can see them
texmf=%{_datadir}/texmf
mkdir -p %{buildroot}${texmf}/tex/latex
mv %{buildroot}%{_datadir}/lyx/tex \
   %{buildroot}${texmf}/tex/latex/lyx

# .desktop
desktop-file-install --vendor="" \
  --dir="%{buildroot}%{_datadir}/applications" \
  %{SOURCE10}

# icon
install -p -D -m644 lib/images/lyx.png \
  %{buildroot}%{_datadir}/icons/hicolor/48x48/apps/lyx.png

# ghost'd files
touch %{buildroot}%{_datadir}/lyx/lyxrc.defaults
touch %{buildroot}%{_datadir}/lyx/{packages,textclass}.lst

# fonts
install -m 0755 -d %{buildroot}%{_fontdir}
mv %{buildroot}%{_datadir}/lyx/fonts/*.ttf %{buildroot}%{_fontdir}/
rm -rf %{buildroot}%{_datadir}/lyx/fonts

%find_lang %{name}

# bash completion
install -p -D -m 0644 lib/scripts/bash_completion %{buildroot}%{_sysconfdir}/bash_completion.d/lyx

%check
# tests/test_filetools error bogus ( see http://bugzilla.redhat.com/723938 )
make -k check ||:


%post common
touch --no-create %{_datadir}/icons/hicolor &> /dev/null || :

%postun common
if [ $1 -eq 0 ] ; then
  texhash >& /dev/null
  update-desktop-database -q &> /dev/null
  touch --no-create %{_datadir}/icons/hicolor &> /dev/null
  gtk-update-icon-cache %{_datadir}/icons/hicolor &> /dev/null || :
fi

%posttrans common
texhash >& /dev/null
update-desktop-database -q &> /dev/null
gtk-update-icon-cache %{_datadir}/icons/hicolor &> /dev/null || :

## Catch installed/uninstalled helpers
##   not sure if this is really needed anymore, as it seems to be a per-user thing,
##   and besides, we use xdg-open now -- Rex
#triggerin common -- latex2html,wv
#if [ $2 -gt 1 ]; then
#cd %{_datadir}/lyx && ./configure.py --without-latex-config > /dev/null 2>&1 ||:
#fi
#
#triggerun common -- latex2html,wv
#if [ $2 -eq 0 ]; then
#cd %{_datadir}/lyx && ./configure.py --without-latex-config > /dev/null 2>&1 ||:
#fi


%clean
rm -rf %{buildroot}


%files
%defattr(-,root,root,-)
%doc ANNOUNCE COPYING lib/CREDITS NEWS README
%{_bindir}/*

%files common -f %{name}.lang
%defattr(-,root,root,-)
%{_mandir}/man1/*
%{_datadir}/applications/*.desktop
%{_datadir}/icons/hicolor/*/*/*
%{_datadir}/lyx/
%config(noreplace) %{_datadir}/lyx/lyxrc.dist
%ghost %{_datadir}/lyx/lyxrc.defaults
%ghost %{_datadir}/lyx/*.lst
%{_datadir}/texmf/tex/latex/lyx/
%{_sysconfdir}/bash_completion.d

%if 0%{?fontpackages:1}
%_font_pkg
%{_fontdir}/*.ttf
%doc lib/fonts/BaKoMaFontLicense.txt
%doc lib/fonts/ReadmeBaKoMa4LyX.txt
%else
%files fonts
%defattr(-,root,root,-)
%dir %{_fontdir}/
%{_fontdir}/*.ttf
%doc lib/fonts/BaKoMaFontLicense.txt
%doc lib/fonts/ReadmeBaKoMa4LyX.txt

%posttrans fonts
fc-cache %{_fontdir} 2> /dev/null ||:
%endif


%changelog
* Wed May 28 2014 baseuser@ibm.com
- Base-f19.x spec file
