%if 0%{?fedora} >= 15 || 0%{?rhel} >= 7 || 0%{?base} >= 19
%global with_systemd 1
%endif

%define pbuild 17
%define release .7
%define base_release .14
%define build_tag kimchi-1_2_0-17_10_pkvm2_1_0
Name:		kimchi
Version:	1.2.0
Release:	%{?pbuild}%{?release}%{?dist}%{?base_release}
Summary:	Kimchi server application
BuildRoot:	%{_topdir}/BUILD/%{name}-%{version}-%{release}
Group:		System Environment/Base
License:	LGPL/ASL2
# for tarball building.  Not needed if building out of git
Source0:	kimchi-1.2.0-pkvm2_1.tar.gz
Requires:	qemu-kvm
Requires:	libvirt
Requires:	libvirt-python
Requires:	python-cherrypy >= 3.2.0
Requires:	python-cheetah
Requires:	m2crypto
Requires:	python-imaging
Requires:	libxml2-python
Requires:	PyPAM
Requires:	pyparted
Requires:	python-psutil >= 0.6.0
Requires:	python-jsonschema >= 1.3.0
Requires:	python-ethtool
Requires:	sos
Requires:	python-ipaddr
Requires:	python-lxml
Requires:	nfs-utils
Requires:	nginx
Requires:	iscsi-initiator-utils
Requires:	policycoreutils
Requires:	policycoreutils-devel
Requires:	policycoreutils-python

Requires(post): policycoreutils
Requires(post): policycoreutils-python
Requires(post): selinux-policy-targeted
Requires(postun): policycoreutils
Requires(postun): policycoreutils-python
Requires(postun): selinux-policy-targeted

%if 0%{?rhel} == 6
Requires:	python-ordereddict
Requires:	python-imaging
BuildRequires:    python-unittest2
%endif

%if 0%{?with_systemd}
Requires:	systemd
Requires:	firewalld
Requires(post): systemd
Requires(post): firewalld
Requires(preun): systemd
Requires(preun): firewalld
Requires(postun): systemd
%endif

%if 0%{?with_systemd}
BuildRequires: systemd-units
%endif

BuildRequires:	git
BuildRequires:	autoconf
BuildRequires:	automake
BuildRequires:	gettext-devel
BuildRequires:  libxslt
BuildRequires:  libxml2-python
BuildRequires:  selinux-policy-devel

%description
Web server application to manage KVM/Qemu virtual machines

%package ginger
Summary:	Host management plugin for the Kimchi server application
Requires:	%{name} = %{version}-%{release}
Requires:	tuned
Requires:	libuser-python
Requires:	powerpc-utils

%description ginger
Kimchi is a web server application application to manage KVM/Qemu
virtual machines. Kimchi-ginger is a plugin to provide host management
functions.

%prep
# for tarball building
#%setup -q

#for building out of git
git clone git://9.42.66.204/littleb/kimchi.git ./
git checkout %{?build_tag}
git log --pretty=oneline |head -n10

%build
./autogen.sh --system
make
cd selinux
make -f /usr/share/selinux/devel/Makefile

%install
rm -rf %{buildroot}
make DESTDIR=%{buildroot} install
install -Dm 0644 src/kimchi/sos.py \
                 %{buildroot}/%{python_sitelib}/sos/plugins/kimchi.py

%if 0%{?with_systemd}
# Install the systemd scripts
install -Dm 0644 contrib/kimchid.service.fedora %{buildroot}%{_unitdir}/kimchid.service
install -Dm 0640 src/firewalld.xml %{buildroot}%{_sysconfdir}/firewalld/services/kimchid.xml
install -Dm 0744 src/kimchi-firewalld.sh %{buildroot}%{_datadir}/kimchi/utils/kimchi-firewalld.sh
install -Dm 0744 selinux/kimchid.pp %{buildroot}%{_datadir}/kimchi/selinux/kimchid.pp
%endif

%if 0%{?rhel} == 6
# Install the upstart script
install -Dm 0755 contrib/kimchid-upstart.conf.fedora %{buildroot}/etc/init/kimchid.conf
%endif
%if 0%{?rhel} == 5
# Install the SysV init scripts
install -Dm 0755 contrib/kimchid.sysvinit %{buildroot}%{_initrddir}/kimchid
%endif

%post
if [ $1 -eq 1 ] ; then
    /bin/systemctl enable kimchid.service >/dev/null 2>&1 || :
    # Initial installation
    /bin/systemctl daemon-reload >/dev/null 2>&1 || :
fi

sed -i s/#host/host/ /etc/kimchi/kimchi.conf
service firewalld status >/dev/null 2>&1
if [ $? -ne 0 ]; then
    service firewalld start >/dev/null 2>&1
fi
if [ $1 -eq 1 ]; then
    # Add kimchid as default service into public chain of firewalld
    %{_datadir}/kimchi/utils/kimchi-firewalld.sh public add kimchid
    firewall-cmd --reload > /dev/null 2>&1 || :
fi
# Install SELinux policy
semodule -i %{_datadir}/kimchi/selinux/kimchid.pp


%preun
if [ $1 -eq 0 ] ; then
    # Package removal, not upgrade
    /bin/systemctl --no-reload disable kimchid.service > /dev/null 2>&1 || :
    /bin/systemctl stop kimchid.service > /dev/null 2>&1 || :
    %{_datadir}/kimchi/utils/kimchi-firewalld.sh public del kimchid
    firewall-cmd --reload >/dev/null 2>&1 || :
fi
exit 0

%postun
if [ "$1" -ge 1 ] ; then
    /bin/systemctl try-restart kimchid.service >/dev/null 2>&1 || :
fi
if [ $1 -eq 0 ]; then
    # Remove the SELinux policy, only during uninstall of the package
    semodule -r kimchid
fi
exit 0

%posttrans
# Force the installation of SELinux policy
semodule -i %{_datadir}/kimchi/selinux/kimchid.pp

%clean
rm -rf $RPM_BUILD_ROOT

%post ginger
%if 0%{?with_systemd}
install -dm 0755 /usr/lib/systemd/system/kimchid.service.requires
ln -sf ../tuned.service /usr/lib/systemd/system/kimchid.service.requires
/bin/systemctl daemon-reload >/dev/null 2>&1 || :
%endif


%postun ginger
%if 0%{?with_systemd}
rm -f /usr/lib/systemd/system/kimchid.service.requires/tuned.service
/bin/systemctl daemon-reload >/dev/null 2>&1 || :
service kimchid restart
%endif

%files
%attr(-,root,root)
%{_bindir}/kimchid
%{python_sitelib}/kimchi/*.py*
%{python_sitelib}/kimchi/control/*.py*
%{python_sitelib}/kimchi/control/vm/*.py*
%{python_sitelib}/kimchi/model/*.py*
%{python_sitelib}/kimchi/API.json
%{python_sitelib}/sos/plugins/kimchi.py*
%{_datadir}/kimchi/doc/API.md
%{_datadir}/kimchi/doc/README.md
%{_datadir}/kimchi/doc/kimchi-guest.png
%{_datadir}/kimchi/doc/kimchi-templates.png
%{_datadir}/kimchi/mo/*/LC_MESSAGES/kimchi.mo
%{_datadir}/kimchi/config/ui/*.xml
%{_datadir}/kimchi/ui/css/fonts/fontawesome-webfont.*
%{_datadir}/kimchi/ui/css/fonts/novnc/Orbitron700.*
%{_datadir}/kimchi/ui/css/novnc/base.css
%{_datadir}/kimchi/ui/css/theme-default.min.css
%{_datadir}/kimchi/ui/images/*.png
%{_datadir}/kimchi/ui/images/*.ico
%{_datadir}/kimchi/ui/images/theme-default/*.png
%{_datadir}/kimchi/ui/images/theme-default/*.gif
%{_datadir}/kimchi/ui/js/kimchi.min.js
%{_datadir}/kimchi/ui/js/jquery-ui.js
%{_datadir}/kimchi/ui/js/jquery.min.js
%{_datadir}/kimchi/ui/js/modernizr.custom.2.6.2.min.js
%{_datadir}/kimchi/ui/js/novnc/*.js
%{_datadir}/kimchi/ui/js/spice/*.js
%{_datadir}/kimchi/ui/js/novnc/web-socket-js/WebSocketMain.swf
%{_datadir}/kimchi/ui/js/novnc/web-socket-js/swfobject.js
%{_datadir}/kimchi/ui/js/novnc/web-socket-js/web_socket.js
%{_datadir}/kimchi/ui/libs/jquery-ui-i18n.min.js
%{_datadir}/kimchi/ui/libs/jquery-ui.min.js
%{_datadir}/kimchi/ui/libs/jquery-1.10.0.min.js
%{_datadir}/kimchi/ui/libs/modernizr.custom.76777.js
%{_datadir}/kimchi/ui/libs/themes/base/images/*.png
%{_datadir}/kimchi/ui/libs/themes/base/images/*.gif
%{_datadir}/kimchi/ui/libs/themes/base/jquery-ui.min.css
%{_datadir}/kimchi/ui/pages/*.html.tmpl
%{_datadir}/kimchi/ui/pages/help/*/*.html
%{_datadir}/kimchi/ui/pages/tabs/*.html.tmpl
%{_datadir}/kimchi/ui/pages/websockify/*.html
%{_sysconfdir}/kimchi/kimchi.conf
%{_sysconfdir}/kimchi/nginx.conf.in
%{_sysconfdir}/kimchi/distros.d/debian.json
%{_sysconfdir}/kimchi/distros.d/fedora.json
%{_sysconfdir}/kimchi/distros.d/opensuse.json
%{_sysconfdir}/kimchi/distros.d/ubuntu.json
%{_sysconfdir}/kimchi/distros.d/gentoo.json

%if 0%{?with_systemd}
%{_unitdir}/kimchid.service
%{_datadir}/kimchi/utils/kimchi-firewalld.sh
%{_datadir}/kimchi/selinux/kimchid.pp
%{_sysconfdir}/firewalld/services/kimchid.xml
%endif
%if 0%{?rhel} == 6
/etc/init/kimchid.conf
%endif
%if 0%{?rhel} == 5
%{_initrddir}/kimchid
%endif

%files ginger
%attr(-,root,root)
%{python_sitelib}/kimchi/plugins/*.py*
%{python_sitelib}/kimchi/plugins/ginger/*.py*
%{python_sitelib}/kimchi/plugins/ginger/API.json
%{python_sitelib}/kimchi/plugins/ginger/controls/*.py*
%{python_sitelib}/kimchi/plugins/ginger/models/*.py*
%{_datadir}/kimchi/plugins/ginger/mo
%{_datadir}/kimchi/plugins/ginger/ui/config/tab-ext.xml
%{_datadir}/kimchi/plugins/ginger/ui/css/base/images/*.gif
%{_datadir}/kimchi/plugins/ginger/ui/css/base/images/*.png
%{_datadir}/kimchi/plugins/ginger/ui/css/ginger.css
%{_datadir}/kimchi/plugins/ginger/ui/css/host-admin.css
%{_datadir}/kimchi/plugins/ginger/ui/js/host-admin.js
%{_datadir}/kimchi/plugins/ginger/ui/js/util.js
%{_datadir}/kimchi/plugins/ginger/ui/pages/host-admin.html.tmpl
%{_datadir}/kimchi/plugins/ginger/ui/pages/i18n.html.tmpl
%{_sysconfdir}/kimchi/plugins.d/ginger.conf

%changelog
* Tue Feb 04 2014 baseuser@ibm.com
- Base-f19.x spec file
