# if 0%{?fedora} || 0%{?rhel} > 6
# global with_python3 1
# paste is not python3 compatible at this time
# else
%{!?python_sitelib: %global python_sitelib %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib()")}
# endif

Name:           python-paste
Version:        1.7.5.1
%define base_release .2
Release:        8.20111221hg1498%{?dist}%{?base_release}
Summary:        Tools for using a Web Server Gateway Interface stack
Group:          System Environment/Libraries
# Most of the code is MIT
# paste/exceptions/collector.py is ZPLv2.0
# paste/evalexception/mochikit/MochiKit.js AFL or MIT
# paste/lint.py MIT or Apache v2
# subproccess24.py PySourceColor.py, Python
# doctest24.py, Public Domain
License: MIT and ZPLv2.0 and Python and Public Domain and (AFL or MIT) and (MIT or ASL 2.0)
URL:            http://pythonpaste.org
# All files arent included in the 0.7.5.1 release.  Take a snapshot to get
# unittests working and pick up three bugfixes as well
# hg clone -r 1498 https://bitbucket.org/ianb/paste
# cd paste
# patch -p1 < ../paste-manifest.patch
# python setup.py sdist
# Source is in dist/Paste-1.7.5.1.tar.gz
Source0:        Paste-%{version}.tar.gz
#Source0:        http://pypi.python.org/pypi/packages/source/P/Paste/Paste-%{version}.tar.gz
# In one remaining place, make sure we check for string in the stdlib before we use our copy
Patch0: paste-unbundle-stdlib.patch
# Use a system version of python-tempita before our bundled copy
Patch1: paste-unbundle-tempita.patch
Patch2: paste-27-lambda.patch
# Fix parsing of digest key value pairs
# Submitted upstream pull request
Patch3: paste-digest-snap.patch
# Submitted upstream pull request with this change.
# This patch is needed when creating the tarball, not during rpm build
Patch100: paste-manifest.patch
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildArch:      noarch

BuildRequires:  python2-devel
BuildRequires:  python-setuptools
BuildRequires: python-nose
BuildRequires: python-tempita
BuildRequires: pyOpenSSL
Requires: python-tempita
Requires: pyOpenSSL
Requires:  python-setuptools

%if 0%{?with_python3}
BuildRequires: python3-devel
BuildRequires: python3-setuptools
BuildRequires: python3-nose
BuildRequires: python3-tempita
BuildRequires: /usr/bin/2to3
%endif # if with_python3

%description
These provide several pieces of "middleware" (or filters) that can be nested
to build web applications.  Each piece of middleware uses the WSGI (PEP 333)
interface, and should be compatible with other middleware based on those
interfaces.

%if 0%{?with_python3}
%package -n python3-paste
Summary:        Tools for using a Web Server Gateway Interface stack
Group:          System Environment/Libraries
Requires: python3-tempita
Requires: python3-setuptools
# TODO is there a pyOpenSSL for python3

%description -n python3-paste
These provide several pieces of "middleware" (or filters) that can be nested
to build web applications.  Each piece of middleware uses the WSGI (PEP 333)
interface, and should be compatible with other middleware based on those
interfaces.
%endif # with_python3


%prep
%setup -q -n Paste-%{version}
%patch0 -p1 -b .stdlib
rm paste/util/subprocess24.py
%patch1 -p1 -b .tmpta
%patch2 -p1 -b .27lambda
%patch3 -p1 -b .digest
# Strip #! lines that make these seem like scripts
%{__sed} -i -e '/^#!.*/,1 d' paste/util/scgiserver.py paste/debug/doctest_webapp.py

# clean docs directory
pushd docs
rm StyleGuide.txt
popd

%if 0%{?with_python3}
rm -rf %{py3dir}
cp -a . %{py3dir}
2to3 --write --nobackups %{py3dir}
%endif # with_python3

%build
%{__python} setup.py build

%if 0%{?with_python3}
pushd %{py3dir}
%{__python3} setup.py build
popd
%endif # with_python3


%install
rm -rf %{buildroot}
%{__python} setup.py install --skip-build --root %{buildroot}

%if 0%{?with_python3}
pushd %{py3dir}
%{__python3} setup.py install --skip-build --root $RPM_BUILD_ROOT
popd
%endif # with_python3

%check
export PYTHONPATH=$(pwd)
# We don't have access to the wider internet in the buildsystem
nosetests -e '.*test_paste_website'

%if 0%{?with_python3}
pushd %{py3dir}
export PYTHONPATH=$(pwd)
nosetests-%{python3_version}
popd
%endif # with_python3

%clean
rm -rf %{buildroot}


%files
%defattr(-,root,root,-)
%doc docs/*
%{python_sitelib}/*

%if 0%{?with_python3}
%files -n python3-paste
%defattr(-,root,root,-)
%{python3_sitelib}/*
%endif


%changelog
* Mon Dec 16 2013 baseuser@ibm.com
- Base-8.x spec file
