Summary: The GNU version of the awk text processing utility
Name: gawk
Version: 4.0.2
%define base_release .4
Release: 2%{?dist}%{?base_release}
# Most of source files are licensed under GPLv3+,
# several files are GPL or LGPLv2.1+ licensed,
# gettext.h is LGPL and random.c is BSD licensed
License: GPLv3+ and GPL and LGPLv3+ and LGPL and BSD
Group: Applications/Text
URL: http://www.gnu.org/software/gawk/gawk.html
Source0: http://ftp.gnu.org/gnu/gawk/gawk-%{version}.tar.gz
Source999: fivextra.tar.bz2
Requires(post): /sbin/install-info
Requires(preun): /sbin/install-info
Conflicts: filesystem < 3
Provides: /bin/awk
Provides: /bin/gawk
BuildRequires: byacc

%description
The gawk package contains the GNU version of awk, a text processing
utility. Awk interprets a special-purpose programming language to do
quick and easy text pattern matching and reformatting jobs.

Install the gawk package if you need a text processing utility. Gawk is
considered to be a standard Linux tool for processing text.

%package fivextra
Summary: FIV Tests for %{name}
Group: fivextra
Prefix: /opt/fiv/ltp
#Requires: %{name} >= %{version}-%{release}
Requires: make

%description fivextra
This package contains the testcases built from the package for %{name}.

%prep
%setup -q -a 999

%build
%configure --with-libsigsegv-prefix=no
make %{?_smp_mflags}

pushd fivextra
make all
popd

%check
make check diffout

%install
rm -rf $RPM_BUILD_ROOT
make install DESTDIR=${RPM_BUILD_ROOT}

mkdir -p $RPM_BUILD_ROOT%{_bindir}
ln -sf gawk.1.gz $RPM_BUILD_ROOT%{_mandir}/man1/awk.1.gz
ln -sf gawk $RPM_BUILD_ROOT%{_bindir}/awk
# remove %{version}* , when we are building a snapshot...
rm -f $RPM_BUILD_ROOT/%{_bindir}/{,p}gawk-%{version}* $RPM_BUILD_ROOT%{_infodir}/dir

#FIV Changes
mkdir -p $RPM_BUILD_ROOT/%{fivdir}/%{name}
cp -a test $RPM_BUILD_ROOT/%{fivdir}/%{name}/%{name}-tests
sed -i "s;/tmp/gawk;/bin/gawk;" $RPM_BUILD_ROOT/%{fivdir}/%{name}/%{name}-tests/poundbang.awk

# Steps to package the gawk tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%find_lang %name

%clean
rm -rf $RPM_BUILD_ROOT

%post
if [ -f %{_infodir}/gawk.info.gz ]; then
    /sbin/install-info %{_infodir}/gawk.info.gz %{_infodir}/dir || :
fi

%preun
if [ $1 = 0 -a -f %{_infodir}/gawk.info.gz ]; then
    /sbin/install-info --delete %{_infodir}/gawk.info.gz %{_infodir}/dir || :
fi

%files -f %{name}.lang
%defattr(-,root,root,-)
%doc README COPYING FUTURES LIMITATIONS NEWS
%doc README_d/README.multibyte README_d/README.tests POSIX.STD
%{_bindir}/*awk
%{_mandir}/man1/*
%{_infodir}/gawk.info*
%{_infodir}/gawkinet.info*
%{_libexecdir}/awk
%{_datadir}/awk

%files fivextra
%defattr(-,root,root)
%{prefix}

%changelog
* Fri May 03 2013 baseuser@ibm.com
- Base-8.x spec file
