# This is stable release:
#%%global rcversion RC1
Name: pcre
Version: 8.32
%define base_release .5
Release: %{?rcversion:0.}7%{?rcversion:.%rcversion}%{?dist}%{?base_release}
%global myversion %{version}%{?rcversion:-%rcversion}
Summary: Perl-compatible regular expression library
Group: System Environment/Libraries
License: BSD
URL: http://www.pcre.org/
Source: ftp://ftp.csx.cam.ac.uk/pub/software/programming/%{name}/%{?rcversion:Testing/}%{name}-%{myversion}.tar.bz2
Source999: fivextra.tar.bz2
# Upstream thinks RPATH is good idea.
Patch0: pcre-8.21-multilib.patch
# Refused by upstream, bug #675477
Patch1: pcre-8.32-refused_spelling_terminated.patch
# In upstream after 8.32
Patch2: pcre-8.32-Fix-forward-search-in-JIT-when-link-size-is-3-or-gre.patch
# In upstream after 8.32
Patch3: pcre-8.32-Fix-two-buffer-over-read-issues-in-16-and-32-bit-mod.patch
# Fix pcregrep on empty line, in upstream after 8.33-RC1
Patch4: pcre-8.33-RC1-Fix-pcregrep-so-that-it-can-find-empty-lines.patch
# Grow buffer in pcretest properly, in upstream after 8.33-RC1
Patch5: pcre-8.33-RC1-Fix-pcretest-crash-with-a-data-line-longer-than-6553.patch
# Fix passing too small output vector to pcre_dfa_exec, in upstream after
# 8.33-RC1, bug #963284
Patch6: pcre-8.33-RC1-Fix-segfault-when-pcre_dfa_exec-is-called-with-an-ou.patch
BuildRequires: readline-devel
# New libtool to get rid of rpath
BuildRequires: autoconf, automake, libtool

%description
Perl-compatible regular expression library.
PCRE has its own native API, but a set of "wrapper" functions that are based on
the POSIX API are also supplied in the library libpcreposix. Note that this
just provides a POSIX calling interface to PCRE: the regular expressions
themselves still follow Perl syntax and semantics. The header file
for the POSIX-style functions is called pcreposix.h.

%package devel
Summary: Development files for %{name}
Group: Development/Libraries
Requires: %{name}%{?_isa} = %{version}-%{release}

%description devel
Development files (Headers, libraries for dynamic linking, etc) for %{name}.

%package static
Summary: Static library for %{name}
Group: Development/Libraries
Requires: %{name}-devel%{_isa} = %{version}-%{release}

%description static
Library for static linking for %{name}.

%package tools
Summary: Auxiliary utilities for %{name}
Group: Development/Tools
Requires: %{name}%{_isa} = %{version}-%{release}

%description tools
Utilities demonstrating PCRE capabilities like pcregrep or pcretest.

%package fivextra
Summary: Tests for FIV
Group: fivextra
Prefix: /opt/fiv/ltp
Requires: pcre-tools

%description fivextra
This package contains the testcases built from the package for %{name}.

%prep
%setup -q -n %{name}-%{myversion} -a 999
# Get rid of rpath
%patch0 -p1 -b .multilib
%patch1 -p1 -b .terminated_typos
%patch2 -p1 -b .forward_jit
%patch3 -p1 -b .buffer_over_read
%patch4 -p1 -b .pcregrep_empty_line
%patch5 -p1 -b .pcretest_grow_buffer
%patch6 -p1 -b .vector_size
# Because of rpath patch
libtoolize --copy --force && autoreconf -vif
# One contributor's name is non-UTF-8
for F in ChangeLog; do
    iconv -f latin1 -t utf8 "$F" >"${F}.utf8"
    touch --reference "$F" "${F}.utf8"
    mv "${F}.utf8" "$F"
done

%build
%configure \
%ifarch aarch64 s390 s390x sparc64 sparcv9
    --disable-jit \
%else
    --enable-jit \
%endif
    --enable-pcretest-libreadline --enable-utf --enable-unicode-properties \
    --enable-pcre8 --enable-pcre16 --enable-pcre32
make %{?_smp_mflags}

pushd fivextra
make all
popd

%install
make install DESTDIR=$RPM_BUILD_ROOT
# Get rid of unneeded *.la files
rm -f $RPM_BUILD_ROOT%{_libdir}/*.la
# These are handled by %%doc in %%files
rm -rf $RPM_BUILD_ROOT%{_docdir}/pcre

# FIV Changes
mkdir -p $RPM_BUILD_ROOT%{fivdir}/%{name}/%{name}-tests/
cp -a testdata $RPM_BUILD_ROOT%{fivdir}/%{name}/%{name}-tests/
cp .libs/pcrecpp_unittest  $RPM_BUILD_ROOT%{fivdir}/%{name}/%{name}-tests/
cp pcrecpp_unittest.cc  $RPM_BUILD_ROOT%{fivdir}/%{name}/%{name}-tests/
cp .libs/pcre_scanner_unittest $RPM_BUILD_ROOT%{fivdir}/%{name}/%{name}-tests/
cp pcre_scanner_unittest.cc $RPM_BUILD_ROOT%{fivdir}/%{name}/%{name}-tests/
cp .libs/pcre_stringpiece_unittest $RPM_BUILD_ROOT%{fivdir}/%{name}/%{name}-tests/
cp pcre_stringpiece_unittest.cc $RPM_BUILD_ROOT%{fivdir}/%{name}/%{name}-tests/
cp pcregrep $RPM_BUILD_ROOT%{fivdir}/%{name}/%{name}-tests/
cp pcretest $RPM_BUILD_ROOT%{fivdir}/%{name}/%{name}-tests/

# Steps to package the pcre tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print`  $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done
find $RPM_BUILD_ROOT/%{fivdir}/%{name} -depth -name CVS -type d -exec rm -rf {} \;

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%check
%ifarch s390 ppc
# larger stack is needed on s390, ppc
ulimit -s 10240
%endif
make check

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%{_libdir}/*.so.*
%doc AUTHORS COPYING LICENCE NEWS README ChangeLog

%files devel
%{_libdir}/*.so
%{_libdir}/pkgconfig/*
%{_includedir}/*.h
%{_mandir}/man1/pcre-config.*
%{_mandir}/man3/*
%{_bindir}/pcre-config
%doc doc/*.txt doc/html
%doc HACKING

%files static
%{_libdir}/*.a
%doc COPYING LICENCE 

%files tools
%{_bindir}/pcregrep
%{_bindir}/pcretest
%{_mandir}/man1/pcregrep.*
%{_mandir}/man1/pcretest.*

%files fivextra
%defattr(-,root,root)
%{prefix}

%changelog
* Fri Jul 05 2013 baseuser@ibm.com
- Base-8.x spec file
