Name:           nettle
Version:        2.6
%define base_release .4
Release:        2%{?dist}%{?base_release}
Summary:        A low-level cryptographic library

Group:          Development/Libraries
License:        LGPLv2+
URL:            http://www.lysator.liu.se/~nisse/nettle/
Source0:        http://www.lysator.liu.se/~nisse/archive/%{name}-%{version}.tar.gz
Source999:	fivextra.tar.bz2

BuildRequires:  gmp-devel m4 texinfo-tex texlive-dvips ghostscript

Requires(post): info
Requires(preun): info


%package devel
Summary:        Development headers for a low-level cryptographic library
Group:          Development/Libraries
Requires:       %{name} = %{version}-%{release}
Requires:       gmp-devel%{?_isa}

%description
Nettle is a cryptographic library that is designed to fit easily in more
or less any context: In crypto toolkits for object-oriented languages
(C++, Python, Pike, ...), in applications like LSH or GNUPG, or even in
kernel space.

%description devel
Nettle is a cryptographic library that is designed to fit easily in more
or less any context: In crypto toolkits for object-oriented languages
(C++, Python, Pike, ...), in applications like LSH or GNUPG, or even in
kernel space.  This package contains kernel headers.

%package fivextra
Summary: FIV Tests for %{name}
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains the testcases built from the package for %{name}

%prep
%setup -q -a 999
# Disable -ggdb3 which makes debugedit unhappy
sed s/ggdb3/g/ -i configure

%build
%configure --enable-shared
make %{?_smp_mflags}

make check || true

%install
make install DESTDIR=$RPM_BUILD_ROOT INSTALL="install -p"
make install-shared DESTDIR=$RPM_BUILD_ROOT INSTALL="install -p"
mkdir -p $RPM_BUILD_ROOT%{_infodir}
install -p -m 644 nettle.info $RPM_BUILD_ROOT%{_infodir}/
rm -f $RPM_BUILD_ROOT%{_libdir}/*.a
rm -f $RPM_BUILD_ROOT%{_infodir}/dir
chmod 0755 $RPM_BUILD_ROOT%{_libdir}/libnettle.so.4.*
chmod 0755 $RPM_BUILD_ROOT%{_libdir}/libhogweed.so.2.*

for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir || true
done

for dir in $(find testsuite -type d)
do
 install -m 755 -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
 install -m 755 $(find $dir/* -type d -prune -o -print) $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir || true
done

install -m 755 run-tests $RPM_BUILD_ROOT/%{fivdir}/%{name}/
for dir in $(find examples -type d)
do
 install -m 755 -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
 install -m 755 $(find $dir/* -type d -prune -o -print) $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir || true
done
find $RPM_BUILD_ROOT/%{fivdir}/%{name}/testsuite -name '*.o' -o -name '*.c' -o -name 'Makefile*' | xargs rm -rf
find $RPM_BUILD_ROOT/%{fivdir}/%{name}/examples -name '*.o' -o -name 'Makefile*' | xargs rm -rf

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%check
make check

%files
%doc AUTHORS ChangeLog COPYING.LIB NEWS README TODO
%{_infodir}/nettle.info.gz
%{_bindir}/nettle-lfib-stream
%{_bindir}/pkcs1-conv
%{_bindir}/sexp-conv
%{_bindir}/nettle-hash
%{_libdir}/libnettle.so.4
%{_libdir}/libnettle.so.4.*
%{_libdir}/libhogweed.so.2
%{_libdir}/libhogweed.so.2.*


%files devel
%doc descore.README nettle.html nettle.pdf COPYING.LIB
%{_includedir}/nettle
%{_libdir}/libnettle.so
%{_libdir}/libhogweed.so
%{_libdir}/pkgconfig/hogweed.pc
%{_libdir}/pkgconfig/nettle.pc

%post
/sbin/install-info %{_infodir}/%{name}.info %{_infodir}/dir || :
/sbin/ldconfig

%preun
if [ $1 = 0 ]; then
  /sbin/install-info --delete %{_infodir}/%{name}.info %{_infodir}/dir || :
fi

%postun -p /sbin/ldconfig

%files fivextra
%{prefix}

%changelog
* Thu May 16 2013 baseuser@ibm.com
- Base-8.x spec file
