Name: reiserfs-utils
Version: 3.6.21
%define base_release .2
Release: 8%{?dist}%{?base_release}
Summary: Tools for creating, repairing, and debugging ReiserFS filesystems
#URL: http://www.namesys.com/
URL: http://ftp.kernel.org/pub/linux/utils/fs/reiserfs/
#Source0: ftp://namesys.com/pub/reiserfsprogs/reiserfsprogs-%{version}.tar.gz
Source0: http://ftp.kernel.org/pub/linux/utils/fs/reiserfs/reiserfsprogs-%{version}.tar.bz2
# See README.
License: GPLv2 with exceptions
Group: System Environment/Base
BuildRoot: %{_tmppath}/%{name}-root
Epoch: 2
BuildRequires: e2fsprogs-devel
BuildRequires: libuuid-devel

%description
The reiserfs-utils package contains a number of utilities for
creating, checking, modifying, and correcting any inconsistencies in
ReiserFS filesystems, including reiserfsck (used to repair filesystem
inconsistencies), mkreiserfs (used to initialize a partition to
contain an empty ReiserFS filesystem), debugreiserfs (used to examine
the internal structure of a filesystem, to manually repair a corrupted
filesystem, or to create test cases for reiserfsck), and some other
ReiserFS filesystem utilities.

You should install the reiserfs-utils package if you want to use
ReiserFS on any of your partitions.

%prep
%setup -q -n reiserfsprogs-%{version}

%build
export CFLAGS="$RPM_OPT_FLAGS" CXXFLAGS="$RPM_OPT_FLAGS"
find . -name "config.cache" |xargs rm -f
%configure
make %{?_smp_mflags}

%install
rm -rf $RPM_BUILD_ROOT
make install DESTDIR="$RPM_BUILD_ROOT"
mv -f $RPM_BUILD_ROOT/usr/sbin $RPM_BUILD_ROOT/sbin
mkdir -p $RPM_BUILD_ROOT%{_mandir}/man8
install -m644 debugreiserfs/debugreiserfs.8 $RPM_BUILD_ROOT%{_mandir}/man8
install -m644 fsck/reiserfsck.8 $RPM_BUILD_ROOT%{_mandir}/man8
install -m644 mkreiserfs/mkreiserfs.8 $RPM_BUILD_ROOT%{_mandir}/man8
( cd $RPM_BUILD_ROOT/sbin
  ln -fs mkreiserfs mkfs.reiserfs
  ln -fs reiserfsck fsck.reiserfs )

%files
%defattr(-,root,root,-)
%doc README
/sbin/debugreiserfs
/sbin/mkreiserfs
/sbin/reiserfsck
/sbin/resize_reiserfs
/sbin/reiserfstune
/sbin/mkfs.reiserfs
/sbin/fsck.reiserfs
%{_mandir}/*/*

%clean
rm -rf $RPM_BUILD_ROOT

%changelog
* Thu Jun 27 2013 baseuser@ibm.com
- Base-8.x spec file
