Summary:       Tool for creating supermin appliances
Name:          supermin
Version:       4.1.1
%define base_release .7
Release:       1%{?dist}%{?base_release}
License:       GPLv2+

URL:           http://people.redhat.com/~rjones/supermin/
Source0:       http://libguestfs.org/download/supermin/%{name}-%{version}.tar.gz
Patch0:        detect-base.patch

%if 0%{?rhel} >= 7
ExclusiveArch: x86_64
%endif
%if 0%{?base} >= 19
# No ocaml for s390 or cross. Build for intel/power until the other arches are needed.
ExclusiveArch: i686 x86_64 ppc ppc64
%endif

BuildRequires: /usr/bin/pod2man
BuildRequires: yum >= 3.2
BuildRequires: /usr/sbin/mke2fs
BuildRequires: e2fsprogs-devel
BuildRequires: glibc-static, zlib-static
BuildRequires: ocaml, ocaml-findlib-devel
BuildRequires: prelink

Requires:      yum >= 3.2
Requires:      yum-utils
Requires:      supermin-helper%{?_isa} = %{version}-%{release}

# https://fedoraproject.org/wiki/Packaging:No_Bundled_Libraries#Packages_granted_exceptions
Provides:      bundled(gnulib)

# NB: Does NOT Provides, because this is not a compatible replacement.
Obsoletes:     febootstrap <= 3.21-1


%description
Supermin is a tool for building supermin appliances.  These are tiny
appliances (similar to virtual machines), usually around 100KB in
size, which get fully instantiated on-the-fly in a fraction of a
second when you need to boot one of them.


%package helper
Summary:       Runtime support for supermin
Requires:      util-linux-ng
Requires:      cpio
Requires:      /usr/sbin/mke2fs
# RHBZ#771310
Requires:      e2fsprogs-libs >= 1.42

# NB: Does NOT Provides, because this is not a compatible replacement.
Obsoletes:     febootstrap-supermin-helper <= 3.21-1


%description helper
%{name}-helper contains the runtime support for %{name}.


%prep
%setup -q
%patch0 -p1


%build
%configure
make


%install
make DESTDIR=$RPM_BUILD_ROOT install

# supermin-helper is marked as requiring an executable stack.  This
# happens because we use objcopy to create one of the component object
# files from a data file.  The program does not in fact require an
# executable stack.  The easiest way to fix this is to clear the flag
# here.
execstack -c $RPM_BUILD_ROOT%{_bindir}/supermin-helper


%files
%doc COPYING README
%{_bindir}/supermin
%{_mandir}/man8/supermin.8*


%files helper
%doc COPYING
%{_bindir}/supermin-helper
%{_mandir}/man8/supermin-helper.8*


%changelog
* Tue Jun 18 2013 baseuser@ibm.com
- Base-8.x spec file
