Summary: Library providing XML and HTML support
Name: libxml2
Version: 2.9.1
%define base_release .3
Release: 1%{?dist}%{?extra_release}%{?base_release}
License: MIT
Group: Development/Libraries
Source: ftp://xmlsoft.org/libxml2/libxml2-%{version}.tar.gz
Source1: bug6178-remove-files
Source999: fivextra.tar.bz2
BuildRoot: %{_tmppath}/%{name}-%{version}-root
BuildRequires: %{!?cross_build:python python-devel} zlib-devel pkgconfig xz-devel
BuildRequires: fakeroot-tools
URL: http://xmlsoft.org/
Patch0: libxml2-multilib.patch
Patch1: libxml2-2.9.0-do-not-check-crc.patch

#FIV Patches
Patch62733: bug-62733-fiv-libxml2-python-serialize_py-test.diff
#Patch70823: bug-70823-init_ret_value.patch #already present
Patch71806: bug-71806-skip-threadstest.patch
Patch71807: bug-71806-fix-nodes2.xml.patch 

%description
This library allows to manipulate XML files. It includes support
to read, modify and write XML and HTML files. There is DTDs support
this includes parsing and validation even with complex DtDs, either
at parse time or later once the document has been modified. The output
can be a simple SAX stream or and in-memory DOM like representations.
In this case one can use the built-in XPath and XPointer implementation
to select sub nodes or ranges. A flexible Input/Output mechanism is
available, with existing HTTP and FTP modules and combined to an
URI library.

%package devel
Summary: Libraries, includes, etc. to develop XML and HTML applications
Group: Development/Libraries
Requires: libxml2 = %{version}-%{release}
Requires: zlib-devel
Requires: xz-devel
Requires: pkgconfig

%description devel
Libraries, include files, etc you can use to develop XML applications.
This library allows to manipulate XML files. It includes support
to read, modify and write XML and HTML files. There is DTDs support
this includes parsing and validation even with complex DtDs, either
at parse time or later once the document has been modified. The output
can be a simple SAX stream or and in-memory DOM like representations.
In this case one can use the built-in XPath and XPointer implementation
to select sub nodes or ranges. A flexible Input/Output mechanism is
available, with existing HTTP and FTP modules and combined to an
URI library.

%package static
Summary: Static library for libxml2
Group: Development/Libraries
Requires: libxml2 = %{version}-%{release}

%description static
Static library for libxml2 provided for specific uses or shaving a few
microseconds when parsing, do not link to them for generic purpose packages.
%if ! 0%{?cross_build}
%package python
Summary: Python bindings for the libxml2 library
Group: Development/Libraries
Requires: libxml2 = %{version}-%{release}

%description python
The libxml2-python package contains a module that permits applications
written in the Python programming language to use the interface
supplied by the libxml2 library to manipulate XML files.

This library allows to manipulate XML files. It includes support
to read, modify and write XML and HTML files. There is DTDs support
this includes parsing and validation even with complex DTDs, either
at parse time or later once the document has been modified.
%endif

%package fivextra
Summary: Tests for FIV
Group: fivextra
Prefix: /opt/fiv/ltp
#Requires: %{name} >= %{version}-%{release}

%description fivextra
This package contains the testcases built from the package for %{name}.

%prep
%setup -q -n %{name}-%{version} -a 999
%patch0 -p1
# workaround for #877567 - Very weird bug gzip decompression bug in "recent" libxml2 versions
%patch1 -p1 -b .do-not-check-crc

#FIV Changes
%patch62733 -p1
%patch71806 -p1 
%patch71807 -p1 

file_remover.sh %{S:1}

%build
%configure %{?cross_build:--without-python}
make %{_smp_mflags}

pushd fivextra
make all
popd

%install
rm -fr %{buildroot}

make install DESTDIR=%{buildroot}

# multiarch crazyness on timestamp differences or Makefile/binaries for examples
touch -m --reference=$RPM_BUILD_ROOT/%{_includedir}/libxml2/libxml/parser.h $RPM_BUILD_ROOT/%{_bindir}/xml2-config

#install backward compatiblity symlink for libxml - > libxml2/libxml
pushd $RPM_BUILD_ROOT/%{_includedir}
ln -s libxml2/libxml libxml
popd

# Steps for FIV
# This package provides tests for two packages. 
# 1) libxml2
# 2) libxml2-python
# All the test are packaged under %{fivdir}/%{name}/%{name}-tests/
# The python tests are under python/tests/ in the above dir

#libxml2 tests
mkdir -p $RPM_BUILD_ROOT/%{fivdir}/%{name}/
cp -a .libs $RPM_BUILD_ROOT/%{fivdir}/%{name}/%{name}-tests/
# Remove the xmllint and xmlcatalog from the tests rpms
rm -f $RPM_BUILD_ROOT/%{fivdir}/%{name}/%{name}-tests/xml*
cp -a test/ $RPM_BUILD_ROOT/%{fivdir}/%{name}/%{name}-tests/
cp -a result/ $RPM_BUILD_ROOT/%{fivdir}/%{name}/%{name}-tests/
# Clean up object files
( cd $RPM_BUILD_ROOT/%{fivdir}/%{name}/%{name}-tests/; \
       rm -rf lib* Makefile* *.o *.la *.a *.lai *.so* )

#libxml2-python tests
mkdir -p $RPM_BUILD_ROOT/%{fivdir}/%{name}/%{name}-tests/python/tests/
# Copy the python tests from pythons/tests dir
( cd  python/tests; \
    cp -a *.xml *.py test.dtd $RPM_BUILD_ROOT/%{fivdir}/%{name}/%{name}-tests/python/tests/ )

# Steps to package the libxml2 and libxml2-python tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

rm -f $RPM_BUILD_ROOT%{_libdir}/*.la
rm -f $RPM_BUILD_ROOT%{_libdir}/python*/site-packages/*.a
rm -f $RPM_BUILD_ROOT%{_libdir}/python*/site-packages/*.la
rm -rf $RPM_BUILD_ROOT%{_datadir}/doc/libxml2-%{version}/*
rm -rf $RPM_BUILD_ROOT%{_datadir}/doc/libxml2-python-%{version}/*
(cd doc/examples ; make clean ; rm -rf .deps Makefile)
gzip -9 -c doc/libxml2-api.xml > doc/libxml2-api.xml.gz

%check
make runtests

%clean
rm -fr %{buildroot}

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-, root, root)

%doc AUTHORS NEWS README Copyright TODO
%doc %{_mandir}/man1/xmllint.1*
%doc %{_mandir}/man1/xmlcatalog.1*
%doc %{_mandir}/man3/libxml.3*

%{_libdir}/lib*.so.*
%{_bindir}/xmllint
%{_bindir}/xmlcatalog

%files devel
%defattr(-, root, root)

%doc %{_mandir}/man1/xml2-config.1*
%doc AUTHORS NEWS README Copyright
%doc doc/*.html doc/html doc/*.gif doc/*.png
%doc doc/tutorial doc/libxml2-api.xml.gz
%doc doc/examples
%doc %dir %{_datadir}/gtk-doc/html/libxml2
%doc %{_datadir}/gtk-doc/html/libxml2/*.devhelp
%doc %{_datadir}/gtk-doc/html/libxml2/*.html
%doc %{_datadir}/gtk-doc/html/libxml2/*.png
%doc %{_datadir}/gtk-doc/html/libxml2/*.css

%{_libdir}/lib*.so
%{_libdir}/*.sh
%{_includedir}/*
%{_bindir}/xml2-config
%{_datadir}/aclocal/libxml.m4
%{_libdir}/pkgconfig/libxml-2.0.pc

%files static
%defattr(-, root, root)

%{_libdir}/*a

%if ! 0%{?cross_build}
%files python
%defattr(-, root, root)

%{_libdir}/python*/site-packages/libxml2.py*
%{_libdir}/python*/site-packages/drv_libxml2.py*
%{_libdir}/python*/site-packages/libxml2mod*
%doc python/TODO
%doc python/libxml2class.txt
%doc python/tests/*.py
%doc doc/*.py
%doc doc/python.html
%endif

%files fivextra
%{prefix}

%changelog
* Mon Jun 03 2013 baseuser@ibm.com
- Base-8.x spec file
