%global fontname wqy-zenhei
%global fontconf1 65-0-%{fontname}.conf
%global fontconf2 65-0-%{fontname}-sharp.conf
%global common_desc \
WenQuanYi Zen Hei is a Hei-Ti style (sans-serif type) Chinese \
outline font. It is designed for general purpose text formatting \
and on-screen display of Chinese characters and symbols from \
many other languages. The embolden strokes of the font glyphs \
produces enhanced screen contrast, making it easier to read \
recognize. The embedded bitmap glyphs further enhance on-screen \
performance, which can be enabled with the provided configuration \
files. WenQuanYi Zen Hei provides a rather complete coverage to \
Chinese Hanzi glyphs, including both simplified and traditional \
forms. The total glyph number in this font is over 35,000, including \
over 21,000 Chinese Hanzi. This font has full coverage to GBK(CP936) \
charset, CJK Unified Ideographs, as well as the code-points \
needed for zh_cn, zh_sg, zh_tw, zh_hk, zh_mo, ja (Japanese) \
and ko (Korean) locales for fontconfig. Starting from version \
0.8, this font package has contained two font families, i.e. \
the proportionally-spaced Zen Hei, and a mono-spaced face \
named "WenQuanYi Zen Hei Mono".

%global setscript zenheiset

Name:           %{fontname}-fonts
Version:        0.9.46
%define base_release .1
Release:        10%{?dist}%{?base_release}
Summary:        WenQuanYi Zen Hei CJK Font

Group:          User Interface/X
License:        GPLv2 with exceptions
URL:            http://wenq.org/enindex.cgi
Source0:        http://downloads.sourceforge.net/wqy/%{fontname}-%{version}-May.tar.bz2
Source1:        %{fontconf1}
Source2:        %{fontconf2}
Source3:        %{setscript}

BuildArch:      noarch
BuildRequires:  fontpackages-devel
Requires:       fontpackages-filesystem
Obsoletes:      wqy-zenhei-fonts-common < 0.9.45-5
Provides:       wqy-zenhei-fonts-common = %{version}-%{release}

%description
%common_desc

%prep
%setup -q -n %{fontname}

iconv -f GB18030 -t UTF-8 -o AUTHORS.utf8 AUTHORS
touch -r AUTHORS AUTHORS.utf8
mv AUTHORS.utf8 AUTHORS

iconv -f ISO-8859-1 -t UTF-8 -o README.utf8 README
touch -r README README.utf8
mv README.utf8 README

%build
%{nil}

%install
install -m 0755 -d %{buildroot}%{_fontdir}
install -m 0644 -p *.ttc %{buildroot}%{_fontdir}

install -m 0755 -d %{buildroot}%{_fontconfig_templatedir} \
                   %{buildroot}%{_fontconfig_confdir}

install -m 0644 -p %{SOURCE1} \
        %{buildroot}%{_fontconfig_templatedir}/%{fontconf1}
install -m 0644 -p %{SOURCE2} \
        %{buildroot}%{_fontconfig_templatedir}/%{fontconf2}

ln -s %{_fontconfig_templatedir}/%{fontconf2} \
      %{buildroot}%{_fontconfig_confdir}/%{fontconf2}

install -m 0755 -d %{buildroot}%{_bindir}

install -m 0755 -p %{SOURCE3} \
        %{buildroot}%{_bindir}/%{setscript}


%_font_pkg -f ??-?-%{fontname}*.conf *.ttc
%dir %{_fontdir}
%doc AUTHORS ChangeLog COPYING README
%defattr(-, root, root, -)
%{_bindir}/%{setscript}


%changelog
* Wed May 28 2014 baseuser@ibm.com
- Base-f19.x spec file
