Summary: Network monitoring tools including ping
Name: iputils
Version: 20121221
%define base_release .3
Release: 2%{?dist}%{?base_release}
# some parts are under the original BSD (ping.c)
# some are under GPLv2+ (tracepath.c)
License: BSD and GPLv2+
URL: http://www.skbuff.net/iputils
Group: System Environment/Daemons

Source0: http://www.skbuff.net/iputils/%{name}-s%{version}.tar.bz2
Source1: ifenslave.tar.gz
Source3: rdisc.initd
Source4: rdisc.service
Source5: rdisc.sysconfig
Source6: ninfod.service
Source999: fivextra.tar.bz2

Patch0: iputils-20020927-rh.patch
Patch1: iputils-ifenslave.patch
Patch2: iputils-20121221-floodlocale.patch

BuildRequires: docbook-utils perl-SGMLSpm
BuildRequires: glibc-kernheaders >= 2.4-8.19
BuildRequires: libidn-devel
BuildRequires: openssl-devel
BuildRequires: libcap-devel
Requires(post): /sbin/chkconfig
Requires(preun): /sbin/chkconfig
Requires(post): systemd
Requires(preun): systemd
Requires(postun): systemd
BuildRequires: systemd
Requires: filesystem >= 3
Provides: /bin/ping
Provides: /bin/ping6
Provides: /sbin/arping
Provides: /sbin/rdisc

%description
The iputils package contains basic utilities for monitoring a network,
including ping. The ping command sends a series of ICMP protocol
ECHO_REQUEST packets to a specified network host to discover whether
the target machine is alive and receiving network traffic.

%package sysvinit
Group: System Environment/Daemons
Summary: SysV initscript for rdisc daemon
Requires: %{name} = %{version}-%{release}
Requires(preun): /sbin/service
Requires(postun): /sbin/service

%description sysvinit
The iputils-sysvinit contains SysV initscritps support.

%package ninfod
Group: System Environment/Daemons
Summary: Node Information Query Daemon
Requires: %{name} = %{version}-%{release}
Provides: %{_sbindir}/ninfod

%description ninfod
Node Information Query (RFC4620) daemon. Responds to IPv6 Node Information
Queries.

%package fivextra
Summary: Test for %{name} package
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains testcases for %{name}

%prep
%setup -q -a 1 -n %{name}-s%{version} -a 999

%patch0 -p1 -b .rh
%patch1 -p1 -b .addr
%patch2 -p1 -b .floc

%build
%ifarch s390 s390x
  export CFLAGS="-fPIE"
%else
  export CFLAGS="-fpie"
%endif
export LDFLAGS="-pie"
export CC=%{__cc}
%{?cross_build:sed -i 's|./configure|./configure --host=%{_host}|' Makefile}
make CC=%{__cc} %{?_smp_mflags} arping clockdiff ping ping6 rdisc tracepath tracepath6 \
                                ninfod
%{__cc} -Wall $RPM_OPT_FLAGS ifenslave.c -o ifenslave
make -C doc man

pushd fivextra
make all
popd

%install
mkdir -p ${RPM_BUILD_ROOT}%{_sbindir}
mkdir -p ${RPM_BUILD_ROOT}%{_bindir}
mkdir -p $RPM_BUILD_ROOT/%{_unitdir}
mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/sysconfig

install -c clockdiff		${RPM_BUILD_ROOT}%{_sbindir}/
install -cp arping		${RPM_BUILD_ROOT}%{_sbindir}/
install -cp ping		${RPM_BUILD_ROOT}%{_bindir}/
install -cp ifenslave		${RPM_BUILD_ROOT}%{_sbindir}/
install -cp rdisc		${RPM_BUILD_ROOT}%{_sbindir}/
install -cp ping6		${RPM_BUILD_ROOT}%{_bindir}/
install -cp tracepath		${RPM_BUILD_ROOT}%{_bindir}/
install -cp tracepath6		${RPM_BUILD_ROOT}%{_bindir}/
install -cp ninfod/ninfod	${RPM_BUILD_ROOT}%{_sbindir}/

mkdir -p ${RPM_BUILD_ROOT}%{_bindir}
ln -sf ../bin/ping6 ${RPM_BUILD_ROOT}%{_sbindir}
ln -sf ../bin/tracepath ${RPM_BUILD_ROOT}%{_sbindir}
ln -sf ../bin/tracepath6 ${RPM_BUILD_ROOT}%{_sbindir}

mkdir -p ${RPM_BUILD_ROOT}%{_mandir}/man8
install -cp doc/clockdiff.8	${RPM_BUILD_ROOT}%{_mandir}/man8/
install -cp doc/arping.8	${RPM_BUILD_ROOT}%{_mandir}/man8/
install -cp doc/ping.8		${RPM_BUILD_ROOT}%{_mandir}/man8/
install -cp doc/rdisc.8		${RPM_BUILD_ROOT}%{_mandir}/man8/
install -cp doc/tracepath.8	${RPM_BUILD_ROOT}%{_mandir}/man8/
install -cp doc/ninfod.8	${RPM_BUILD_ROOT}%{_mandir}/man8/
install -cp ifenslave.8		${RPM_BUILD_ROOT}%{_mandir}/man8/
ln -s ping.8.gz ${RPM_BUILD_ROOT}%{_mandir}/man8/ping6.8.gz
ln -s tracepath.8.gz ${RPM_BUILD_ROOT}%{_mandir}/man8/tracepath6.8.gz

install -dp ${RPM_BUILD_ROOT}%{_sysconfdir}/rc.d/init.d
install -m 755 -p %SOURCE3 ${RPM_BUILD_ROOT}%{_sysconfdir}/rc.d/init.d/rdisc
install -m 644 %{SOURCE5} $RPM_BUILD_ROOT%{_sysconfdir}/sysconfig/rdisc
install -m 644 %SOURCE4 ${RPM_BUILD_ROOT}/%{_unitdir}
install -m 644 %SOURCE6 ${RPM_BUILD_ROOT}/%{_unitdir}

iconv -f ISO88591 -t UTF8 RELNOTES -o RELNOTES.tmp
touch -r RELNOTES RELNOTES.tmp
mv -f RELNOTES.tmp RELNOTES

# Steps to package the iputils tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%post
%systemd_post rdisc.service

%preun
%systemd_preun rdisc.service

%postun
%systemd_postun_with_restart rdisc.service

%post ninfod
%systemd_post ninfod.service

%preun ninfod
%systemd_preun ninfod.service

%postun ninfod
%systemd_postun_with_restart ninfod.service

%files
%doc RELNOTES README.bonding
%{_unitdir}/rdisc.service
%attr(0755,root,root) %caps(cap_net_raw=ep) %{_sbindir}/clockdiff
%attr(0755,root,root) %caps(cap_net_raw=ep) %{_sbindir}/arping
%attr(0755,root,root) %caps(cap_net_raw=ep cap_net_admin=ep) %{_bindir}/ping
%{_sbindir}/ifenslave
%{_sbindir}/rdisc
%attr(0755,root,root) %caps(cap_net_raw=ep cap_net_admin=ep) %{_bindir}/ping6
%{_bindir}/tracepath
%{_bindir}/tracepath6
%{_sbindir}/ping6
%{_sbindir}/tracepath
%{_sbindir}/tracepath6
%attr(644,root,root) %{_mandir}/man8/clockdiff.8.gz
%attr(644,root,root) %{_mandir}/man8/arping.8.gz
%attr(644,root,root) %{_mandir}/man8/ping.8.gz
%attr(644,root,root) %{_mandir}/man8/ping6.8.gz
%attr(644,root,root) %{_mandir}/man8/rdisc.8.gz
%attr(644,root,root) %{_mandir}/man8/tracepath.8.gz
%attr(644,root,root) %{_mandir}/man8/tracepath6.8.gz
%attr(644,root,root) %{_mandir}/man8/ifenslave.8.gz
%config(noreplace) %attr(0644,root,root) %{_sysconfdir}/sysconfig/rdisc

%files sysvinit
%{_sysconfdir}/rc.d/init.d/rdisc

%files ninfod
%attr(0755,root,root) %caps(cap_net_raw=ep) %{_sbindir}/ninfod
%{_unitdir}/ninfod.service
%attr(644,root,root) %{_mandir}/man8/ninfod.8.gz

%files fivextra
%{prefix}

%changelog
* Wed May 15 2013 baseuser@ibm.com
- Base-8.x spec file
