Summary: A utility for setting up encrypted disks
Name: cryptsetup
Version: 1.6.1
%define base_release .4
Release: 1%{?dist}%{?base_release}
# Base: exclude cross arches for this package
ExcludeArch: %{?cross_arches}
License: GPLv2+ and LGPLv2+
Group: Applications/System
URL: http://cryptsetup.googlecode.com/
BuildRequires: libgcrypt-devel, popt-devel, device-mapper-devel
BuildRequires: libgpg-error-devel, libuuid-devel, libsepol-devel
BuildRequires: libselinux-devel, python-devel, libpwquality-devel
BuildRequires: fipscheck-devel >= 1.3.0
Provides: cryptsetup-luks = %{version}-%{release}
Obsoletes: cryptsetup-luks < 1.4.0
Requires: cryptsetup-libs = %{version}-%{release}
Requires: fipscheck-lib%{_isa} >= 1.3.0
Requires: libpwquality >= 1.2.0

%define upstream_version %{version}
Source0: http://cryptsetup.googlecode.com/files/cryptsetup-%{upstream_version}.tar.bz2
Source999: fivextra.tar.bz2

%if 0%{?fedora} >= 19 || 0%{?rhel} >= 7 || 0%{?base} >= 19
%define configure_cipher --enable-gcrypt-pbkdf2
%else
%define configure_cipher --with-luks1-cipher=aes --with-luks1-mode=cbc-essiv:sha256 --with-luks1-keybits=256
%endif

%description
The cryptsetup package contains a utility for setting up
disk encryption using dm-crypt kernel module.

%package devel
Group: Development/Libraries
Requires: %{name} = %{version}-%{release}
Requires: libgcrypt-devel > 1.1.42, device-mapper-devel, libuuid-devel
Requires: pkgconfig
Summary: Headers and libraries for using encrypted file systems
Provides: cryptsetup-luks-devel = %{version}-%{release}
Obsoletes: cryptsetup-luks-devel < 1.4.0

%description devel
The cryptsetup-devel package contains libraries and header files
used for writing code that makes use of disk encryption.

%package libs
Group: System Environment/Libraries
Summary: Cryptsetup shared library
Provides: cryptsetup-luks-libs = %{version}-%{release}
Obsoletes: cryptsetup-luks-libs < 1.4.0
Requires: fipscheck-lib%{_isa} >= 1.3.0
# Need support for empty password in gcrypt PBKDF2
%if 0%{?fedora} >= 19 || 0%{?rhel} >= 7 || 0%{?base} >= 19
Requires: libgcrypt >= 1.5.0-9
%endif

%description libs
This package contains the cryptsetup shared library, libcryptsetup.

%package -n veritysetup
Group: Applications/System
Summary: A utility for setting up dm-verity volumes
Requires: cryptsetup-libs = %{version}-%{release}

%description -n veritysetup
The veritysetup package contains a utility for setting up
disk verification using dm-verity kernel module.

%package reencrypt
Group: Applications/System
Summary: A utility for offline reencryption of LUKS encrypted disks.
Requires: cryptsetup-libs = %{version}-%{release}

%description reencrypt
This package contains cryptsetup-reencrypt utility which
can be used for offline reencryption of disk in situ.

%package python
Group: System Environment/Libraries
Summary: Python bindings for libcryptsetup
Requires: %{name}-libs = %{version}-%{release}
Provides: python-cryptsetup = %{version}-%{release}
Obsoletes: python-cryptsetup < 1.4.0

%description python
This package provides Python bindings for libcryptsetup, a library
for setting up disk encryption using dm-crypt kernel module.

%package fivextra
Summary: FIV Tests for %{name}
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains the testcases built from the package for %{name}

%prep
%setup -q -n cryptsetup-%{upstream_version} -a 999
chmod -x python/pycryptsetup-test.py
chmod -x misc/dracut_90reencrypt/*

%build
%configure --enable-python --enable-fips --enable-cryptsetup-reencrypt --enable-pwquality %{?configure_cipher}
# remove rpath
sed -i 's|^hardcode_libdir_flag_spec=.*|hardcode_libdir_flag_spec=""|g' libtool
sed -i 's|^runpath_var=LD_RUN_PATH|runpath_var=DIE_RPATH_DIE|g' libtool
make %{?_smp_mflags}

pushd tests
make api-test differ
popd

%install
# Generate HMAC checksums (FIPS)
%define __spec_install_post \
  %{?__debug_package:%{__debug_install_post}} \
  %{__arch_install_post} \
  %{__os_install_post} \
  %{?__base_source:%{base_install_post}} \
  fipshmac -d %{buildroot}/%{_libdir}/fipscheck %{buildroot}/%{_sbindir}/cryptsetup \
  fipshmac -d %{buildroot}/%{_libdir}/fipscheck %{buildroot}/%{_libdir}/libcryptsetup.so.* \
%{nil}

make install DESTDIR=%{buildroot}
rm -rf %{buildroot}/%{_libdir}/*.la
install -d %{buildroot}/%{_libdir}/fipscheck
%find_lang cryptsetup

# Steps to package the cryptsetup-luks tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

for dir in $(find tests -type d )
do
  install -d $RPM_BUILD_ROOT%{fivdir}/%{name}/$dir
  install  $(find $dir/* -type d -prune -o -print) $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir  || true
done

find $RPM_BUILD_ROOT%{fivdir}/%{name}/ -mindepth 2 -name .deps -o -name .libs -o -name *.c \
  -o -name '*.o' -o -name 'Makefile*' | xargs rm -rf

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%post -n cryptsetup-libs -p /sbin/ldconfig

%postun -n cryptsetup-libs -p /sbin/ldconfig

%files
%doc COPYING AUTHORS FAQ docs/*ReleaseNotes
%{_mandir}/man8/cryptsetup.8.gz
%{_sbindir}/cryptsetup
%{_libdir}/fipscheck/cryptsetup.hmac

%files -n veritysetup
%doc COPYING
%{_mandir}/man8/veritysetup.8.gz
%{_sbindir}/veritysetup

%files reencrypt
%doc COPYING misc/dracut_90reencrypt
%{_mandir}/man8/cryptsetup-reencrypt.8.gz
%{_sbindir}/cryptsetup-reencrypt

%files devel
%doc docs/examples/*
%{_includedir}/libcryptsetup.h
%{_libdir}/libcryptsetup.so
%{_libdir}/pkgconfig/libcryptsetup.pc

%files libs -f cryptsetup.lang
%doc COPYING COPYING.LGPL
%{_libdir}/libcryptsetup.so.*
%{_libdir}/fipscheck/libcryptsetup.so.*.hmac

%files python
%doc COPYING.LGPL python/pycryptsetup-test.py
%exclude %{python_sitearch}/pycryptsetup.la
%{python_sitearch}/pycryptsetup.so

%files fivextra
%{prefix}

%clean

%changelog
* Thu Jun 20 2013 baseuser@ibm.com
- Base-8.x spec file
