Summary: Tracks and displays system calls associated with a running process
Name: strace
Version: 4.8
%define base_release .3
Release: 1%{?dist}%{?base_release}
License: BSD
Group: Development/Debuggers
URL: http://sourceforge.net/projects/strace/
Source: http://downloads.sourceforge.net/strace/%{name}-%{version}.tar.xz
Source999: fivextra.tar.bz2
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

BuildRequires: libacl-devel, libaio-devel, time

%define strace64_arches ppc64 sparc64

%description
The strace program intercepts and records the system calls called and
received by a running process.  Strace can print a record of each
system call, its arguments and its return value.  Strace is useful for
diagnosing problems and debugging, as well as for instructional
purposes.

Install strace if you need a tool to track the system calls made and
received by a process.

%ifarch %{strace64_arches}
%package -n strace64
Summary: Tracks and displays system calls associated with a running process.
Group: Development/Debuggers

%description -n strace64
The strace program intercepts and records the system calls called and
received by a running process.  Strace can print a record of each
system call, its arguments and its return value.  Strace is useful for
diagnosing problems and debugging, as well as for instructional
purposes.

Install strace if you need a tool to track the system calls made and
received by a process.

This package provides the `strace64' program to trace 64-bit processes.
The `strace' program in the `strace' package is for 32-bit processes.
%endif

%package fivextra
Summary: FIV Tests for %{name}
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains the testcases built from the package for %{name}

%prep
%setup -q -a 999

%build
%configure
make %{?_smp_mflags}

pushd fivextra
make all
popd

%install
rm -rf %{buildroot}
make DESTDIR=%{buildroot} install

# remove unpackaged files from the buildroot
rm -f %{buildroot}%{_bindir}/strace-graph

%define copy64 ln
%if 0%{?rhel} || 0%{?base}
%if 0%{?rhel} < 6 || 0%{?base} < 19
%endif
%define copy64 cp -p
%endif

%ifarch %{strace64_arches}
%{copy64} %{buildroot}%{_bindir}/strace %{buildroot}%{_bindir}/strace64
%endif

# Steps to package the strace tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

find $RPM_BUILD_ROOT/%{fivdir}/%{name} \
-name '*.c' -o -name '*.h' | xargs rm -rf

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%check
make check

%clean
rm -rf %{buildroot}

%files
%defattr(-,root,root)
%doc CREDITS ChangeLog ChangeLog-CVS COPYING NEWS README
%{_bindir}/strace
%{_bindir}/strace-log-merge
%{_mandir}/man1/*

%ifarch %{strace64_arches}
%files -n strace64
%defattr(-,root,root)
%{_bindir}/strace64
%endif

%files fivextra
%{prefix}

%changelog
* Mon Jun 10 2013 baseuser@ibm.com
- Base-8.x spec file
