%bcond_with largefile
Summary: A GNU set of database routines which use extensible hashing
Name: gdbm
Version: 1.10
%define base_release .2
Release: 6%{?dist}%{?base_release}
Source: http://ftp.gnu.org/gnu/gdbm/gdbm-%{version}.tar.gz
Source999: fivextra.tar.bz2
# Prevent gdbm from storing uninitialized memory content
# to database files.
# The change allows Valgrind users to debug their packages without
# dealing with gdbm-related noise. It also improves security, as 
# the uninitialized memory might contain sensitive informations 
# from other applications. The patch is taken from Debian.
# See https://bugzilla.redhat.com/show_bug.cgi?id=4457
# See http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=208927
Patch0: gdbm-1.10-zeroheaders.patch
Patch1: gdbm-1.10-fedora.patch
Patch2: gdbm-sa1.patch
Patch3: gdbm-aarch64.patch
License: GPLv3+
URL: http://www.gnu.org/software/gdbm/
Group: System Environment/Libraries
BuildRequires: libtool
BuildRequires: gettext

%description
Gdbm is a GNU database indexing library, including routines which use
extensible hashing.  Gdbm works in a similar way to standard UNIX dbm
routines.  Gdbm is useful for developers who write C applications and
need access to a simple and efficient database or who are building C
applications which will use such a database.

If you're a C developer and your programs need access to simple
database routines, you should install gdbm.  You'll also need to
install gdbm-devel.

%package devel
Summary: Development libraries and header files for the gdbm library
Group: Development/Libraries
Requires: %{name} = %{version}-%{release}
Requires(post): info
Requires(preun): info

%description devel
Gdbm-devel contains the development libraries and header files for
gdbm, the GNU database system.  These libraries and header files are
necessary if you plan to do development using the gdbm database.

Install gdbm-devel if you are developing C programs which will use the
gdbm database library.  You'll also need to install the gdbm package.

%package fivextra
Summary: Test for %{name} package
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains testcases for %{name}

%prep
%setup -q -a 999
%patch0 -p1 -b .zeroheaders
%patch1 -p1 -b .fedora
%patch2 -p1 -b .sa1
%patch3 -p1 -b .aarch64

%build
%configure \
    --disable-static \
%{!?with_largefile: --disable-largefile} \
    --enable-libgdbm-compat

make %{?_smp_mflags}

pushd fivextra
make all
popd

%install
make DESTDIR=$RPM_BUILD_ROOT install

%find_lang %{name}

# create symlinks for compatibility
mkdir -p $RPM_BUILD_ROOT/%{_includedir}/gdbm 
ln -sf ../gdbm.h $RPM_BUILD_ROOT/%{_includedir}/gdbm/gdbm.h
ln -sf ../ndbm.h $RPM_BUILD_ROOT/%{_includedir}/gdbm/ndbm.h
ln -sf ../dbm.h $RPM_BUILD_ROOT/%{_includedir}/gdbm/dbm.h

rm -f $RPM_BUILD_ROOT/%{_libdir}/libgdbm.la
rm -f $RPM_BUILD_ROOT/%{_libdir}/libgdbm_compat.la

rm -f $RPM_BUILD_ROOT/%{_infodir}/dir

# Steps to package the gdbm tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%check
make check

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%post devel
/sbin/install-info %{_infodir}/gdbm.info.gz %{_infodir}/dir \
      --entry="* gdbm: (gdbm).                   The GNU Database." || :

%preun devel
if [ $1 = 0 ]; then
    /sbin/install-info --delete %{_infodir}/gdbm.info.gz %{_infodir}/dir \
        --entry="* gdbm: (gdbm).                   The GNU Database." || :
fi

%files -f %{name}.lang
%doc COPYING NEWS README THANKS AUTHORS NOTE-WARNING 
%{_libdir}/libgdbm.so.4*
%{_libdir}/libgdbm_compat.so.4*
%{_bindir}/testgdbm

%files devel
%{_libdir}/libgdbm.so
%{_libdir}/libgdbm_compat.so
%{_includedir}/*
%{_infodir}/*.info*
%{_mandir}/man3/* 

%files fivextra
%{prefix}

%changelog
* Tue Jun 11 2013 baseuser@ibm.com
- Base-8.x spec file
