Summary: A utility which lists open files on a Linux/UNIX system
Name: lsof
Version: 4.87
%define base_release .5
Release: 2%{?dist}%{?base_release}
# Sendmail .. lib/snpf.c
# LGPLv2+  .. lib/regex.c, regex.h
License: zlib and Sendmail and LGPLv2+
Group: Development/Debuggers

# lsof contains licensed code that we cannot ship.  Therefore we use
# upstream2downstream.sh script to remove the code before shipping it.
#
# The script you can found in SCM or download from:
# http://pkgs.fedoraproject.org/gitweb/?p=lsof.git;a=blob_plain;f=upstream2downstream.sh

%global lsofrh lsof_%{version}-rh
URL: http://people.freebsd.org/~abe/
Source0: %{lsofrh}.tar.xz
Source1: upstream2downstream.sh
Source999: fivextra.tar.bz2
Patch97308:	bug97308-frobisher_LTsock_and_LTunix_tests_are_failing_to_find_socket.patch 

BuildRequires: libselinux-devel

%description
Lsof stands for LiSt Open Files, and it does just that: it lists
information about files that are open by the processes running on a
UNIX system.

%package fivextra
Summary: Test for %{name} package
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains testcases for %{name}

%prep
%setup -q -n %{lsofrh} -a 999
%patch97308 -p1

%build
./Configure -n linux
make CC=%{__cc} DEBUG="$RPM_OPT_FLAGS -fno-strict-aliasing" %{?_smp_mflags}

pushd fivextra
make CC=%{__cc} all
popd

%install
mkdir -p ${RPM_BUILD_ROOT}%{_sbindir}
install -p -m 0755 lsof ${RPM_BUILD_ROOT}%{_sbindir}
mkdir -p ${RPM_BUILD_ROOT}%{_mandir}/man8
install -p -m 0644 lsof.8 ${RPM_BUILD_ROOT}%{_mandir}/man8

# Steps to package the lsof tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

find $RPM_BUILD_ROOT/%{fivdir}/%{name} -mindepth 2 \
-name '*.c' -o -name '*.h' -o -name '*.o' -o -name 'Makefile*' | xargs rm -rf


%files
%doc 00* README.lsof_*
%{_sbindir}/lsof
%{_mandir}/man*/*

%files fivextra
%{prefix}

%changelog
* Mon May 13 2013 baseuser@ibm.com
- Base-8.x spec file
