Summary: Tracks runtime library calls from dynamically linked executables
Name: ltrace
Version: 0.7.2
%define base_release .3
Release: 5%{?dist}%{?base_release}
URL: http://ltrace.alioth.debian.org/
License: GPLv2+
Group: Development/Debuggers

BuildRequires: elfutils-libelf-devel dejagnu
BuildRequires: libselinux-devel
BuildRequires: autoconf automake libtool

# Note: this URL needs to be updated for each release, as the file
# number changes for each file.  Full list of released files is at:
#  https://alioth.debian.org/frs/?group_id=30892
Source: http://alioth.debian.org/frs/download.php/3848/ltrace-0.7.2.tar.bz2
Source999: fivextra.tar.bz2

# Many small fixes brought from master branch.
Patch0: ltrace-0.7.2-bits.patch

# Upstream patch which introduces support for ARM architecture.
Patch1: ltrace-0.7.2-arm.patch

# Work around a recently-added GCC warning.
Patch2: ltrace-0.7.2-unused-typedef.patch

# s390 set_instruction_pointer: Set highest bit in 31-bit tracer
Patch3: ltrace-0.7.2-s390-set_instruction_pointer.patch

%description
Ltrace is a debugging program which runs a specified command until the
command exits.  While the command is executing, ltrace intercepts and
records both the dynamic library calls called by the executed process
and the signals received by the executed process.  Ltrace can also
intercept and print system calls executed by the process.

You should install ltrace if you need a sysadmin tool for tracking the
execution of processes.

%package fivextra
Summary: Test for %{name} package
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains testcases for %{name}

%prep
%setup -q -n %{name}-%{version} -a 999
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1

%build
autoreconf -i
%configure
make %{?_smp_mflags}

pushd fivextra
make all
popd

%install
make DESTDIR=$RPM_BUILD_ROOT bindir=%{_bindir} docdir=%{_docdir}/ltrace-%{version}/ install

# Steps to package the ltrace tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

find $RPM_BUILD_ROOT/%{fivdir}/%{name} \
-name '*.c' | xargs rm -rf

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

# The testsuite is useful for development in real world, but fails in
# koji for some reason.  Disable it, but have it handy.
%check
echo ====================TESTING=========================
make check ||:
echo ====================TESTING END=====================

%files
%defattr(-,root,root)
%doc COPYING README NEWS
%{_bindir}/ltrace
%{_mandir}/man1/ltrace.1*
%{_mandir}/man5/ltrace.conf.5*
%config(noreplace) %{_sysconfdir}/ltrace.conf

%files fivextra
%{prefix}

%changelog
* Fri May 31 2013 baseuser@ibm.com
- Base-8.x spec file
