%global systemctl_bin /usr/bin/systemctl

Name: numad
Version: 0.5
%define base_release .4
Release: 10.20121130git%{?dist}%{?base_release}
Summary: NUMA user daemon

License: LGPLv2
Group: System Environment/Daemons
URL: http://git.fedorahosted.org/git/?p=numad.git
# The source for this package was pulled from upstream's vcs.  Use the
# following commands to generate the tarball:
#   git clone git://git.fedorahosted.org/numad.git numad-0.5git
#   tar --exclude-vcs -cJf numad-0.5git.tar.xz numad-0.5git/
Source0: %{name}-%{version}git.tar.xz
Source999: fivextra.tar.bz2
Patch0: numad-0.5git-pthread.patch

Requires: systemd-units, initscripts
Requires(post): systemd-units, initscripts
Requires(preun): systemd-units, initscripts
BuildRequires: systemd-units

ExcludeArch: s390 s390x %{arm} mips64 ppca2 ppc476 ppcnf

%description
Numad, a daemon for NUMA (Non-Uniform Memory Architecture) systems,
that monitors NUMA characteristics and manages placement of processes
and memory to minimize memory latency and thus provide optimum performance.

%package fivextra
Summary: Test for %{name} package
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains testcases for %{name}

%prep
%setup -q -n %{name}-%{version}git -a 999
%patch0 -p0

%build
make CFLAGS="-std=gnu99 -g" LDFLAGS="-lpthread -lrt"

pushd fivextra
make all
popd

%install
mkdir -p %{buildroot}%{_bindir}
mkdir -p %{buildroot}%{_sysconfdir}
mkdir -p %{buildroot}%{_unitdir}
mkdir -p %{buildroot}%{_mandir}/man8/
install -p -m 644 numad.conf %{buildroot}%{_sysconfdir}/
install -p -m 644 numad.service %{buildroot}%{_unitdir}/
make install prefix=%{buildroot}/usr

# Steps to package the numad tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%files
%{_bindir}/numad
%{_unitdir}/numad.service
%config(noreplace) %{_sysconfdir}/numad.conf
%doc %{_mandir}/man8/numad.8.gz

%files fivextra
%defattr(-,root,root)
%{prefix}

%post
%systemd_post numad.service

%preun
%systemd_preun numad.service

%postun
%systemd_postun numad.service

%changelog
* Mon Jun 03 2013 baseuser@ibm.com
- Base-8.x spec file
