%if ! (0%{?fedora} > 12 || 0%{?rhel} > 5)
%{!?python_sitelib: %global python_sitelib %(%{__python} -c "from distutils.sysconfig import get_python_lib; print(get_python_lib())")}
%{!?python_sitearch: %global python_sitearch %(%{__python} -c "from distutils.sysconfig import get_python_lib; print(get_python_lib(1))")}
%endif

Summary:        PAM bindings for Python
Name:           PyPAM
Version:        0.5.0
%define base_release .2
Release:        17%{?dist}%{?base_release}
# Base: exclude cross arches for this package
ExcludeArch: mips64 ppca2 ppc476 ppcnf
# Note that the upstream site is dead.
Source0:        http://www.pangalactic.org/PyPAM/%{name}-%{version}.tar.gz
Url:            http://www.pangalactic.org/PyPAM
Patch0:         PyPAM-dlopen.patch
Patch1:         PyPAM-0.5.0-dealloc.patch
Patch2:         PyPAM-0.5.0-nofree.patch
Patch3:         PyPAM-0.5.0-memory-errors.patch
Patch4:         PyPAM-0.5.0-return-value.patch
License:        LGPLv2
Group:          Development/Libraries
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildRequires:  python2-devel pam-devel
Requires:       python
%filter_provides_in %{python_sitearch}/PAMmodule.so$
%filter_setup

%description
PAM (Pluggable Authentication Module) bindings for Python.

%prep
%setup -q
%patch0 -p1 -b .dlopen
%patch1 -p1 -b .dealloc
%patch2 -p1 -b .nofree
%patch3 -p1 -b .memory
%patch4 -p1 -b .retval
# remove prebuild rpm and others binaries
rm -rf build dist

%build
CFLAGS="$RPM_OPT_FLAGS -fno-strict-aliasing" %{__python} setup.py build

%install
rm -rf $RPM_BUILD_ROOT
%{__python} setup.py install --root=$RPM_BUILD_ROOT
# Make sure we don't include binary files in the docs
chmod 644 examples/pamtest.py
rm -f examples/pamexample

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-, root, root, -)
%{python_sitearch}/PAMmodule.so
%{python_sitearch}/*.egg-info
%doc AUTHORS NEWS README ChangeLog COPYING INSTALL 
%doc examples 

%changelog
* Fri Jul 12 2013 baseuser@ibm.com
- Base-8.x spec file
