%define glib_ver 2.16

Name:		json-glib
Version:	0.16.0
%define base_release .3
Release:	1%{?dist}%{?base_release}
# Base: exclude cross arches for this package
ExcludeArch: %{cross_arches}
Summary:	Library for JavaScript Object Notation format

Group:		System Environment/Libraries
License:	LGPLv2+
URL:		http://live.gnome.org/JsonGlib
#VCS:		git:git://git.gnome.org/json-glib
Source0:	http://download.gnome.org/sources/%{name}/0.16/%{name}-%{version}.tar.xz

BuildRequires:	glib2-devel >= %{glib_ver}
BuildRequires:	gobject-introspection-devel


%description
%{name} is a library providing serialization and deserialization support
for the JavaScript Object Notation (JSON) format.


%package devel
Summary:	Development files for %{name}
Group:		Development/Libraries
Requires:	%{name} = %{version}-%{release}
Requires:	glib2-devel >= %{glib_ver}
Requires:	pkgconfig


%description devel
The %{name}-devel package contains libraries and header files for
developing applications that use %{name}.


%prep
%setup -q -n %{name}-%{version}


%build
%configure --enable-static=no
make %{?_smp_mflags} V=1


%install
make install DESTDIR=$RPM_BUILD_ROOT
find $RPM_BUILD_ROOT -name '*.la' -exec rm -f {} ';'

# Copy the files from the tarball to avoid the IDs generated by gtk-doc being
# different on different builds
mkdir -p $RPM_BUILD_ROOT%{_datadir}/gtk-doc/html/%{name}/
cp -a doc/reference/html/* $RPM_BUILD_ROOT%{_datadir}/gtk-doc/html/%{name}/

%find_lang json-glib-1.0

%post -p /sbin/ldconfig


%postun -p /sbin/ldconfig


%files -f json-glib-1.0.lang
%doc COPYING NEWS
%{_libdir}/lib%{name}*.so.*
%{_libdir}/girepository-1.0/Json-1.0.typelib

%files devel
%{_libdir}/lib%{name}*.so
%{_libdir}/pkgconfig/%{name}-1.0.pc
%{_includedir}/%{name}-1.0/
%{_datadir}/gtk-doc/
%{_datadir}/gir-1.0/Json-1.0.gir


%changelog
* Wed Aug 14 2013 baseuser@ibm.com
- Base-8.x spec file
