Summary: An API for Run-time Code Generation
License: LGPLv2+
Name: dyninst
Group: Development/Libraries
%define base_release .2
Release: 1%{?dist}%{?base_release}
URL: http://www.dyninst.org
Version: 8.1.1
Exclusiveos: linux
#Right now dyninst does not know about the following architectures
ExcludeArch: s390 s390x %{arm} ppcnf ppc476 mips64

# The source for this package was pulled from upstream's vcs.  Use the
# following commands to generate the tarball:
#  git clone http://git.dyninst.org/dyninst.git; cd dyninst
#  git archive --format=tar.gz --prefix=dyninst/ v8.1.1 > dyninst-8.1.1.tar.gz
#  git clone http://git.dyninst.org/docs.git; cd docs
#  git archive --format=tar.gz v8.1.1 > dyninst-docs-8.1.1.tar.gz
# Verify the commit ids with:
#  gunzip -c dyninst-8.1.1.tar.gz | git get-tar-commit-id
#  gunzip -c dyninst-docs-8.1.1.tar.gz | git get-tar-commit-id
Source0: %{name}-%{version}.tar.gz
Source1: %{name}-docs-%{version}.tar.gz
Patch1: dyninst-rpm-build-flags.patch
Patch2: dyninst-install-testsuite.patch
Patch3: dyninst-relative-symlinks.patch
BuildRequires: libdwarf-devel >= 20111030
BuildRequires: elfutils-libelf-devel
BuildRequires: boost-devel

# Extra requires just for the testsuite
BuildRequires: gcc-gfortran glibc-static libstdc++-static nasm

# Testsuite files should not provide/require anything
%{?filter_setup:
%filter_provides_in %{_libdir}/dyninst/testsuite/
%filter_requires_in %{_libdir}/dyninst/testsuite/
%filter_setup
}

%description

Dyninst is an Application Program Interface (API) to permit the insertion of
code into a running program. The API also permits changing or removing
subroutine calls from the application program. Run-time code changes are
useful to support a variety of applications including debugging, performance
monitoring, and to support composing applications out of existing packages.
The goal of this API is to provide a machine independent interface to permit
the creation of tools and applications that use run-time code patching.

%package doc
Summary: Documentation for using the Dyninst API
Group: Documentation
%description doc
dyninst-doc contains API documentation for the Dyninst libraries.

%package devel
Summary: Header files for the compiling programs with Dyninst
Group: Development/System
Requires: dyninst = %{version}-%{release}
Requires: boost-devel
%description devel
dyninst-devel includes the C header files that specify the Dyninst user-space
libraries and interfaces. This is required for rebuilding any program
that uses Dyninst.

%package static
Summary: Static libraries for the compiling programs with Dyninst
Group: Development/System
Requires: dyninst-devel = %{version}-%{release}
%description static
dyninst-static includes the static versions of the library files for
the dyninst user-space libraries and interfaces.

%package testsuite
Summary: Programs for testing Dyninst
Group: Development/System
Requires: dyninst-devel = %{version}-%{release}
%description testsuite
dyninst-testsuite includes the test harness and target programs for
making sure that dyninst works properly.

%prep
%setup -q -n %{name}-%{version} -c
%setup -q -T -D -a 1

pushd dyninst
%patch1 -p1 -b .buildflags
%patch2 -p1 -b .testsuite
%patch3 -p1 -b .symlinks
popd

%build

cd dyninst

%configure --includedir=%{_includedir}/dyninst --libdir=%{_libdir}/dyninst
make %{?_smp_mflags} VERBOSE_COMPILATION=1

%install

cd dyninst
make DESTDIR=%{buildroot} install

mkdir -p %{buildroot}/etc/ld.so.conf.d
echo "%{_libdir}/dyninst" > %{buildroot}/etc/ld.so.conf.d/%{name}-%{_arch}.conf

# Ugly hack to fix permissions
chmod 644 %{buildroot}%{_includedir}/dyninst/*
chmod 644 %{buildroot}%{_libdir}/dyninst/*.a

# Uglier hack to mask testsuite files from debuginfo extraction.  Running the
# testsuite requires debuginfo, so extraction is useless.  However, debuginfo
# extraction is still nice for the main libraries, so we don't want to disable
# it package-wide.  The permissions are restored by attr(755,-,-) in files.
chmod 644 %{buildroot}%{_libdir}/dyninst/testsuite/*

%post -p /sbin/ldconfig
%postun -p /sbin/ldconfig

%files
%defattr(-,root,root,-)

%dir %{_libdir}/dyninst
%{_libdir}/dyninst/*.so.*

%doc dyninst/COPYRIGHT
%doc dyninst/LGPL

%config(noreplace) /etc/ld.so.conf.d/*

%files doc
%defattr(-,root,root,-)
%doc dynC_API.pdf
%doc DyninstAPI.pdf
%doc InstructionAPI.pdf
%doc ParseAPI.pdf
%doc PatchAPI.pdf
%doc ProcControlAPI.pdf
%doc StackwalkerAPI.pdf
%doc SymtabAPI.pdf

%files devel
%defattr(-,root,root,-)
%{_includedir}/dyninst
%{_libdir}/dyninst/*.so

%files static
%defattr(-,root,root,-)
%{_libdir}/dyninst/*.a

%files testsuite
%defattr(-,root,root,-)
%{_bindir}/parseThat
%dir %{_libdir}/dyninst/testsuite/
# Restore the permissions that were hacked out above, during install.
%attr(755,root,root) %{_libdir}/dyninst/testsuite/*

%changelog
* Fri Jun 21 2013 baseuser@ibm.com
- Base-8.x spec file
