Summary: Python wrapper module around the OpenSSL library
Name: pyOpenSSL
Version: 0.13
%define base_release .2
Release: 5%{?dist}%{?base_release}
# Base: exclude cross arches for this package
ExcludeArch: mips64 ppca2 ppc476 ppcnf
Source0: http://pypi.python.org/packages/source/p/pyOpenSSL/%{name}-%{version}.tar.gz
Source999: fivextra.tar.bz2
# Fedora specific patches

Patch2: pyOpenSSL-elinks.patch
Patch3: pyOpenSSL-nopdfout.patch
License: ASL 2.0
Group: Development/Libraries
Url: http://pyopenssl.sourceforge.net/
BuildRequires: elinks openssl-devel python-devel
BuildRequires: tetex-dvips tetex-latex latex2html

# we don't want to provide private python extension libs
%{?filter_setup:
%filter_provides_in %{python_sitearch}/.*\.so$ 
%filter_requires_in %{_datadir}/doc/ 
%filter_setup
}

%description
High-level wrapper around a subset of the OpenSSL library, includes among others
 * SSL.Connection objects, wrapping the methods of Python's portable
   sockets
 * Callbacks written in Python
 * Extensive error-handling mechanism, mirroring OpenSSL's error codes

%Package fivextra
Summary: FIV Tests for %{name}
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains the testcases built from the package for %{name} 

%prep
%setup -q -n %{name}-%{version} -a 999
%patch2 -p1 -b .elinks
%patch3 -p1 -b .nopdfout

# Fix permissions for debuginfo package
%{__chmod} -x OpenSSL/ssl/connection.c

%build
CFLAGS="%{optflags} -fno-strict-aliasing" %{__python} setup.py build
%{__make} -C doc ps
%{__make} -C doc text html
find doc/ -name pyOpenSSL.\*

%install
%{__python} setup.py install --skip-build --root %{buildroot}

# Steps to package the pyOpenSSL tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

for dir in $(find test -type d )
do
  install -d $RPM_BUILD_ROOT%{fivdir}/%{name}/$dir
  install  $(find $dir/* -type d -prune -o -print) $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%files
%defattr(-,root,root,-)
%doc README doc/pyOpenSSL.* doc/html
%{python_sitearch}/OpenSSL/
%{python_sitearch}/%{name}*.egg-info

%files fivextra
%{prefix}

%changelog
* Fri Dec 13 2013 baseuser@ibm.com
- Base-8.x spec file
