%if 0%{?fedora} > 12 && ! 0%{?base:1}
%global with_python3 1
%else
%{!?python_sitelib: %global python_sitelib %(%{__python} -c "from distutils.sysconfig import get_python_lib; print (get_python_lib())")}
%endif

Name:           pyparsing
Version:        1.5.6
%define base_release .2
Release:        8%{?dist}%{?base_release}
# Base: exclude cross arches for this package
ExcludeArch: mips64 ppca2 ppc476 ppcnf
Summary:        An object-oriented approach to text processing
Group:          Development/Libraries
License:        MIT
URL:            http://pyparsing.wikispaces.com/
Source0:        http://downloads.sourceforge.net/pyparsing/pyparsing-%{version}.tar.gz
Patch0:         pyparsing-1.5.6-traceback-typo.patch
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildArch:      noarch

BuildRequires:  python-devel
BuildRequires:  dos2unix
BuildRequires:  glibc-common

%if 0%{?with_python3}
BuildRequires: python3-devel
%endif # if with_python3

%description
pyparsing is a module that can be used to easily and directly configure syntax
definitions for any number of text parsing applications.

%package doc
Summary:        Documentation for pyparsing
Group:          Development/Libraries

%description doc
The package contains documentation for pyparsing.

%if 0%{?with_python3}
%package -n python3-pyparsing
Summary:        An object-oriented approach to text processing (Python 3 version)
Group:          Development/Libraries

%description -n python3-pyparsing
pyparsing is a module that can be used to easily and directly configure syntax
definitions for any number of text parsing applications.

This is the Python 3 version.
%endif # if with_python3

%prep
%setup -q
dos2unix -k pyparsing_py3.py
%patch0
mv docs/pyparsingClassDiagram.PNG docs/pyparsingClassDiagram.png
rm docs/pyparsingClassDiagram.JPG
dos2unix -k CHANGES LICENSE
dos2unix -k docs/examples/*
dos2unix -k docs/htmldoc/epydoc*
for f in CHANGES docs/examples/{holaMundo.py,mozillaCalendarParser.py} ; do
    mv $f $f.iso88591
    iconv -f ISO-8859-1 -t UTF-8 -o $f $f.iso88591
    touch -r $f.iso88591 $f
    rm -f $f.iso88591
done

%if 0%{?with_python3}
rm -rf %{py3dir}
cp -a . %{py3dir}
%endif # with_python3

%build
%{__python} setup.py build

%if 0%{?with_python3}
pushd %{py3dir}
%{__python3} setup.py build
popd
%endif # with_python3

%install
rm -rf %{buildroot}

# Install python 3 first, so that python 2 gets precedence:
%if 0%{?with_python3}
pushd %{py3dir}
%{__python3} setup.py install -O1 --skip-build --root %{buildroot}
popd
%endif # with_python3

%{__python} setup.py install -O1 --skip-build --root %{buildroot}

%clean
rm -rf %{buildroot}

%files
%defattr(-,root,root,-)
%doc CHANGES README LICENSE
%if 0%{?fedora} >= 9 || 0%{?rhel} >= 6 || 0%{?base} > 18
%{python_sitelib}/pyparsing*egg-info
%endif
%{python_sitelib}/pyparsing.py*

%if 0%{?with_python3}
%files -n python3-pyparsing
%defattr(-,root,root,-)
%doc CHANGES README LICENSE
%{python3_sitelib}/pyparsing*egg-info
%{python3_sitelib}/pyparsing.py*
%endif # with_python3
%if ( 0%{?fedora} >= 15 || 0%{?rhel} >= 7 ) && 0%{?with_python3}
%{python3_sitelib}/__pycache__/pyparsing*
%endif # pycache

%files doc
%defattr(-,root,root,-)
%doc CHANGES README LICENSE docs/*

%changelog
* Fri Dec 13 2013 baseuser@ibm.com
- Base-8.x spec file
