Name:           perl-URI
Version:        1.60
%define base_release .4
Release:        8%{?dist}%{?base_release}
Summary:        A Perl module implementing URI parsing and manipulation
Group:          Development/Libraries
License:        GPL+ or Artistic
URL:            http://search.cpan.org/dist/URI/
Source0:        http://www.cpan.org/authors/id/G/GA/GAAS/URI-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  perl(Carp)
BuildRequires:  perl(constant)
BuildRequires:  perl(Cwd)
BuildRequires:  perl(Data::Dumper)
BuildRequires:  perl(Encode)
BuildRequires:  perl(Exporter)
BuildRequires:  perl(ExtUtils::MakeMaker)
BuildRequires:  perl(File::Spec::Functions)
BuildRequires:  perl(MIME::Base64) >= 2
BuildRequires:  perl(Net::Domain)
BuildRequires:  perl(Storable)
BuildRequires:  perl(Test)
BuildRequires:  perl(Test::More)
# Business::ISBN -> Test::Pod -> Pod::Simple -> HTML::Entities (HTML::Parser) -> URI
%if 0%{!?perl_bootstrap:1}
BuildRequires:  perl(Business::ISBN)
%endif
Requires:       perl(:MODULE_COMPAT_%(eval "`perl -V:version`"; echo $version))
Requires:       perl(Business::ISBN)
Requires:       perl(Cwd)
Requires:       perl(Data::Dumper)
Requires:       perl(MIME::Base64) >= 2
Requires:       perl(Net::Domain)

%description
This module implements the URI class. Objects of this class represent
"Uniform Resource Identifier references" as specified in RFC 2396 (and
updated by RFC 2732).

%prep
%setup -q -n URI-%{version}
chmod -c 644 uri-test

%build
perl Makefile.PL INSTALLDIRS=perl
make %{?_smp_mflags}

%install
make pure_install DESTDIR=%{buildroot}
find %{buildroot} -type f -name .packlist -exec rm -f {} ';'
%{_fixperms} %{buildroot}

%check
make test

%files
%doc Changes README uri-test
%{perl_privlib}/URI.pm
%{perl_privlib}/URI/
%{_mandir}/man3/URI.3pm*
%{_mandir}/man3/URI::Escape.3pm*
%{_mandir}/man3/URI::Heuristic.3pm*
%{_mandir}/man3/URI::QueryParam.3pm*
%{_mandir}/man3/URI::Split.3pm*
%{_mandir}/man3/URI::URL.3pm*
%{_mandir}/man3/URI::WithBase.3pm*
%{_mandir}/man3/URI::_punycode.3pm*
%{_mandir}/man3/URI::data.3pm*
%{_mandir}/man3/URI::file.3pm*
%{_mandir}/man3/URI::ldap.3pm*

%changelog
* Thu Jun 27 2013 baseuser@ibm.com
- Base-8.x spec file
