%global _hardened_build 1

Name: nagios
Version: 3.5.1
%define base_release .2
Release: 1%{?dist}%{?base_release}
ExcludeArch: mips64 ppc476 ppcnf ppca2
Summary: Host/service/network monitoring program

Group: Applications/System
License: GPLv2
URL: http://www.nagios.org/
Source0: http://downloads.sourceforge.net/nagios/%{name}-%{version}.tar.gz
Source1: nagios.logrotate
Source2: nagios.htaccess
Source3: nagios.internet.cfg
Source4: nagios.htpasswd
Source5: nagios.upgrade_to_v3.ReadMe
Source6: nagios.upgrade_to_v3.sh
# PNG files from the old nagios-0010-Added-several-images-to-the-sample-config.patch
Source10: printer.png
Source11: router.png
Source12: switch.png

Patch1: nagios-0001-from-rpm.patch
Patch2: nagios-0002-SELinux-relabeling.patch
# Sent upstream
Patch3: nagios-0003-Fix-etc-init.d-nagios-status.patch
# Sent upstream
Patch4: nagios-0004-Fix-installation-of-httpd-conf.d-config-file.patch
Patch5: nagios-0005-Install-config-files-too.patch
Patch6: nagios-0006-Do-not-start-service-by-default.patch
# Sent upstream
Patch7: nagios-0007-The-init-script-should-return-2-in-case-of-unknown-c.patch
Patch8: nagios-0008-Fix-path-to-CGI-executables.patch
Patch9: nagios-0009-Fixed-path-to-passwd-file-in-Apache-s-config-file.patch
Patch10: nagios-0010-Added-several-images-to-the-sample-config-revb.patch
Patch11: nagios-0011-Fixed-strange-permissions.patch
Patch12: nagios-3.4.3-httpd-2.4-and-2.2.patch
Patch14: nagios-3.5.0-conf.d-configuration-directory.patch
Patch15: nagios-0012-add-aarch64-support.patch

BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

BuildRequires: gd-devel > 1.8, mailx, libjpeg-devel, libpng-devel
BuildRequires: perl(CPAN)
BuildRequires: perl(ExtUtils::MakeMaker)
BuildRequires: perl(ExtUtils::Embed)
BuildRequires: perl(Test::Harness)
# if 0%{?el6}%{?fedora}
# BuildRequires: perl(Test::HTML::Lint)
# endif
BuildRequires: perl(Test::More)
BuildRequires: perl(Test::Simple)


Requires: httpd
Requires: php
Requires: perl(:MODULE_COMPAT_%(eval "`%{__perl} -V:version`"; echo $version))
Requires: mailx
Requires(preun): initscripts, chkconfig
Requires(post): initscripts, chkconfig
Requires(postun): initscripts

Requires: nagios-common
Requires: user(nagios)
Requires(pre): user(nagios)
Requires: group(nagios)
Requires(pre): group(nagios)


Summary: Nagios monitors hosts and services and yells if somethings breaks
Summary(de): Nagios überwacht Dienste und Rechner und meldet Ihnen Ausfälle

%description
Nagios is a program that will monitor hosts and services on your
network.  It has the ability to send email or page alerts when a
problem arises and when a problem is resolved.  Nagios is written
in C and is designed to run under Linux (and some other *NIX
variants) as a background process, intermittently running checks
on various services that you specify.

The actual service checks are performed by separate "plugin" programs
which return the status of the checks to Nagios. The plugins are
available at http://sourceforge.net/projects/nagiosplug.

This package provides the core program, web interface, and documentation
files for Nagios. Development files are built as a separate package.

%description -l (de)
Nagios ist ein Programm zum Überwachen von Rechner und Diensten
in Ihrem Netzwerk. Wenn etwas ausfällt, kann es Sie per eMail
oder Pager benachrichtigen. Nagios ist in C geschrieben und
sollte auf allen Unix-Varianten (inklusive Linux :-) laufen. Es
läuft als Dämon und überwacht laufend alle konfigurierten
Dienste.

Nagios überprüft die Rechner und Dienste nicht selber, sondern
braucht dafür externe Programme. Viele dieser Programme finden
Sie im Paket nagios-plugins.

%package common
Group: Applications/System
Summary: Provides common directories, uid and gid among nagios-related packages
Requires(pre): shadow-utils
Requires(post): shadow-utils
Provides: user(nagios)
Provides: group(nagios)


%description common
Provides common directories, uid and gid among nagios-related packages.


%package devel
Group: Applications/System
Summary: Provides include files that Nagios-related applications may compile against
Requires: %{name} = %{version}-%{release}


%description devel
Nagios is a program that will monitor hosts and services on your
network. It has the ability to email or page you when a problem arises
and when a problem is resolved. Nagios is written in C and is
designed to run under Linux (and some other *NIX variants) as a
background process, intermittently running checks on various services
that you specify.

This package provides include files that Nagios-related applications
may compile against.


%prep
%setup -q -n %{name}
%patch1 -p1 -b .fedora
%patch2 -p1 -b .selinux_relabel
%patch3 -p1 -b .fix_status_retcode
%patch4 -p1 -b .fix_httpd_conf_d
%patch5 -p1 -b .install_config
%patch6 -p1 -b .dont_start_by_default
%patch7 -p1 -b .return_2
%patch8 -p1 -b .fix_path_to_cgi
%patch9 -p1 -b .fix_path_to_passwd
%patch10 -p1 -b .more_images
%patch11 -p1 -b .fix_perms
%patch12 -p1 -b .httpd_conf
%patch14 -p1 -b .conf_d
%patch15 -p1 

install -p -m 0644 %{SOURCE10} %{SOURCE11} %{SOURCE12} html/images/logos/


%build
%configure \
    --prefix=%{_datadir}/%{name} \
    --exec-prefix=%{_localstatedir}/lib/%{name} \
    --with-init-dir=%{_initrddir} \
    --with-cgiurl=/%{name}/cgi-bin/ \
    --with-htmlurl=/%{name} \
    --with-lockfile=%{_localstatedir}/run/%{name}.pid \
    --libdir=%{_libdir}/%{name} \
    --with-nagios-user=nagios \
    --with-nagios-grp=nagios \
    --bindir=%{_sbindir} \
    --libexecdir=%{_libdir}/%{name}/plugins \
    --sysconfdir=%{_sysconfdir}/%{name} \
    --localstatedir=%{_localstatedir}/log/%{name} \
    --datadir=%{_datadir}/%{name}/html \
    --with-gd-lib=%{_libdir} \
    --with-gd-inc=%{_includedir} \
    --enable-embedded-perl \
    --with-perlcache \
    --with-template-objects \
    --with-template-extinfo \
    STRIP=/bin/true
make %{?_smp_mflags} all

sed -i -e "s| package Embed::Persistent;|#\!%{_bindir}/perl\npackage Embed::Persistent;|" p1.pl
sed -i -e "s|NagiosCmd=/var/log/nagios/rw/nagios.cmd|NagiosCmd=%{_localstatedir}/spool/%{name}/cmd/nagios.cmd|" daemon-init
sed -i -e "s|resource.cfg|private/resource.cfg|" \
     -e "s|command_file=/var/log/nagios/rw/nagios.cmd|command_file=%{_localstatedir}/spool/%{name}/cmd/nagios.cmd|" sample-config/nagios.cfg 
sed -e "s|/usr/lib/|%{_libdir}/|" %{SOURCE2} > %{name}.htaccess
cp -f %{SOURCE3} internet.cfg
cp -f %{SOURCE5} UpgradeToVersion3.ReadMe
cp -f %{SOURCE6} UpgradeToVersion3.sh
echo >> html/stylesheets/common.css


%install
rm -rf %{buildroot}
make DESTDIR=%{buildroot} INIT_OPTS="" INSTALL_OPTS="" COMMAND_OPTS="" CGIDIR="%{_libdir}/%{name}/cgi-bin" CFGDIR="%{_sysconfdir}/%{name}" fullinstall

# relocated to sbin (Fedora-specific)
install -d -m 0755 %{buildroot}%{_bindir}
mv %{buildroot}%{_sbindir}/nagiostats %{buildroot}%{_bindir}/nagiostats

install -d -m 0755 %{buildroot}%{_sysconfdir}/%{name}/private
mv %{buildroot}%{_sysconfdir}/%{name}/resource.cfg %{buildroot}%{_sysconfdir}/%{name}/private/resource.cfg

install -d -m 0755 %{buildroot}%{_sysconfdir}/%{name}/conf.d/
install -D -m 0644 %{SOURCE4} %{buildroot}%{_sysconfdir}/%{name}/passwd

# Install header-file
install -D -m 0644 include/locations.h %{buildroot}%{_includedir}/%{name}/locations.h

# Install logrotate rule
install -D -m 0644 %{SOURCE1} %{buildroot}%{_sysconfdir}/logrotate.d/%{name}

# Make room for event-handlers
install -d -m 0755 %{buildroot}%{_libdir}/%{name}/plugins/eventhandlers

install -d -m 0775 %{buildroot}%{_localstatedir}/spool/%{name}/cmd


%clean
rm -rf %{buildroot}


%pre common
getent group nagios >/dev/null || groupadd -r nagios
getent passwd nagios >/dev/null || useradd -r -g nagios -d %{_localstatedir}/spool/%{name} -s /sbin/nologin nagios
exit 0


%preun
if [ $1 = 0 ]; then
    /sbin/service nagios stop > /dev/null 2>&1 || :
    /sbin/chkconfig --del %{name} || :
fi


%post
%{_sbindir}/usermod -a -G %{name} apache || :
/sbin/chkconfig --add %{name} || :
/sbin/service httpd condrestart > /dev/null 2>&1 || :


%postun
/sbin/service httpd condrestart > /dev/null 2>&1 || :


# missing buildrequires
#%check
#make test


%files
%dir %{_libdir}/%{name}/plugins/eventhandlers
%dir %{_libdir}/%{name}/cgi-bin
%dir %{_datadir}/%{name}
%dir %{_datadir}/%{name}/html
%doc %{_datadir}/%{name}/html/docs
%doc Changelog INSTALLING LICENSE README UPGRADING UpgradeToVersion3.ReadMe UpgradeToVersion3.sh
%doc internet.cfg
%{_datadir}/%{name}/html/[^d]*
%{_sbindir}/*
%{_bindir}/*
%{_libdir}/%{name}/cgi-bin/*cgi
%{_initrddir}/nagios
%config(noreplace) %{_sysconfdir}/httpd/conf.d/nagios.conf
%config(noreplace) %{_sysconfdir}/logrotate.d/%{name}
%config(noreplace) %{_sysconfdir}/%{name}/*cfg
%config(noreplace) %{_sysconfdir}/%{name}/objects/*cfg
%attr(0750,root,nagios) %dir %{_sysconfdir}/%{name}/private
%attr(0750,root,nagios) %dir %{_sysconfdir}/%{name}/objects
%attr(0750,root,nagios) %dir %{_sysconfdir}/%{name}/conf.d
%attr(0640,root,nagios) %config(noreplace) %{_sysconfdir}/%{name}/private/resource.cfg
%attr(0640,root,apache) %config(noreplace) %{_sysconfdir}/%{name}/passwd
%attr(0640,root,apache) %config(noreplace) %{_datadir}/%{name}/html/config.inc.php
%attr(2775,nagios,nagios) %dir %{_localstatedir}/spool/%{name}/cmd
%attr(0750,nagios,nagios) %dir %{_localstatedir}/log/%{name}
%attr(0750,nagios,nagios) %dir %{_localstatedir}/log/%{name}/archives
%attr(0750,nagios,nagios) %dir %{_localstatedir}/log/%{name}/spool/
%attr(0750,nagios,nagios) %dir %{_localstatedir}/log/%{name}/spool/checkresults


%files common
%dir %{_sysconfdir}/%{name}
%dir %{_libdir}/%{name}
%dir %{_libdir}/%{name}/plugins
%attr(0755,nagios,nagios) %dir %{_localstatedir}/spool/%{name}


%files devel
%{_includedir}/%{name}


%changelog
* Mon Oct 14 2013 baseuser@ibm.com
- Base-8.x spec file
