%define glibcsrcdir glibc-2.17-c758a686
%define glibcversion 2.17
%define glibc_portsver 2.16.0
%define glibcrelease 20%{?dist}
### glibc.spec.in follows:
%{?cross_build: %define run_glibc_tests 0}
%{!?cross_build: %define run_glibc_tests 1}
%define auxarches athlon alphaev6
%define xenarches i686 athlon
%ifarch %{xenarches}
%define buildxen 1
%define xenpackage 0
%else
%define buildxen 0
%define xenpackage 0
%endif
%ifarch ppc ppc64
%define buildpower6 1
%else
%define buildpower6 0
%endif
%define rtkaioarches %{ix86} x86_64 ppc %{power64} s390 s390x
%define biarcharches %{ix86} x86_64 ppc %{power64} s390 s390x
%define debuginfocommonarches %{biarcharches} alpha alphaev6
%define multiarcharches ppc %{power64} %{ix86} x86_64 %{sparc}
%define systemtaparches %{ix86} x86_64
# Add -s for a less verbose build output.
%define silentrules PARALLELMFLAGS=

Summary: The GNU libc libraries
Name: glibc
Version: %{glibcversion}
%define base_release .2
Release: %{?glibcrelease}%{?base_release}
# GPLv2+ is used in a bunch of programs, LGPLv2+ is used for libraries.
# Things that are linked directly into dynamically linked programs
# and shared libraries (e.g. crt files, lib*_nonshared.a) have an additional
# exception which allows linking it into any kind of programs or shared
# libraries without restrictions.
License: LGPLv2+ and LGPLv2+ with exceptions and GPLv2+
Group: System Environment/Libraries
URL: http://www.gnu.org/software/glibc/
Source0: %{?glibc_release_url}%{glibcsrcdir}.tar.gz
Source1: %{glibcsrcdir}-releng.tar.gz
# Base:Needed for cross builds
Source2: glibc-ports-%{glibc_portsver}.tar.gz
Source999: fivextra.tar.bz2

# 0000-0999 for patches which are unlikely to ever go upstream or which
# have not been analyzed to see if they ought to go upstream yet.
# 
# 1000-2000 for patches that are already upstream. 
#
# 2000-3000 for patches that are awaiting upstream approval
#
# Yes, I realize this means some gratutious changes as patches to from
# one bucket to another, but I find this scheme makes it easier to track
# the upstream divergence and patches needing approval.
#
# Note that we can still apply the patches in any order we see fit, so
# the changes from one bucket to another won't necessarily result in needing
# to twiddle the patch because of dependencies on prior patches and the like.

#
# Patches that are highly unlikely to ever be accepted upstream.
#

# Configuration twiddle, not sure there's a good case to get upstream to
# change this.
Patch0001: %{name}-fedora-nscd.patch

Patch0002: %{name}-fedora-regcomp-sw11561.patch
Patch0003: %{name}-fedora-ldd.patch

Patch0004: %{name}-fedora-ppc-unwind.patch

# Build info files in the source tree, then move to the build
# tree so that they're identical for multilib builds
Patch0005: %{name}-rh825061.patch

# Horrible hack, never to be upstreamed.  Can go away once the world
# has been rebuilt to use the new ld.so path.
Patch0006: %{name}-arm-hardfloat-3.patch

# Needs to be sent upstream
Patch0008: %{name}-fedora-getrlimit-PLT.patch
Patch0009: %{name}-fedora-include-bits-ldbl.patch

# stap, needs to be sent upstream
Patch0010: %{name}-stap-libm.patch

# Needs to be sent upstream
Patch0029: %{name}-rh841318.patch

# All these were from the glibc-fedora.patch mega-patch and need another
# round of reviewing.  Ideally they'll either be submitted upstream or
# dropped.
Patch0012: %{name}-fedora-linux-tcsetattr.patch
Patch0014: %{name}-fedora-nptl-linklibc.patch
Patch0015: %{name}-fedora-localedef.patch
Patch0016: %{name}-fedora-i386-tls-direct-seg-refs.patch
Patch0017: %{name}-fedora-gai-canonical.patch
Patch0019: %{name}-fedora-nis-rh188246.patch
Patch0020: %{name}-fedora-manual-dircategory.patch
Patch0024: %{name}-fedora-locarchive.patch
Patch0025: %{name}-fedora-streams-rh436349.patch
Patch0028: %{name}-fedora-localedata-rh61908.patch
Patch0030: %{name}-fedora-uname-getrlimit.patch
Patch0031: %{name}-fedora-__libc_multiple_libcs.patch
Patch0032: %{name}-fedora-elf-rh737223.patch
Patch0033: %{name}-fedora-elf-ORIGIN.patch
Patch0034: %{name}-fedora-elf-init-hidden_undef.patch

# Needs to be sent upstream
Patch0035: %{name}-rh911307.patch
Patch0036: %{name}-rh892777.patch
Patch0037: %{name}-rh952799.patch
Patch0038: %{name}-rh959034.patch

# Remove non-ELF support in rtkaio
Patch0040: %{name}-rh731833-rtkaio.patch
Patch0041: %{name}-rh731833-rtkaio-2.patch
Patch0042: %{name}-rh970865.patch

# CVE-2014-5119
Patch0044: %{name}-rh1119128.patch

#
# Patches from upstream
#
Patch1000: %{name}-rh905877.patch
Patch1001: %{name}-rh958652.patch
Patch1002: %{name}-rh977870.patch
Patch1003: %{name}-rh977872.patch
Patch1004: %{name}-rh977874.patch
Patch1005: %{name}-rh977875.patch
Patch1006: %{name}-rh977887.patch
Patch1007: %{name}-rh977887-2.patch
Patch1008: %{name}-rh984829.patch
Patch1009: %{name}-rh995841.patch
Patch1010: %{name}-rh947892.patch
Patch1011: %{name}-rh1008299.patch
Patch1012: %{name}-rh985342.patch
Patch1013: %{name}-rh985625-CVE-2013-4788.patch
# Add support for rtlddir distinct from slibdir.
Patch1014: %{name}-rh950093.patch

#
# Patches submitted, but not yet approved upstream.
# Each should be associated with a BZ.
# Obviously we're not there right now, but that's the goal
#
# http://sourceware.org/ml/libc-alpha/2012-12/msg00103.html
Patch2007: %{name}-rh697421.patch

Patch2011: %{name}-rh757881.patch

Patch2013: %{name}-rh741105.patch

# Upstream BZ 9954
Patch2021: %{name}-rh739743.patch

# Upstream BZ 13818
Patch2022: %{name}-rh800224.patch

# Upstream BZ 14247
Patch2023: %{name}-rh827510.patch

# Upstream BZ 13028
Patch2026: %{name}-rh841787.patch

# Upstream BZ 14185
Patch2027: %{name}-rh819430.patch

# Upstream BZ 15006
Patch2028: %{name}-rh905184.patch

# Upstream BZ 14256
Patch2039: glibc-rh966259.patch

#Upstream BZ 14547
Patch2040: %{name}-strcoll-cve.patch

# Base patches
Patch974841: bug-97484-Fix-loop-construction-to-functions-calls.patch
Patch974842: bug-97484-Fix-unsafe-compiler-optimization.patch

Buildroot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
Obsoletes: glibc-profile < 2.4
Obsoletes: nss_db
Provides: ldconfig
# The dynamic linker supports DT_GNU_HASH
Provides: rtld(GNU_HASH)

# This is a short term need until everything is rebuilt in the ARM world
# to use the new dynamic linker path
%ifarch armv7hl armv7hnl
Provides: ld-linux.so.3
Provides: ld-linux.so.3(GLIBC_2.4)
%endif

Requires: glibc-common = %{version}-%{release}
# Require libgcc in case some program calls pthread_cancel in its %%post
Requires(pre): basesystem, libgcc
# This is for building auxiliary programs like memusage, nscd
# For initial glibc bootstraps it can be commented out
%{!?cross_build:BuildRequires: gd-devel}
BuildRequires: libpng-devel zlib-devel texinfo, libselinux-devel >= 1.33.4-3
BuildRequires: audit-libs-devel >= 1.1.3, sed >= 3.95, libcap-devel, gettext, nss-devel
BuildRequires: /bin/ps, /bin/kill, /bin/awk
%ifarch %{systemtaparches}
BuildRequires: systemtap-sdt-devel
%endif
# This is to ensure that __frame_state_for is exported by glibc
# will be compatible with egcs 1.x.y
BuildRequires: gcc >= 3.2
%define enablekernel 2.6.32
Conflicts: kernel < %{enablekernel}
%define target %{_target_cpu}-redhat-linux
%ifarch %{arm}
%define target %{_target_cpu}-redhat-linuxeabi
%endif
%ifarch %{power64}
%define target ppc64-redhat-linux
%endif
%ifarch %{multiarcharches}
# Need STT_IFUNC support
%ifarch ppc %{power64}
BuildRequires: binutils >= 2.20.51.0.2
Conflicts: binutils < 2.20.51.0.2
%else
%ifarch s390 s390x
# Needed for STT_GNU_IFUNC support for s390/390x
BuildRequires: binutils >= 2.23.52.0.1-8
Conflicts: binutils < 2.23.52.0.1-8
%else
# Default to this version
BuildRequires: binutils >= 2.19.51.0.10
Conflicts: binutils < 2.19.51.0.10
%endif
%endif
# Earlier releases have broken support for IRELATIVE relocations
Conflicts: prelink < 0.4.2
%else
# Need AS_NEEDED directive
# Need --hash-style=* support
BuildRequires: binutils >= 2.17.50.0.2-5
%endif
BuildRequires: gcc >= 3.2.1-5
%ifarch ppc s390 s390x
BuildRequires: gcc >= 4.1.0-0.17
%endif
%if 0%{?_enable_debug_packages}
BuildRequires: elfutils >= 0.72
BuildRequires: rpm >= 4.2-0.56
%endif
%global __filter_GLIBC_PRIVATE 1

BuildRequires: systemd

%description
The glibc package contains standard libraries which are used by
multiple programs on the system. In order to save disk space and
memory, as well as to make upgrading easier, common system code is
kept in one place and shared between programs. This particular package
contains the most important sets of shared libraries: the standard C
library and the standard math library. Without these two libraries, a
Linux system will not function.

%if %{xenpackage}
%package xen
Summary: The GNU libc libraries (optimized for running under Xen)
Group: System Environment/Libraries
Requires: glibc = %{version}-%{release}, glibc-utils = %{version}-%{release}

%description xen
The standard glibc package is optimized for native kernels and does not
perform as well under the Xen hypervisor.  This package provides alternative
library binaries that will be selected instead when running under Xen.

Install glibc-xen if you might run your system under the Xen hypervisor.
%endif

# LTC BZ 91578: create multilib subpkgs (needed when weak arch repo isn't available, eg: s390)
%ifarch s390x
%package multilib
Summary: The GNU libc libraries for weak architectures
Group: System Environment/Libraries

%description multilib
The glibc package contains standard libraries which are used by
multiple programs on the system. In order to save disk space and
memory, as well as to make upgrading easier, common system code is
kept in one place and shared between programs. This particular package
contains the most important sets of shared libraries: the standard C
library and the standard math library. Without these two libraries, a
Linux system will not function.

This is the weak arch package for multilib architectures.
%endif # end LTC multilib

%package devel
Summary: Object files for development using standard C libraries.
Group: Development/Libraries
Requires(pre): /sbin/install-info
Requires(pre): %{name}-headers
Requires: %{name}-headers = %{version}-%{release}
Requires: %{name} = %{version}-%{release}

%description devel
The glibc-devel package contains the object files necessary
for developing programs which use the standard C libraries (which are
used by nearly all programs).  If you are developing programs which
will use the standard C libraries, your system needs to have these
standard object files available in order to create the
executables.

Install glibc-devel if you are going to develop programs which will
use the standard C libraries.

%package static
Summary: C library static libraries for -static linking.
Group: Development/Libraries
Requires: %{name}-devel = %{version}-%{release}

%description static
The glibc-static package contains the C library static libraries
for -static linking.  You don't need these, unless you link statically,
which is highly discouraged.

%package headers
Summary: Header files for development using standard C libraries.
Group: Development/Libraries
Provides: %{name}-headers(%{_target_cpu})
%ifarch x86_64
# If both -m32 and -m64 is to be supported on AMD64, x86_64 glibc-headers
# have to be installed, not i586 ones.
Obsoletes: %{name}-headers(i586)
Obsoletes: %{name}-headers(i686)
%endif
Requires(pre): kernel-headers
Requires: kernel-headers >= 2.2.1, %{name} = %{version}-%{release}
BuildRequires: kernel-headers >= 2.6.22

%description headers
The glibc-headers package contains the header files necessary
for developing programs which use the standard C libraries (which are
used by nearly all programs).  If you are developing programs which
will use the standard C libraries, your system needs to have these
standard header files available in order to create the
executables.

Install glibc-headers if you are going to develop programs which will
use the standard C libraries.

%package common
Summary: Common binaries and locale data for glibc
Requires: %{name} = %{version}-%{release}
Requires: tzdata >= 2003a
Group: System Environment/Base

%description common
The glibc-common package includes common binaries for the GNU libc
libraries, as well as national language (locale) support.

%package -n nscd
Summary: A Name Service Caching Daemon (nscd).
Group: System Environment/Daemons
Requires: %{name} = %{version}-%{release}
Requires: libselinux >= 1.17.10-1, audit-libs >= 1.1.3
Requires(pre): /usr/sbin/useradd, coreutils
Requires(post): systemd
Requires(preun): systemd
Requires(postun): systemd, /usr/sbin/userdel

%description -n nscd
Nscd caches name service lookups and can dramatically improve
performance with NIS+, and may help with DNS as well.

%package utils
Summary: Development utilities from GNU C library
Group: Development/Tools
Requires: %{name} = %{version}-%{release}

%description utils
The glibc-utils package contains memusage, a memory usage profiler,
mtrace, a memory leak tracer and xtrace, a function call tracer
which can be helpful during program debugging.

If unsure if you need this, don't install this package.

%if 0%{?_enable_debug_packages}
%define debug_package %{nil}
%define __debug_install_post %{nil}
%global __debug_package 1

%package debuginfo
Summary: Debug information for package %{name}
Group: Development/Debug
AutoReqProv: no
%ifarch %{debuginfocommonarches}
Requires: glibc-debuginfo-common = %{version}-%{release}
%else
%ifarch %{ix86} %{sparc}
Obsoletes: glibc-debuginfo-common
%endif
%endif

%description debuginfo
This package provides debug information for package %{name}.
Debug information is useful when developing applications that use this
package or when debugging this package.

This package also contains static standard C libraries with
debugging information.  You need this only if you want to step into
C library routines during debugging programs statically linked against
one or more of the standard C libraries.
To use this debugging information, you need to link binaries
with -static -L%{_prefix}/lib/debug%{_prefix}/%{_lib} compiler options.

%ifarch %{debuginfocommonarches}

%package debuginfo-common
Summary: Debug information for package %{name}
Group: Development/Debug
AutoReqProv: no

%description debuginfo-common
This package provides debug information for package %{name}.
Debug information is useful when developing applications that use this
package or when debugging this package.

%endif
%endif

%package fivextra
Summary: FIV Tests for %{name} and nscd
Group: fivextra
Prefix: /opt/fiv/ltp
# Do not automatically generate 'provides' since we do not want any
# functionality beyond the testcases provided by this package. This
# means we will need to manually define 'provides' based on what we
# deliver in this fivextra package.
AutoProv: no
Provides: bug-dlsym1-lib2.so()(64bit), bug-dlsym1-lib2.so

%description fivextra
This package contains the testcases built from the package for %{name} and nscd

%prep
%setup -q -n %{glibcsrcdir} -b1 -a 2 -a 999

%patch0001 -p1
%patch0002 -p1
%patch0003 -p1
%patch0004 -p1
%patch0005 -p1
%patch0006 -p1
%patch2007 -p1
%patch0008 -p1
%patch0009 -p1
%patch0010 -p1
%patch2011 -p1
%patch0012 -p1
%patch2013 -p1
%patch0014 -p1
%patch0015 -p1
%patch0016 -p1
%patch0017 -p1
%patch0019 -p1
%patch0020 -p1
%patch2021 -p1
%patch2022 -p1
%patch2023 -p1
%patch0024 -p1
%patch0025 -p1
%patch2026 -p1
%patch2027 -p1
%patch0028 -p1
%patch0029 -p1
%patch0030 -p1
%patch0031 -p1
%patch0032 -p1
%patch0033 -p1
%patch0034 -p1
%patch2028 -p1
# LTC: Normally we do not apply arch-specific patches, but this one changes
# an existing Makefile to use CFLAGS that our cross compiler doesn't understand.
# Do not apply on cross builds.
%{!?cross_build:%patch0035 -p1}
%patch0036 -p1
%patch0037 -p1
%patch1000 -p1
%patch0038 -p1
%patch2039 -p1
%patch1001 -p1
%patch1002 -p1
%patch1003 -p1
%patch1004 -p1
%patch1005 -p1
%patch0044 -p1
%patch1006 -p1
%patch1007 -p1
%patch1008 -p1
%patch2040 -p1
%patch1009 -p1
%patch1010 -p1
%patch0040 -p1
%patch0041 -p1
%patch0042 -p1
%patch1011 -p1
%patch1012 -p1
%patch1013 -p1
%patch1014 -p1

%patch974841 -p1 
%patch974842 -p1

# Base: This is done before build section, to over come cross build issues
find . -type f -size 0 -o -name "*.orig" -exec rm -f {} \;
touch `find . -name configure`
touch locale/programs/*-kw.h

%build
# Base: Move this inside build section, to over come cross build issues
# On powerpc32, hp timing is only available in power4/power6
# libs, not in base, so pre-power4 dynamic linker is incompatible
# with power6 libs.
%if %{buildpower6}
rm -f sysdeps/powerpc/powerpc32/power4/hp-timing.[ch]
%endif

GCC=%{__cc}
GXX=%{__cxx}
%ifarch %{ix86}
BuildFlags="-march=%{_target_cpu} -mtune=generic"
%endif
%ifarch i686
BuildFlags="-march=i686 -mtune=generic"
%endif
%ifarch i386 i486 i586
BuildFlags="$BuildFlags -mno-tls-direct-seg-refs"
%endif
%ifarch x86_64
BuildFlags="-mtune=generic"
%endif
%ifarch sparc
BuildFlags="-fcall-used-g6"
GCC="gcc -m32"
GXX="g++ -m32"
%endif
%ifarch sparcv9
BuildFlags="-mcpu=ultrasparc -fcall-used-g6"
GCC="gcc -m32"
GXX="g++ -m32"
%endif
%ifarch sparcv9v
BuildFlags="-mcpu=niagara -fcall-used-g6"
GCC="gcc -m32"
GXX="g++ -m32"
%endif
%ifarch sparc64
BuildFlags="-mcpu=ultrasparc -mvis -fcall-used-g6"
GCC="gcc -m64"
GXX="g++ -m64"
%endif
%ifarch sparc64v
BuildFlags="-mcpu=niagara -mvis -fcall-used-g6"
GCC="gcc -m64"
GXX="g++ -m64"
%endif
%ifarch %{power64}
BuildFlags=""
GCC="gcc -m64"
GXX="g++ -m64"
%endif
%ifarch s390x
BuildFlags="-march=z9-109 -mtune=z10"
GCC="gcc -m64"
GXX="g++ -m64"
%endif
%ifarch mips64
BuildFlags="-march=mips64 -mtune=mips64"
GCC="%{_tool_triplet}-gcc -mabi=64"
GXX="%{_tool_triplet}-g++ -mabi=64"
%endif
%ifarch ppca2
BuildFlags="-mno-minimal-toc"
GCC="%{_tool_triplet}-gcc -m64"
GXX="%{_tool_triplet}-g++ -m64"
%endif
%ifarch ppc476 ppcnf
GCC="%{_tool_triplet}-gcc"
GXX="%{_tool_triplet}-g++"
%endif

BuildFlags="$BuildFlags -fasynchronous-unwind-tables"
# Add -DNDEBUG unless using a prerelease
case %{version} in
  *.*.9[0-9]*) ;;
  *)
     BuildFlags="$BuildFlags -DNDEBUG"
     ;;
esac
EnableKernel="--enable-kernel=%{enablekernel}"
echo "$GCC" > Gcc
AddOns=`echo */configure | sed -e 's!/configure!!g;s!\(linuxthreads\|nptl\|rtkaio\|powerpc-cpu\)\( \|$\)!!g;s! \+$!!;s! !,!g;s!^!,!;/^,\*$/d'`
%ifarch %{rtkaioarches}
AddOns=,rtkaio$AddOns
%endif

%if 0%{?cross_build}
CrossOpts="--with-binutils=%{_sysroot}/../bin"
export libc_cv_forced_unwind=yes
export libc_cv_c_cleanup=yes
%ifarch mips64
AddOns=$AddOns,ports
export libc_cv_gnu89_inline=yes
export libc_cv_slibdir=/%{_lib}
%endif
%ifarch ppca2
export ac_cv_type_long_double=yes
export ac_cv_sizeof_long_double=16
%endif
%ifarch ppc476
AddOns=$AddOns,ports
CrossOpts="$CrossOpts --with-fp"
export ac_cv_type_long_double=yes
export ac_cv_sizeof_long_double=16
%endif
%ifarch ppcnf
AddOns=$AddOns,ports
CrossOpts="$CrossOpts --without-fp"
export ac_cv_type_long_double=yes
export ac_cv_sizeof_long_double=16
%endif
%endif # end cross_build

build()
{
builddir=build-%{target}${1:+-$1}
${1+shift}
rm -rf $builddir
mkdir $builddir ; cd $builddir
build_CFLAGS="$BuildFlags -g -O3 $*"
%if 0%{?cross_build}
export ac_cv_type_long_double=yes
export ac_cv_sizeof_long_double=16
export AR=%{_tool_triplet}-ar BUILD_CC="gcc" LD=%{_tool_triplet}-ld RANLIB=%{_tool_triplet}-ranlib
%endif
# Some configure checks can spuriously fail for some architectures if
# unwind info is present
configure_CFLAGS="$build_CFLAGS -fno-asynchronous-unwind-tables"
../configure CC="$GCC" CXX="$GXX" CFLAGS="$configure_CFLAGS" \
	--prefix=%{_prefix} \
	--enable-add-ons=ports,nptl$AddOns \
	$EnableKernel --enable-bind-now \
	%{?cross_build: --libdir=%{_libdir}} \
	%{?cross_build: --with-headers=%{_sysroot}/usr/include}%{!?cross_build: --with-headers=%{_prefix}/include} \
	%{?cross_build: --build=%{_build_platform}}%{!?cross_build: --build=%{target}} \
	%{?cross_build: --host=%{_host}}%{!?cross_build: --host=%{target}} \
%ifarch %{multiarcharches}
	--enable-multi-arch \
%endif
	--enable-obsolete-rpc \
%ifarch %{systemtaparches}
	--enable-systemtap \
%endif
%ifarch ppc64p7
	--with-cpu=power7 \
%endif
	--disable-profile --enable-nss-crypt \
	${CrossOpts} ||
{ cat config.log; false; }

make %{?_smp_mflags} -r CFLAGS="$build_CFLAGS" %{silentrules} %{?cross_build:cross-compiling="yes"}%{!?cross_build:cross-compiling="no"}

cd ..
}

build

%if %{buildxen}
build nosegneg -mno-tls-direct-seg-refs
%endif

%if %{buildpower6}
(
platform=`LD_SHOW_AUXV=1 /bin/true | sed -n 's/^AT_PLATFORM:[[:blank:]]*//p'`
if [ "$platform" != power6 ]; then
  mkdir -p power6emul/{lib,lib64}
  $GCC -shared -O2 -fpic -o power6emul/%{_lib}/power6emul.so releng/power6emul.c -Wl,-z,initfirst
%ifarch ppc
  gcc -shared -nostdlib -O2 -fpic -m64 -o power6emul/lib64/power6emul.so -xc - </dev/null
%endif
%ifarch ppc64
  gcc -shared -nostdlib -O2 -fpic -m32 -o power6emul/lib/power6emul.so -xc - < /dev/null
%endif
  export LD_PRELOAD=`pwd`/power6emul/\$LIB/power6emul.so
fi
AddOns="$AddOns --with-cpu=power6"
GCC="$GCC -mcpu=power6"
GXX="$GXX -mcpu=power6"
build power6
)
%endif

cd build-%{target}
$GCC -static -L. -Os -g ../releng/glibc_post_upgrade.c -o glibc_post_upgrade.%{_target_cpu} \
  '-DLIBTLS="/%{_lib}/tls/"' \
  '-DGCONV_MODULES_DIR="%{_prefix}/%{_lib}/gconv"' \
  '-DLD_SO_CONF="/etc/ld.so.conf"' \
  '-DICONVCONFIG="%{_sbindir}/iconvconfig.%{_target_cpu}"'
cd ..

# LTC BZ 91578: create multilib subpkgs (needed when weak arch repo isn't available, eg: s390)
%ifarch s390x
GCC="$GCC -m31"
GXX="$GXX -m31"
# While not a typical cross build, we'll use the cross techniques to override
# required config opts in build_nptl().
CrossOpts="--disable-systemtap --disable-nss-crypt"
export ac_cv_host=s390-ibm-linux-gnu
export libc_cv_forced_unwind=yes
export libc_cv_c_cleanup=yes
export libc_cv_nss_crypt=no
build multilib
%endif # end LTC multilib

pushd fivextra/glibc
make CC=%{__cc} CXX=%{__cxx} all
popd

pushd fivextra/nscd
make CC=%{__cc} CXX=%{__cxx} all
popd

%install
GCC=`cat Gcc`

rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT
make -j1 install_root=$RPM_BUILD_ROOT install -C build-%{target} %{silentrules}
# LTC: Don't make locales during cross
%ifnarch %{auxarches} %{?cross_arches}
cd build-%{target} && \
  make %{?_smp_mflags} install_root=$RPM_BUILD_ROOT install-locales -C ../localedata objdir=`pwd` && \
  cd ..
%endif

librtso=`basename $RPM_BUILD_ROOT/%{_lib}/librt.so.*`

%ifarch %{rtkaioarches}
rm -f $RPM_BUILD_ROOT{,%{_prefix}}/%{_lib}/librtkaio.*
rm -f $RPM_BUILD_ROOT%{_prefix}/%{_lib}/librt.so.*
mkdir -p $RPM_BUILD_ROOT/%{_lib}/rtkaio
mv $RPM_BUILD_ROOT/%{_lib}/librtkaio-*.so $RPM_BUILD_ROOT/%{_lib}/rtkaio/
rm -f $RPM_BUILD_ROOT/%{_lib}/$librtso
ln -sf `basename $RPM_BUILD_ROOT/%{_lib}/librt-*.so` $RPM_BUILD_ROOT/%{_lib}/$librtso
ln -sf `basename $RPM_BUILD_ROOT/%{_lib}/rtkaio/librtkaio-*.so` $RPM_BUILD_ROOT/%{_lib}/rtkaio/$librtso
%endif

%if %{buildxen}
%define nosegneg_subdir_base i686
%define nosegneg_subdir i686/nosegneg
%define nosegneg_subdir_up ../..
cd build-%{target}-nosegneg
destdir=$RPM_BUILD_ROOT/%{_lib}/%{nosegneg_subdir}
mkdir -p $destdir
for lib in libc math/libm nptl/libpthread rt/librt nptl_db/libthread_db
do
  libbase=${lib#*/}
  libbaseso=$(basename $RPM_BUILD_ROOT/%{_lib}/${libbase}-*.so)
  # Only install if different from base lib
  if cmp -s ${lib}.so ../build-%{target}/${lib}.so; then
    ln -sf %{nosegneg_subdir_up}/$libbaseso $destdir/$libbaseso
  else
    cp -a ${lib}.so $destdir/$libbaseso
  fi
  ln -sf $libbaseso $destdir/$(basename $RPM_BUILD_ROOT/%{_lib}/${libbase}.so.*)
done
%ifarch %{rtkaioarches}
destdir=$RPM_BUILD_ROOT/%{_lib}/rtkaio/%{nosegneg_subdir}
mkdir -p $destdir
librtkaioso=$(basename $RPM_BUILD_ROOT/%{_lib}/librt-*.so | sed s/librt-/librtkaio-/)
if cmp -s rtkaio/librtkaio.so ../build-%{target}/rtkaio/librtkaio.so; then
  ln -s %{nosegneg_subdir_up}/$librtkaioso $destdir/$librtkaioso
else
  cp -a rtkaio/librtkaio.so $destdir/$librtkaioso
fi
ln -sf $librtkaioso $destdir/$librtso
%endif
cd ..
%endif

%if %{buildpower6}
cd build-%{target}-power6
destdir=$RPM_BUILD_ROOT/%{_lib}/power6
mkdir -p ${destdir}
for lib in libc math/libm nptl/libpthread rt/librt nptl_db/libthread_db
do
  libbase=${lib#*/}
  libbaseso=$(basename $RPM_BUILD_ROOT/%{_lib}/${libbase}-*.so)
  cp -a ${lib}.so $destdir/$libbaseso
  ln -sf $libbaseso $destdir/$(basename $RPM_BUILD_ROOT/%{_lib}/${libbase}.so.*)
done
mkdir -p ${destdir}x
pushd ${destdir}x
ln -sf ../power6/*.so .
cp -a ../power6/*.so.* .
popd
%ifarch %{rtkaioarches}
destdir=$RPM_BUILD_ROOT/%{_lib}/rtkaio/power6
mkdir -p $destdir
librtkaioso=$(basename $RPM_BUILD_ROOT/%{_lib}/librt-*.so | sed s/librt-/librtkaio-/)
cp -a rtkaio/librtkaio.so $destdir/$librtkaioso
ln -sf $librtkaioso $destdir/$librtso
mkdir -p ${destdir}x
pushd ${destdir}x
ln -sf ../power6/*.so .
cp -a ../power6/*.so.* .
popd
%endif
cd ..
%endif

# LTC BZ 91578: create multilib subpkgs (needed when weak arch repo isn't available, eg: s390)
%ifarch s390x
cd build-%{target}-multilib
destdir=$RPM_BUILD_ROOT/lib
mkdir -p ${destdir}
install elf/ld.so $destdir/ld-2.12.so
ln -s ld-2.12.so $destdir/ld.so.1
for lib in libc elf/ld math/libm nptl/libpthread rt/librt nptl_db/libthread_db
do
  libbase=${lib#*/}
  libbaseso=$(basename $RPM_BUILD_ROOT/%{_lib}/${libbase}-*.so)
  cp -a ${lib}.so $destdir/$libbaseso
  ln -sf $libbaseso $destdir/$(basename $RPM_BUILD_ROOT/%{_lib}/${libbase}.so.*)
done
%ifarch %{rtkaioarches}
destdir=$RPM_BUILD_ROOT/lib/rtkaio
mkdir -p $destdir
librtkaioso=$(basename $RPM_BUILD_ROOT/%{_lib}/librt-*.so | sed s/librt-/librtkaio-/)
cp -a rtkaio/librtkaio.so $destdir/$librtkaioso
ln -sf $librtkaioso $destdir/$librtso
%endif
cd ..
%endif # end LTC multilib

# Remove the files we don't want to distribute
rm -f $RPM_BUILD_ROOT%{_prefix}/%{_lib}/libNoVersion*
rm -f $RPM_BUILD_ROOT/%{_lib}/libNoVersion*

# NPTL <bits/stdio-lock.h> is not usable outside of glibc, so include
# the generic one (#162634)
cp -a bits/stdio-lock.h $RPM_BUILD_ROOT%{_prefix}/include/bits/stdio-lock.h
# And <bits/libc-lock.h> needs sanitizing as well.
cp -a releng/libc-lock.h $RPM_BUILD_ROOT%{_prefix}/include/bits/libc-lock.h

if [ -d $RPM_BUILD_ROOT%{_prefix}/info -a "%{_infodir}" != "%{_prefix}/info" ]; then
  mkdir -p $RPM_BUILD_ROOT%{_infodir}
  mv -f $RPM_BUILD_ROOT%{_prefix}/info/* $RPM_BUILD_ROOT%{_infodir}
  rm -rf $RPM_BUILD_ROOT%{_prefix}/info
fi

if [ -d $RPM_BUILD_ROOT%{_infodir} ]; then
gzip -9nvf $RPM_BUILD_ROOT%{_infodir}/libc*
fi

ln -sf libbsd-compat.a $RPM_BUILD_ROOT%{_prefix}/%{_lib}/libbsd.a

install -p -m 644 releng/nsswitch.conf $RPM_BUILD_ROOT/etc/nsswitch.conf

%ifnarch %{auxarches}
mkdir -p $RPM_BUILD_ROOT/etc/default
install -p -m 644 nis/nss $RPM_BUILD_ROOT/etc/default/nss

# This is for ncsd - in glibc 2.2
install -m 644 nscd/nscd.conf $RPM_BUILD_ROOT/etc
mkdir -p $RPM_BUILD_ROOT%{_tmpfilesdir}
install -m 644 releng/nscd.conf %{buildroot}%{_tmpfilesdir}
mkdir -p $RPM_BUILD_ROOT/lib/systemd/system
install -m 644 releng/nscd.service releng/nscd.socket $RPM_BUILD_ROOT/lib/systemd/system
%endif

# Include ld.so.conf
echo 'include ld.so.conf.d/*.conf' > $RPM_BUILD_ROOT/etc/ld.so.conf
> $RPM_BUILD_ROOT/etc/ld.so.cache
chmod 644 $RPM_BUILD_ROOT/etc/ld.so.conf
mkdir -p $RPM_BUILD_ROOT/etc/ld.so.conf.d
%ifnarch %{auxarches}
mkdir -p $RPM_BUILD_ROOT/etc/sysconfig
> $RPM_BUILD_ROOT/etc/sysconfig/nscd
> $RPM_BUILD_ROOT/etc/gai.conf
%endif

# Include %{_prefix}/%{_lib}/gconv/gconv-modules.cache
> $RPM_BUILD_ROOT%{_prefix}/%{_lib}/gconv/gconv-modules.cache
chmod 644 $RPM_BUILD_ROOT%{_prefix}/%{_lib}/gconv/gconv-modules.cache

# Install the upgrade program
install -m 700 build-%{target}/glibc_post_upgrade.%{_target_cpu} \
  $RPM_BUILD_ROOT/usr/sbin/glibc_post_upgrade.%{_target_cpu}

strip -g $RPM_BUILD_ROOT%{_prefix}/%{_lib}/*.o

%if 0%{?_enable_debug_packages}
mkdir -p $RPM_BUILD_ROOT%{_prefix}/lib/debug%{_prefix}/%{_lib}
cp -a $RPM_BUILD_ROOT%{_prefix}/%{_lib}/*.a \
  $RPM_BUILD_ROOT%{_prefix}/lib/debug%{_prefix}/%{_lib}/
rm -f $RPM_BUILD_ROOT%{_prefix}/lib/debug%{_prefix}/%{_lib}/*_p.a
%endif

# rquota.x and rquota.h are now provided by quota
rm -f $RPM_BUILD_ROOT%{_prefix}/include/rpcsvc/rquota.[hx]

# Create archive of locale files
# LTC: can't run localedef during cross
%ifnarch %{auxarches} %{?cross_arches}
olddir=`pwd`
pushd ${RPM_BUILD_ROOT}%{_prefix}/lib/locale
rm locale-archive || :
# Intentionally we do not pass --alias-file=, aliases will be added
# by build-locale-archive.
$olddir/build-%{target}/elf/ld.so \
  --library-path $olddir/build-%{target}/ \
  $olddir/build-%{target}/locale/localedef \
    --prefix ${RPM_BUILD_ROOT} --add-to-archive \
    *_*
rm -rf *_*
mv locale-archive{,.tmpl}
popd
%endif

rm -f ${RPM_BUILD_ROOT}/%{_lib}/libnss1-*
rm -f ${RPM_BUILD_ROOT}/%{_lib}/libnss-*.so.1

# Ugly hack for buggy rpm
ln -f ${RPM_BUILD_ROOT}%{_sbindir}/iconvconfig{,.%{_target_cpu}}

# In F7+ this is provided by rpcbind rpm
rm -f $RPM_BUILD_ROOT%{_sbindir}/rpcinfo

# BUILD THE FILE LIST
{
  find $RPM_BUILD_ROOT \( -type f -o -type l \) \
       \( \
	 -name etc -printf "%%%%config " -o \
	 -name gconv-modules \
	 -printf "%%%%verify(not md5 size mtime) %%%%config(noreplace) " -o \
	 -name gconv-modules.cache \
	 -printf "%%%%verify(not md5 size mtime) " \
	 , \
	 ! -path "*/lib/debug/*" -printf "/%%P\n" \)
  find $RPM_BUILD_ROOT -type d \
       \( -path '*%{_prefix}/share/*' ! -path '*%{_infodir}' -o \
	  -path "*%{_prefix}/include/*" \
       \) -printf "%%%%dir /%%P\n"
} | {

  # primary filelist
  SHARE_LANG='s|.*/share/locale/\([^/_]\+\).*/LC_MESSAGES/.*\.mo|%lang(\1) &|'
  LIB_LANG='s|.*/lib/locale/\([^/_]\+\)|%lang(\1) &|'
  # rpm does not handle %lang() tagged files hardlinked together accross
  # languages very well, temporarily disable
  LIB_LANG=''
  sed -e "$LIB_LANG" -e "$SHARE_LANG" \
      -e '\,/etc/\(localtime\|nsswitch.conf\|ld\.so\.conf\|ld\.so\.cache\|default\|rpc\|gai\.conf\),d' \
      -e '\,/%{_lib}/lib\(pcprofile\|memusage\)\.so,d' \
      -e '\,bin/\(memusage\|mtrace\|xtrace\|pcprofiledump\),d'
} | sort > rpm.filelist

mkdir -p $RPM_BUILD_ROOT%{_prefix}/%{_lib}
mv -f $RPM_BUILD_ROOT/%{_lib}/lib{pcprofile,memusage}.so $RPM_BUILD_ROOT%{_prefix}/%{_lib}
# Memusage script will not be present during cross (see malloc/Makefile for ifneq cross exclusion)
%if 0%{?cross_build}
UtilInstallScripts="$RPM_BUILD_ROOT%{_prefix}/bin/xtrace"
%else
UtilInstallScripts="$RPM_BUILD_ROOT%{_prefix}/bin/xtrace $RPM_BUILD_ROOT%{_prefix}/bin/memusage"
%endif
for i in $UtilInstallScripts; do
  sed -e 's~=/%{_lib}/libpcprofile.so~=%{_prefix}/%{_lib}/libpcprofile.so~' \
      -e 's~=/%{_lib}/libmemusage.so~=%{_prefix}/%{_lib}/libmemusage.so~' \
      -e 's~='\''/\\\$LIB/libpcprofile.so~='\''%{_prefix}/\\$LIB/libpcprofile.so~' \
      -e 's~='\''/\\\$LIB/libmemusage.so~='\''%{_prefix}/\\$LIB/libmemusage.so~' \
      -i $i
done

if [ -d $RPM_BUILD_ROOT%{_infodir} ]; then
  grep '%{_infodir}' < rpm.filelist | grep -v '%{_infodir}/dir' > devel.filelist
fi
grep '%{_prefix}/include/gnu/stubs-[32164]\+\.h' < rpm.filelist >> devel.filelist || :

grep '%{_prefix}/include' < rpm.filelist |
  egrep -v '%{_prefix}/include/(linuxthreads|gnu/stubs-[32164]+\.h)' \
	> headers.filelist

sed -i -e '\|%{_prefix}/%{_lib}/lib.*_p.a|d' \
       -e '\|%{_prefix}/include|d' \
       -e '\|%{_infodir}|d' rpm.filelist

grep '%{_prefix}/%{_lib}/lib.*\.a' < rpm.filelist \
  | grep '/lib\(\(c\|pthread\|nldbl\)_nonshared\|bsd\(\|-compat\)\|g\|ieee\|mcheck\|rpcsvc\)\.a$' \
  >> devel.filelist
grep '%{_prefix}/%{_lib}/lib.*\.a' < rpm.filelist \
  | grep -v '/lib\(\(c\|pthread\|nldbl\)_nonshared\|bsd\(\|-compat\)\|g\|ieee\|mcheck\|rpcsvc\)\.a$' \
  > static.filelist
grep '%{_prefix}/%{_lib}/.*\.o' < rpm.filelist >> devel.filelist
grep '%{_prefix}/%{_lib}/lib.*\.so' < rpm.filelist >> devel.filelist

sed -i -e '\|%{_prefix}/%{_lib}/lib.*\.a|d' \
       -e '\|%{_prefix}/%{_lib}/.*\.o|d' \
       -e '\|%{_prefix}/%{_lib}/lib.*\.so|d' \
       -e '\|%{_prefix}/%{_lib}/linuxthreads|d' \
       -e '\|nscd|d' rpm.filelist

grep '%{_prefix}/bin' < rpm.filelist >> common.filelist
grep '%{_prefix}/sbin/[^gi]' < rpm.filelist >> common.filelist
grep '%{_prefix}/share' < rpm.filelist | \
  grep -v -e '%{_prefix}/share/zoneinfo' -e '%%dir %{prefix}/share' \
       >> common.filelist

sed -i -e '\|%{_prefix}/bin|d' \
       -e '\|%{_prefix}/lib/locale|d' \
       -e '\|%{_prefix}/sbin/[^gi]|d' \
       -e '\|%{_prefix}/share|d' rpm.filelist

> nosegneg.filelist
%if %{xenpackage}
grep '/%{_lib}/%{nosegneg_subdir}' < rpm.filelist >> nosegneg.filelist
sed -i -e '\|/%{_lib}/%{nosegneg_subdir}|d' rpm.filelist
%endif

echo '%{_prefix}/sbin/build-locale-archive' >> common.filelist
echo '%{_prefix}/sbin/nscd' > nscd.filelist

cat >> rpm.filelist <<EOF
%{_prefix}/%{_lib}/libmemusage.so
%{_prefix}/%{_lib}/libpcprofile.so
EOF
cat > utils.filelist <<EOF
%if ! 0%{?cross_build}
%{_prefix}/bin/memusage
%{_prefix}/bin/memusagestat
%endif
%{_prefix}/bin/mtrace
%{_prefix}/bin/pcprofiledump
%{_prefix}/bin/xtrace
EOF

rm -rf $RPM_BUILD_ROOT%{_prefix}/share/zoneinfo

# Make sure %config files have the same timestamp
touch -r releng/glibc.spec.in $RPM_BUILD_ROOT/etc/ld.so.conf
touch -r sunrpc/etc.rpc $RPM_BUILD_ROOT/etc/rpc

# We allow undefined symbols in shared libraries because the libraries
# referenced at link time here, particularly ld.so, may be different than
# the one used at runtime.  This is really only needed during the ARM 
# transition from ld-linux.so.3 to ld-linux-armhf.so.3.
cd releng 
$GCC -Os -g -o build-locale-archive build-locale-archive.c \
  ../build-%{target}/locale/locarchive.o \
  ../build-%{target}/locale/md5.o \
  -DDATADIR=\"%{_datadir}\" -DPREFIX=\"%{_prefix}\" \
  -L../build-%{target} \
  -Wl,--allow-shlib-undefined \
  -B../build-%{target}/csu/ -lc -lc_nonshared
install -m 700 build-locale-archive $RPM_BUILD_ROOT/usr/sbin/build-locale-archive
cd ..

# the last bit: more documentation
rm -rf documentation
mkdir documentation
cp crypt/README.ufc-crypt documentation/README.ufc-crypt
cp timezone/README documentation/README.timezone
cp ChangeLog{,.15,.16} documentation
bzip2 -9 documentation/ChangeLog*
cp posix/gai.conf documentation/

%ifarch s390x
# Compatibility symlink
mkdir -p $RPM_BUILD_ROOT/lib
ln -sf /%{_lib}/ld64.so.1 $RPM_BUILD_ROOT/lib/ld64.so.1
%endif

# Leave a compatibility symlink for the dynamic loader on armhfp targets,
# at least until the world gets rebuilt
%ifarch armv7hl armv7hnl
ln -sf /lib/ld-linux-armhf.so.3 $RPM_BUILD_ROOT/lib/ld-linux.so.3
%endif

%if %{run_glibc_tests}

# Increase timeouts
export TIMEOUTFACTOR=16
parent=$$
echo ====================TESTING=========================
cd build-%{target}
( make %{?_smp_mflags} -k check %{silentrules} 2>&1
  sleep 10s
  teepid="`ps -eo ppid,pid,command | awk '($1 == '${parent}' && $3 ~ /^tee/) { print $2 }'`"
  [ -n "$teepid" ] && kill $teepid
) | tee check.log || :
cd ..
%if %{buildxen}
echo ====================TESTING -mno-tls-direct-seg-refs=============
cd build-%{target}-nosegneg
( make %{?_smp_mflags} -k check %{silentrules} 2>&1
  sleep 10s
  teepid="`ps -eo ppid,pid,command | awk '($1 == '${parent}' && $3 ~ /^tee/) { print $2 }'`"
  [ -n "$teepid" ] && kill $teepid
) | tee check.log || :
cd ..
%endif
%if %{buildpower6}
echo ====================TESTING -mcpu=power6=============
cd build-%{target}-power6
( if [ -d ../power6emul ]; then
    export LD_PRELOAD=`cd ../power6emul; pwd`/\$LIB/power6emul.so
  fi
  make %{?_smp_mflags} -k check %{silentrules} 2>&1
  sleep 10s
  teepid="`ps -eo ppid,pid,command | awk '($1 == '${parent}' && $3 ~ /^tee/) { print $2 }'`"
  [ -n "$teepid" ] && kill $teepid
) | tee check.log || :
cd ..
%endif
echo ====================TESTING DETAILS=================
for i in `sed -n 's|^.*\*\*\* \[\([^]]*\.out\)\].*$|\1|p' build-*-linux*/check.log`; do
  echo =====$i=====
  cat $i || :
  echo ============
done
echo ====================TESTING END=====================
PLTCMD='/^Relocation section .*\(\.rela\?\.plt\|\.rela\.IA_64\.pltoff\)/,/^$/p'
echo ====================PLT RELOCS LD.SO================
readelf -Wr $RPM_BUILD_ROOT/%{_lib}/ld-*.so | sed -n -e "$PLTCMD"
echo ====================PLT RELOCS LIBC.SO==============
readelf -Wr $RPM_BUILD_ROOT/%{_lib}/libc-*.so | sed -n -e "$PLTCMD"
echo ====================PLT RELOCS END==================

%endif

pushd $RPM_BUILD_ROOT/usr/%{_lib}/
$GCC -r -nostdlib -o libpthread.o -Wl,--whole-archive ./libpthread.a
rm libpthread.a
ar rcs libpthread.a libpthread.o
rm libpthread.o
popd

%if 0%{?_enable_debug_packages}

# The #line directives gperf generates do not give the proper
# file name relative to the build directory.
(cd locale; ln -s programs/*.gperf .)
(cd iconv; ln -s ../locale/programs/charmap-kw.gperf .)

ls -l $RPM_BUILD_ROOT/usr/bin/getconf
ls -l $RPM_BUILD_ROOT/usr/libexec/getconf
eu-readelf -hS $RPM_BUILD_ROOT/usr/bin/getconf $RPM_BUILD_ROOT/usr/libexec/getconf/*

find_debuginfo_args='--strict-build-id -g'
%ifarch %{debuginfocommonarches}
find_debuginfo_args="$find_debuginfo_args \
  -l common.filelist -l utils.filelist -l nscd.filelist \
  -p '.*/(sbin|libexec)/.*' \
  -o debuginfocommon.filelist \
  -l rpm.filelist -l nosegneg.filelist \
"
%endif
eval /usr/lib/rpm/find-debuginfo.sh "$find_debuginfo_args" -o debuginfo.filelist

list_debug_archives()
{
  local dir=%{_prefix}/lib/debug%{_prefix}/%{_lib}
  find $RPM_BUILD_ROOT$dir -name "*.a" -printf "$dir/%%P\n"
}

%ifarch %{debuginfocommonarches}

sed -i '\#^%{_prefix}/src/debug/#d' debuginfocommon.filelist
find $RPM_BUILD_ROOT%{_prefix}/src/debug \
     \( -type d -printf '%%%%dir ' \) , \
     -printf '%{_prefix}/src/debug/%%P\n' > debuginfocommon.sources

%ifarch %{biarcharches}

cat debuginfocommon.sources >> debuginfo.filelist

%else

%ifarch %{ix86}
%define basearch i686
%endif
%ifarch sparc sparcv9
%define basearch sparc
%endif

# auxarches get only these few source files
auxarches_debugsources=\
'/(generic|linux|%{basearch}|nptl(_db)?)/|/%{glibcsrcdir}/build|/dl-osinfo\.h'

egrep "$auxarches_debugsources" debuginfocommon.sources >> debuginfo.filelist

egrep -v "$auxarches_debugsources" \
  debuginfocommon.sources >> debuginfocommon.filelist

%endif

list_debug_archives >> debuginfocommon.filelist

%endif

%endif

rm -f $RPM_BUILD_ROOT%{_infodir}/dir

%ifarch %{auxarches}

echo Cutting down the list of unpackaged files
>> debuginfocommon.filelist
sed -e '/%%dir/d;/%%config/d;/%%verify/d;s/%%lang([^)]*) //;s#^/*##' \
    common.filelist devel.filelist static.filelist headers.filelist \
    utils.filelist nscd.filelist debuginfocommon.filelist |
(cd $RPM_BUILD_ROOT; xargs --no-run-if-empty rm -f 2> /dev/null || :)

%else

mkdir -p $RPM_BUILD_ROOT/var/{db,run}/nscd
touch $RPM_BUILD_ROOT/var/{db,run}/nscd/{passwd,group,hosts,services}
touch $RPM_BUILD_ROOT/var/run/nscd/{socket,nscd.pid}
%endif

# LTC: no locale archive during cross
%ifnarch %{auxarches} %{?cross_arches}
> $RPM_BUILD_ROOT/%{_prefix}/lib/locale/locale-archive
%endif

mkdir -p $RPM_BUILD_ROOT/var/cache/ldconfig
> $RPM_BUILD_ROOT/var/cache/ldconfig/aux-cache

# LTC BZ 91578: create multilib subpkgs (needed when weak arch repo isn't available, eg: s390)
# Generate this filelist after all the other subpackages have sed'd their stuff out of rpm.filelist.
%ifarch s390x
grep '/lib/' < rpm.filelist > multilib.filelist
sed -i -e '\|/lib/|d' rpm.filelist
%endif # end LTC multilib

# Steps to package the glibc tests for FIV
for dir in `cd fivextra/glibc; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/glibc/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

for files in `find $RPM_BUILD_ROOT/%{fivdir}/%{name}/ -type f -not -name '*.so'`
do
        if [[ ! `file $files | grep executable` ]]; then
                chmod 644 $files
        fi
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

# Steps to package the nscd tests for FIV
for dir in `cd fivextra/nscd; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/nscd/$dir
  install -m 755 `find fivextra/nscd/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/nscd/$dir
done

find $RPM_BUILD_ROOT/%{fivdir}/nscd -name '*.c' | xargs rm -rf

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/nscd
make install
popd

%pre -p <lua>
-- Check that the running kernel is new enough
required = '%{enablekernel}'
rel = posix.uname("%r")
if rpm.vercmp(rel, required) < 0 then
  error("FATAL: kernel too old", 0)
end

%post -p /usr/sbin/glibc_post_upgrade.%{_target_cpu}

%postun -p /sbin/ldconfig

%triggerin common -p <lua> -- glibc
if posix.stat("%{_prefix}/lib/locale/locale-archive.tmpl", "size") > 0 then
  pid = posix.fork()
  if pid == 0 then
    posix.exec("%{_prefix}/sbin/build-locale-archive")
  elseif pid > 0 then
    posix.wait(pid)
  end
end

%post common -p <lua>
if posix.access("/etc/ld.so.cache") then
  if posix.stat("%{_prefix}/lib/locale/locale-archive.tmpl", "size") > 0 then
    pid = posix.fork()
    if pid == 0 then
      posix.exec("%{_prefix}/sbin/build-locale-archive")
    elseif pid > 0 then
      posix.wait(pid)
    end
  end
end

%post devel
/sbin/install-info %{_infodir}/libc.info.gz %{_infodir}/dir > /dev/null 2>&1 || :

%pre headers
# this used to be a link and it is causing nightmares now
if [ -L %{_prefix}/include/scsi ] ; then
  rm -f %{_prefix}/include/scsi
fi

%preun devel
if [ "$1" = 0 ]; then
  /sbin/install-info --delete %{_infodir}/libc.info.gz %{_infodir}/dir > /dev/null 2>&1 || :
fi

%post utils -p /sbin/ldconfig

%postun utils -p /sbin/ldconfig

%pre -n nscd
getent group nscd >/dev/null || /usr/sbin/groupadd -g 28 -r nscd
getent passwd nscd >/dev/null ||
  /usr/sbin/useradd -M -o -r -d / -s /sbin/nologin \
		    -c "NSCD Daemon" -u 28 -g nscd nscd

%post -n nscd
%systemd_post nscd.service

%preun -n nscd
%systemd_preun nscd.service

%postun -n nscd
if test $1 = 0; then
  /usr/sbin/userdel nscd > /dev/null 2>&1 || :
fi
%systemd_postun_with_restart nscd.service

%if %{xenpackage}
%post xen -p /sbin/ldconfig
%postun xen -p /sbin/ldconfig
%endif

%clean
rm -rf "$RPM_BUILD_ROOT"
rm -f *.filelist*

%files -f rpm.filelist
%defattr(-,root,root)
%dir /usr/%{_lib}/audit
%ifarch %{rtkaioarches}
%dir /%{_lib}/rtkaio
%endif
%if %{buildxen} && !%{xenpackage}
%dir /%{_lib}/%{nosegneg_subdir_base}
%dir /%{_lib}/%{nosegneg_subdir}
%ifarch %{rtkaioarches}
%dir /%{_lib}/rtkaio/%{nosegneg_subdir_base}
%dir /%{_lib}/rtkaio/%{nosegneg_subdir}
%endif
%endif
%if %{buildpower6}
%dir /%{_lib}/power6
%dir /%{_lib}/power6x
%ifarch %{rtkaioarches}
%dir /%{_lib}/rtkaio/power6
%dir /%{_lib}/rtkaio/power6x
%endif
%endif
%ifarch s390x
/lib/ld64.so.1
%endif
%ifarch armv7hl armv7hnl 
/lib/ld-linux.so.3
%endif
%verify(not md5 size mtime) %config(noreplace) /etc/nsswitch.conf
%verify(not md5 size mtime) %config(noreplace) /etc/ld.so.conf
%verify(not md5 size mtime) %config(noreplace) /etc/rpc
%dir /etc/ld.so.conf.d
%dir %{_prefix}/libexec/getconf
%dir %{_prefix}/%{_lib}/gconv
%dir %attr(0700,root,root) /var/cache/ldconfig
%attr(0600,root,root) %verify(not md5 size mtime) %ghost %config(missingok,noreplace) /var/cache/ldconfig/aux-cache
%attr(0644,root,root) %verify(not md5 size mtime) %ghost %config(missingok,noreplace) /etc/ld.so.cache
%attr(0644,root,root) %verify(not md5 size mtime) %ghost %config(missingok,noreplace) /etc/gai.conf
%doc README NEWS INSTALL BUGS PROJECTS CONFORMANCE elf/rtld-debugger-interface.txt
%doc COPYING COPYING.LIB LICENSES
%doc hesiod/README.hesiod

%if %{xenpackage}
%files -f nosegneg.filelist xen
%defattr(-,root,root)
%dir /%{_lib}/%{nosegneg_subdir_base}
%dir /%{_lib}/%{nosegneg_subdir}
%endif

# LTC BZ 91578: create multilib subpkgs (needed when weak arch repo isn't available, eg: s390)
%ifarch s390x
%files -f multilib.filelist multilib
%defattr(-,root,root)
%ifarch %{rtkaioarches}
%dir /lib/rtkaio
%endif
%endif # end LTC multilib

%ifnarch %{auxarches}
%files -f common.filelist common
%defattr(-,root,root)
%if ! 0%{?cross_build}
%attr(0644,root,root) %verify(not md5 size mtime) %{_prefix}/lib/locale/locale-archive.tmpl
%attr(0644,root,root) %verify(not md5 size mtime mode) %ghost %config(missingok,noreplace) %{_prefix}/lib/locale/locale-archive
%endif # end not cross_build
%dir %attr(755,root,root) /etc/default
%verify(not md5 size mtime) %config(noreplace) /etc/default/nss
%doc documentation/*

%files -f devel.filelist devel
%defattr(-,root,root)

%files -f static.filelist static
%defattr(-,root,root)

%files -f headers.filelist headers
%defattr(-,root,root)

%files -f utils.filelist utils
%defattr(-,root,root)

%files -f nscd.filelist -n nscd
%defattr(-,root,root)
%config(noreplace) /etc/nscd.conf
%dir %attr(0755,root,root) /var/run/nscd
%dir %attr(0755,root,root) /var/db/nscd
/lib/systemd/system/nscd.service
/lib/systemd/system/nscd.socket
%{_tmpfilesdir}/nscd.conf
%attr(0644,root,root) %verify(not md5 size mtime) %ghost %config(missingok,noreplace) /var/run/nscd/nscd.pid
%attr(0666,root,root) %verify(not md5 size mtime) %ghost %config(missingok,noreplace) /var/run/nscd/socket
%attr(0600,root,root) %verify(not md5 size mtime) %ghost %config(missingok,noreplace) /var/run/nscd/passwd
%attr(0600,root,root) %verify(not md5 size mtime) %ghost %config(missingok,noreplace) /var/run/nscd/group
%attr(0600,root,root) %verify(not md5 size mtime) %ghost %config(missingok,noreplace) /var/run/nscd/hosts
%attr(0600,root,root) %verify(not md5 size mtime) %ghost %config(missingok,noreplace) /var/run/nscd/services
%attr(0600,root,root) %verify(not md5 size mtime) %ghost %config(missingok,noreplace) /var/db/nscd/passwd
%attr(0600,root,root) %verify(not md5 size mtime) %ghost %config(missingok,noreplace) /var/db/nscd/group
%attr(0600,root,root) %verify(not md5 size mtime) %ghost %config(missingok,noreplace) /var/db/nscd/hosts
%attr(0600,root,root) %verify(not md5 size mtime) %ghost %config(missingok,noreplace) /var/db/nscd/services
%ghost %config(missingok,noreplace) /etc/sysconfig/nscd
%endif

%if 0%{?_enable_debug_packages}
%files debuginfo -f debuginfo.filelist
%defattr(-,root,root)
%ifarch %{debuginfocommonarches}
%ifnarch %{auxarches}
%files debuginfo-common -f debuginfocommon.filelist
%defattr(-,root,root)
%endif
%endif
%endif

%files fivextra
%{prefix}

%changelog
* Fri Jan 24 2014 baseuser@ibm.com
- Base-f19.x spec file
