Name:		libjpeg-turbo
Version:	1.2.90
%define base_release .1
Release:	3%{?dist}%{?base_release}
Summary:	A MMX/SSE2 accelerated library for manipulating JPEG image files

Group:		System Environment/Libraries
License:	IJG
URL:		http://sourceforge.net/projects/libjpeg-turbo
Source0:	http://downloads.sourceforge.net/%{name}/%{name}-%{version}.tar.gz
BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

BuildRequires:	autoconf, automake, libtool
%ifarch %{ix86} x86_64
BuildRequires:	nasm
%endif

# moved this from -utils, in an attempt to get it to better override
# libjpeg in rawhide -- Rex
Obsoletes:	libjpeg < 6b-47
# add provides (even if it not needed) to workaround bad packages, like
# java-1.6.0-openjdk (#rh607554) -- atkac
Provides:	libjpeg = 6b-47%{?dist}
%if "%{?_isa}" != ""
Provides:	libjpeg%{_isa} = 6b-47%{?dist}
%endif

Patch0:		libjpeg-turbo12-noinst.patch
Patch1:		libjpeg-turbo-CVE-2013-6629.patch
Patch2:		libjpeg-turbo-CVE-2013-6630.patch

%description
The libjpeg-turbo package contains a library of functions for manipulating
JPEG images.

%package devel
Summary:	Headers for the libjpeg-turbo library
Group:		Development/Libraries
Obsoletes:	libjpeg-devel < 6b-47
Provides:	libjpeg-devel = 6b-47%{?dist}
%if "%{?_isa}" != ""
Provides:	libjpeg-devel%{_isa} = 6b-47%{?dist}
%endif
Requires:	libjpeg-turbo%{?_isa} = %{version}-%{release}

%description devel
This package contains header files necessary for developing programs which
will manipulate JPEG files using the libjpeg-turbo library.

%package utils
Summary:	Utilities for manipulating JPEG images
Group:		Applications/Multimedia
Requires:	libjpeg-turbo%{?_isa} = %{version}-%{release}

%description utils
The libjpeg-turbo-utils package contains simple client programs for
accessing the libjpeg functions. It contains cjpeg, djpeg, jpegtran,
rdjpgcom and wrjpgcom. Cjpeg compresses an image file into JPEG format.
Djpeg decompresses a JPEG file into a regular image file. Jpegtran
can perform various useful transformations on JPEG files. Rdjpgcom
displays any text comments included in a JPEG file. Wrjpgcom inserts
text comments into a JPEG file.

%package static
Summary:	Static version of the libjpeg-turbo library
Group:		Development/Libraries
Obsoletes:	libjpeg-static < 6b-47
Provides:	libjpeg-static = 6b-47%{?dist}
%if "%{?_isa}" != ""
Provides:	libjpeg-static%{_isa} = 6b-47%{?dist}
%endif
Requires:	libjpeg-turbo-devel%{?_isa} = %{version}-%{release}

%description static
The libjpeg-turbo-static package contains static library for manipulating
JPEG images.

%package -n turbojpeg
Summary:	TurboJPEG library
Group:		System Environment/Libraries

%description -n turbojpeg
The turbojpeg package contains the TurboJPEG shared library.

%package -n turbojpeg-devel
Summary:	Headers for the TurboJPEG library
Group:		Development/Libraries
Requires:	turbojpeg%{?_isa} = %{version}-%{release}

%description -n turbojpeg-devel
This package contains header files necessary for developing programs which
will manipulate JPEG files using the TurboJPEG library.

%prep
%setup -q

%patch0 -p1 -b .noinst
%patch1 -p1 -b .CVE-2013-6629
%patch2 -p1 -b .CVE-2013-6630

%build
autoreconf -fiv

%configure

make %{?_smp_mflags}

%install
rm -rf $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT

# Fix perms
chmod -x README-turbo.txt

# Remove unwanted files
rm -f $RPM_BUILD_ROOT/%{_libdir}/lib{,turbo}jpeg.la

# Don't distribute libjpegturbo.a
rm -f $RPM_BUILD_ROOT/%{_libdir}/libturbojpeg.a

%clean
rm -rf $RPM_BUILD_ROOT

%check
make test

%post -p /sbin/ldconfig
%postun -p /sbin/ldconfig

%post -n turbojpeg -p /sbin/ldconfig
%postun -n turbojpeg -p /sbin/ldconfig

%files
%defattr(-,root,root,-)
%doc README README-turbo.txt change.log ChangeLog.txt
%{_libdir}/libjpeg.so.62*

%files devel
%defattr(-,root,root,-)
%doc coderules.txt jconfig.txt libjpeg.txt structure.txt example.c
%{_includedir}/jconfig.h
%{_includedir}/jerror.h
%{_includedir}/jmorecfg.h
%{_includedir}/jpeglib.h
%{_libdir}/libjpeg.so

%files utils
%defattr(-,root,root,-)
%doc usage.txt wizard.txt
%{_bindir}/cjpeg
%{_bindir}/djpeg
%{_bindir}/jpegtran
%{_bindir}/rdjpgcom
%{_bindir}/wrjpgcom
%{_mandir}/man1/cjpeg.1*
%{_mandir}/man1/djpeg.1*
%{_mandir}/man1/jpegtran.1*
%{_mandir}/man1/rdjpgcom.1*
%{_mandir}/man1/wrjpgcom.1*

%files static
%defattr(-,root,root,-)
%{_libdir}/libjpeg.a

%files -n turbojpeg
%{_libdir}/libturbojpeg.so.0*

%files -n turbojpeg-devel
%{_includedir}/turbojpeg.h
%{_libdir}/libturbojpeg.so

%changelog
* Wed May 29 2013 baseuser@ibm.com
- Base-8.x spec file
