%global oname tgt
%ifnarch s390 s390x
%global with_rdma 1
%endif

Name:           scsi-target-utils
Version:        1.0.38
%define base_release .2
Release:        1%{?dist}%{?base_release}
# MCP: exclude cross arches for this package
ExcludeArch: %{cross_arches}
Summary:        The SCSI target daemon and utility programs

Group:          System Environment/Daemons
License:        GPLv2
URL:            http://stgt.sourceforge.net/
Source0:        http://fujita.github.com/tgt/downloads/%{oname}-%{version}.tar.gz
Source1:        tgtd.service
Source2:        sysconfig.tgtd
Source3:        targets.conf
Source4:        sample.conf
Source5:        tgtd.conf
Source999:      fivextra.tar.bz2
Patch0:         scsi-target-utils-redhatify-docs.patch
Patch1:         scsi-target-utils-remove-xsltproc-check.patch
Patch2:         scsi-target-utils-include-dirs.patch
Patch3:         scsi-target-utils-default-config.patch

BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

BuildRequires:  pkgconfig libxslt docbook-style-xsl systemd-units
%if 0%{?with_rdma}
BuildRequires:  libibverbs-devel librdmacm-devel
Requires:       libibverbs librdmacm
%endif
Requires: lsof sg3_utils
Requires(post): systemd-units

%description
The SCSI target package contains the daemon and tools to setup a SCSI targets.
Currently, software iSCSI targets are supported.

%package fivextra
Summary: Test for %{name} package
Group:  fivextra

%description fivextra
This package contains testcases for %{name}.

%prep
%setup -q -n %{oname}-%{version} -a 999
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1

%build
%{__sed} -i -e 's|-g -O2 -Wall|%{optflags}|' Makefile
%{__make} %{?_smp_mflags} %{?with_rdma:ISCSI_RDMA=1} libdir=%{_libdir}/tgt


%install
%{__rm} -rf %{buildroot}
%{__install} -d %{buildroot}%{_sbindir}
%{__install} -d %{buildroot}%{_mandir}/man5
%{__install} -d %{buildroot}%{_mandir}/man8
%{__install} -d %{buildroot}%{_unitdir}
%{__install} -d %{buildroot}%{_sysconfdir}/tgt
%{__install} -d %{buildroot}%{_sysconfdir}/tgt/conf.d
%{__install} -d %{buildroot}%{_sysconfdir}/sysconfig

%{__install} -p -m 0755 scripts/tgt-setup-lun %{buildroot}%{_sbindir}
%{__install} -p -m 0755 %{SOURCE1} %{buildroot}%{_unitdir}
%{__install} -p -m 0755 scripts/tgt-admin %{buildroot}/%{_sbindir}/tgt-admin
%{__install} -p -m 0644 doc/manpages/targets.conf.5 %{buildroot}/%{_mandir}/man5
%{__install} -p -m 0644 doc/manpages/tgtadm.8 %{buildroot}/%{_mandir}/man8
%{__install} -p -m 0644 doc/manpages/tgt-admin.8 %{buildroot}/%{_mandir}/man8
%{__install} -p -m 0644 doc/manpages/tgt-setup-lun.8 %{buildroot}/%{_mandir}/man8
%{__install} -p -m 0600 %{SOURCE2} %{buildroot}%{_sysconfdir}/sysconfig/tgtd
%{__install} -p -m 0600 %{SOURCE3} %{buildroot}%{_sysconfdir}/tgt
%{__install} -p -m 0600 %{SOURCE4} %{buildroot}%{_sysconfdir}/tgt/conf.d
%{__install} -p -m 0600 %{SOURCE5} %{buildroot}%{_sysconfdir}/tgt

pushd usr
%{__make} install %{?with_rdma:ISCSI_RDMA=1} DESTDIR=%{buildroot} sbindir=%{_sbindir} libdir=%{_libdir}/tgt
popd

# Steps to package the scsi-target-utils tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
       install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
       install -m 755 `find fivextra/$dir/* -type d -prune -o -print`  $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done 

%post
if [ $1 -eq 1 ]; then
    systemctl daemon-reload >/dev/null 2>&1 || :
fi

%preun
if [ $1 -eq 0 ]; then
    systemctl --no-reload disable tgtd.service >/dev/null 2>&1 || :
    systemctl stop tgtd.service >/dev/null 2>&1 || :
fi

%postun
if [ $1 -ge 1 ]; then
    systemctl try-restart %{name}.service >/dev/null 2>&1 || :
fi


%clean
%{__rm} -rf %{buildroot}


%files
%defattr(-, root, root, -)
%doc README doc/README.iscsi doc/README.iser doc/README.lu_configuration doc/README.mmc doc/README.ssc
%{_sbindir}/tgtd
%{_sbindir}/tgtadm
%{_sbindir}/tgt-setup-lun
%{_sbindir}/tgt-admin
%{_sbindir}/tgtimg
%{_mandir}/man5/*
%{_mandir}/man8/*
%{_unitdir}/tgtd.service
%attr(0600,root,root) %config(noreplace) %{_sysconfdir}/sysconfig/tgtd
%attr(0600,root,root) %config(noreplace) %{_sysconfdir}/tgt/targets.conf
%attr(0600,root,root) %config(noreplace) %{_sysconfdir}/tgt/tgtd.conf
%attr(0600,root,root) %config(noreplace) %{_sysconfdir}/tgt/conf.d/sample.conf

%files fivextra
%{fivdir}


%changelog
* Fri Aug 16 2013 baseuser@ibm.com
- Base-8.x spec file
