%global snap 20121213

Summary:	The NetBSD Editline library
Name:		libedit
Version:	3.0
%define base_release .2
Release:	10.%{snap}cvs%{?dist}%{?base_release}
License:	BSD
Group:		System Environment/Libraries
URL:		http://www.thrysoee.dk/editline/
Source0:	http://www.thrysoee.dk/editline/%{name}-%{snap}-%{version}.tar.gz
Source999:     fivextra.tar.bz2

BuildRequires:	ncurses-devel

%description
Libedit is an autotool- and libtoolized port of the NetBSD Editline library.
It provides generic line editing, history, and tokenization functions, similar
to those found in GNU Readline.

%package devel
Summary:	Development files for %{name}
Group:		Development/Libraries

Requires:	%{name} = %{version}-%{release}
Requires:	pkgconfig
Requires:	ncurses-devel

%description devel
This package contains development files for %{name}.

%package fivextra
Summary: Test for %{name} package
Group: fivextra
Prefix: /opt/fiv/ltp
Requires: expect

%description fivextra
This package contains testcases for %{name}

%prep
%setup -q -n %{name}-%{snap}-%{version} -a 999

# Suppress rpmlint error.
iconv -f ISO8859-1 -t UTF-8 -o ChangeLog.utf-8 ChangeLog
touch -r ChangeLog ChangeLog.utf-8
mv -f ChangeLog.utf-8 ChangeLog

%build
%configure --disable-static --enable-widec

# Fix unused direct shared library dependencies.
sed -i "s/lcurses/ltinfo/" src/Makefile

make %{?_smp_mflags}

pushd fivextra
make all
popd

%install
make install INSTALL="%{__install} -p" DESTDIR=$RPM_BUILD_ROOT
find $RPM_BUILD_ROOT -type f -name "*.la" -delete

# Steps to package the libedit tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd


%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%doc ChangeLog COPYING THANKS
%{_libdir}/%{name}.so.*

%files devel
%doc examples/fileman.c examples/tc1.c examples/wtc1.c
%doc %{_mandir}/man3/*
%doc %{_mandir}/man5/editrc.5*
%{_includedir}/histedit.h
%{_libdir}/%{name}.so
%{_libdir}/pkgconfig/%{name}.pc

%dir %{_includedir}/editline
%{_includedir}/editline/readline.h

%files fivextra
%{prefix}

%changelog
* Mon May 13 2013 baseuser@ibm.com
- Base-8.x spec file
