Summary: Utilities for working with md5sum implanted in ISO images
Name: isomd5sum
Version: 1.0.10
%define base_release .3
Release: 1%{?dist}%{?base_release}
# Base: exclude cross arches for this package
ExcludeArch: mips64 ppca2 ppc476 ppcnf
Epoch: 1
License: GPLv2+
Group: Applications/System
URL: http://git.fedorahosted.org/git/?p=isomd5sum.git;a=summary
Source0: http://fedorahosted.org/releases/i/s/isomd5sum/%{name}-%{version}.tar.bz2
Source999: fivextra.tar.bz2
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root
BuildRequires: popt-devel

%description
The isomd5sum package contains utilities for implanting and verifying
an md5sum implanted into an ISO9660 image.

%package devel
Summary: Development headers and library for using isomd5sum 
Group: Development/System
Requires: %{name} = %{epoch}:%{version}-%{release}
Provides: %{name}-static = %{epoch}:%{version}-%{release}

%description devel
This contains header files and a library for working with the isomd5sum
implanting and checking.

%package -n python-isomd5sum
Summary: Python bindings for isomd5sum
BuildRequires: python-devel

%description -n python-isomd5sum
Python bindings for isomd5sum

%package fivextra
Summary: FIV Tests for %{name}
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains the testcases built from the package for %{name}

%package -n python-isomd5sum-fivextra
Summary: Test for python-isomd5sum package
Group:  fivextra
Prefix: /opt/fiv/ltp

%description -n python-isomd5sum-fivextra
This package contains testcases for python-isomd5sum.

%prep
%setup -q -a 999

%build
CFLAGS="$RPM_OPT_FLAGS -Wno-strict-aliasing"; export CFLAGS
make checkisomd5 implantisomd5 pyisomd5sum.so

%install
rm -rf $RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT install-bin install-devel install-python

for dir in `cd fivextra/%{name}; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install `find fivextra/%{name}/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir || true
done

# Steps to package the python-isomd5sum tests for FIV
for dir in `cd fivextra/python-isomd5sum; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/python-isomd5sum/$dir
  install -m 755 `find fivextra/python-isomd5sum/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/python-isomd5sum/$dir
done

install -m 755 testpyisomd5sum.py $RPM_BUILD_ROOT/%{fivdir}/python-isomd5sum/

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd
pushd $RPM_BUILD_ROOT/%{fivdir}/python-isomd5sum
make install
popd

%clean
rm -rf $RPM_BUILD_ROOT


%files
%defattr(-,root,root,-)
%doc COPYING
/usr/bin/implantisomd5
/usr/bin/checkisomd5
%{_mandir}/man*/*

%files devel
%defattr(-,root,root,-)
%{_includedir}/*.h
%{_libdir}/*.a

%files -n python-isomd5sum
%defattr(-,root,root,-)
%{python_sitearch}/pyisomd5sum.so

%files fivextra
%{prefix}/testcases/bin/isomd5sum.sh
%{fivdir}/%{name}

%files -n python-isomd5sum-fivextra
%{prefix}/testcases/bin/python-isomd5sum.sh
%{fivdir}/python-isomd5sum

%changelog
* Thu Jul 11 2013 baseuser@ibm.com
- Base-8.x spec file
