Name:		liblognorm
Version:	0.3.5
%define base_release .3
Release:	1%{?dist}%{?base_release}
Summary:	Fast samples-based log normalization library
ExcludeArch: mips64 ppca2 
License:	LGPLv2+
URL:		http://www.liblognorm.com
Source0:	http://www.liblognorm.com/files/download/%{name}-%{version}.tar.gz
Patch1:		liblognorm-0.3.4-pc-file.patch

BuildRequires:	libestr-devel, libee-devel, chrpath

%description
Briefly described, liblognorm is a tool to normalize log data.

People who need to take a look at logs often have a common problem. Logs from
different machines (from different vendors) usually have different formats for
their logs. Even if it is the same type of log (e.g. from firewalls), the log
entries are so different, that it is pretty hard to read these. This is where
liblognorm comes into the game. With this tool you can normalize all your logs.
All you need is liblognorm and its dependencies and a sample database that fits
the logs you want to normalize.

%package devel
Summary:	Development tools for programs using liblognorm library
Requires:	%{name}%{?_isa} = %{version}-%{release}
Requires:	libee-devel%{?_isa} libestr-devel%{?_isa}

%description devel
The liblognorm-devel package includes header files, libraries necessary for
developing programs which use liblognorm library.

%package utils
Summary:	Lognormalizer utility for normalizing log files
Requires:	%{name}%{?_isa} = %{version}-%{release}

%description utils
The lognormalizer is the core of liblognorm, it is a utility for normalizing
log files.

%prep
%setup -q
%patch1 -p1 -b .pc-file.patch

%build
%configure
V=1 make

%install
make install INSTALL="install -p" DESTDIR=%{buildroot}
rm -f %{buildroot}/%{_libdir}/*.{a,la}

# chrpath can't be run against non-native executables.
%{!?cross_build:chrpath -d %{buildroot}/%{_bindir}/lognormalizer}
%{!?cross_build:chrpath -d %{buildroot}/%{_libdir}/liblognorm.so.0.0.0}

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%doc AUTHORS ChangeLog COPYING NEWS README
%{_libdir}/lib*.so.*

%files devel
%{_libdir}/lib*.so
%{_includedir}/*.h
%{_libdir}/pkgconfig/*.pc

%files utils
%{_bindir}/lognormalizer


%changelog
* Mon Jun 24 2013 baseuser@ibm.com
- Base-8.x spec file
