Name:           libservicelog
Version:        1.1.13
%define base_release .2
Release:        1%{?dist}%{?base_release}
Summary:        Servicelog Database and Library

Group:          System Environment/Libraries
License:        LGPLv2
URL:            http://linux-diag.sourceforge.net/servicelog
Source0:        http://downloads.sourceforge.net/linux-diag/%{name}-%{version}.tar.gz
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

Requires(pre):       shadow-utils

BuildRequires:  sqlite-devel autoconf libtool bison librtas-devel flex

# because of librtas-devel
ExclusiveArch: ppc ppc64


# Link with needed libraries
Patch0: libservicelog-1.1.9-libs.patch

%description
The libservicelog package contains a library to create and maintain a
database for storing events related to system service.  This database
allows for the logging of serviceable and informational events, and for
the logging of service procedures that have been performed upon the system.


%package        devel
Summary:        Development files for %{name}
Group:          Development/Libraries
Requires:       %{name} = %{version}-%{release}
Requires:       pkgconfig sqlite-devel

%description    devel
Contains header files for building with libservicelog.


%prep
%setup -q
%patch0 -p1 -b .libs

%build
autoreconf -fiv
%configure --disable-static
%{__make} %{?_smp_mflags}


%install
%{__rm} -rf $RPM_BUILD_ROOT
%{__make} install DESTDIR=$RPM_BUILD_ROOT
%{__rm} -f %{buildroot}%{_libdir}/*.la


%clean
%{__rm} -rf $RPM_BUILD_ROOT

%pre
getent group service >/dev/null || /usr/sbin/groupadd service

%post -p /sbin/ldconfig

%postun
/sbin/ldconfig

%files
%defattr(-,root,root,-)
%doc COPYING NEWS AUTHORS
%{_libdir}/libservicelog-*.so.*
%ghost %verify(not md5 size mtime) %attr(644,root,service) %dir /var/lib/servicelog/servicelog.db
%dir /var/lib/servicelog

%files devel
%defattr(-,root,root,-)
%{_includedir}/servicelog-1
%{_libdir}/*.so
%{_libdir}/pkgconfig/servicelog-1.pc


%changelog
* Wed Aug 21 2013 baseuser@ibm.com
- Base-8.x spec file
